/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.content.Context;
import android.graphics.Point;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.SystemUtils;

final class AppInfo {
    private static final String TAG = AppInfo.class.getSimpleName();
    private static final int ANDROID_SDK_VERSION_BASE = 2000;
    private static String packageName;
    private static int deviceScreenWidth;
    private String accountID;
    private String domain;

    AppInfo(Context context, String accountID, String domain) {
        if (accountID == null) {
            throw new NullPointerException("Account ID cannot be null");
        }
        this.accountID = accountID;
        try {
            if (packageName == null) {
                packageName = context.getPackageName();
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        this.domain = domain;
        try {
            if (deviceScreenWidth == -1) {
                Point size = SystemUtils.getScreenSize(context);
                deviceScreenWidth = size.x;
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public String toString() {
        return "Chartbeat tracking SDK (" + this.getSdkVersion() + "): " + this.getAccountID() + "|" + this.getPackageName() + "|" + this.getDomain();
    }

    String getDomain() {
        return this.domain;
    }

    String getPackageName() {
        return packageName;
    }

    String getAccountID() {
        return this.accountID;
    }

    String getSdkVersion() {
        return String.valueOf(2012);
    }

    String getDeviceScreenWidth() {
        return String.valueOf(deviceScreenWidth);
    }

    static {
        deviceScreenWidth = -1;
    }
}

