/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.walker;

import cfml.CFSCRIPTParser;
import cfml.CFSCRIPTParserBaseVisitor;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFullVarExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.script.CFAbortStatement;
import cfml.parsing.cfscript.script.CFAdminStatement;
import cfml.parsing.cfscript.script.CFBreakStatement;
import cfml.parsing.cfscript.script.CFCase;
import cfml.parsing.cfscript.script.CFCatchStatement;
import cfml.parsing.cfscript.script.CFCompDeclStatement;
import cfml.parsing.cfscript.script.CFCompoundStatement;
import cfml.parsing.cfscript.script.CFContinueStatement;
import cfml.parsing.cfscript.script.CFDoWhileStatement;
import cfml.parsing.cfscript.script.CFExitStatement;
import cfml.parsing.cfscript.script.CFExpressionStatement;
import cfml.parsing.cfscript.script.CFForInStatement;
import cfml.parsing.cfscript.script.CFForStatement;
import cfml.parsing.cfscript.script.CFFuncDeclStatement;
import cfml.parsing.cfscript.script.CFFunctionParameter;
import cfml.parsing.cfscript.script.CFIfStatement;
import cfml.parsing.cfscript.script.CFImportStatement;
import cfml.parsing.cfscript.script.CFIncludeStatement;
import cfml.parsing.cfscript.script.CFLockStatement;
import cfml.parsing.cfscript.script.CFMLFunctionStatement;
import cfml.parsing.cfscript.script.CFParamStatement;
import cfml.parsing.cfscript.script.CFParsedAttributeStatement;
import cfml.parsing.cfscript.script.CFPropertyStatement;
import cfml.parsing.cfscript.script.CFReThrowStatement;
import cfml.parsing.cfscript.script.CFReturnStatement;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.script.CFSwitchStatement;
import cfml.parsing.cfscript.script.CFThreadStatement;
import cfml.parsing.cfscript.script.CFThrowStatement;
import cfml.parsing.cfscript.script.CFTransactionStatement;
import cfml.parsing.cfscript.script.CFTryCatchStatement;
import cfml.parsing.cfscript.script.CFWhileStatement;
import cfml.parsing.cfscript.walker.CFExpressionVisitor;
import cfml.parsing.util.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class CFScriptStatementVisitor
extends CFSCRIPTParserBaseVisitor<CFScriptStatement> {
    Stack<Object> aggregator = new Stack();
    CFExpressionVisitor cfExpressionVisitor = new CFExpressionVisitor();

    @Override
    public CFScriptStatement visitScriptBlock(CFSCRIPTParser.ScriptBlockContext ctx) {
        return (CFScriptStatement)super.visitScriptBlock(ctx);
    }

    @Override
    public CFScriptStatement visitComponentDeclaration(CFSCRIPTParser.ComponentDeclarationContext ctx) {
        LinkedHashMap<CFExpression, CFExpression> _attr = new LinkedHashMap<CFExpression, CFExpression>();
        CFCompDeclStatement compDeclStatement = new CFCompDeclStatement(ctx.COMPONENT().getSymbol(), _attr, (CFScriptStatement)this.visit((ParseTree)ctx.componentGuts()));
        for (CFSCRIPTParser.ComponentAttributeContext attr : ctx.componentAttribute()) {
            CFIdentifier name = (CFIdentifier)this.visitExpression((ParseTree)attr.id);
            if (attr.prefix != null) {
                CFFullVarExpression fullVar = new CFFullVarExpression(attr.prefix.getStart(), name);
                fullVar.addMember(this.visitExpression((ParseTree)attr.prefix));
                _attr.put(fullVar, this.visitExpression((ParseTree)attr.startExpression()));
                continue;
            }
            _attr.put(name, this.visitExpression((ParseTree)attr.startExpression()));
        }
        return compDeclStatement;
    }

    @Override
    public CFScriptStatement visitFunctionDeclaration(CFSCRIPTParser.FunctionDeclarationContext ctx) {
        ArrayList<CFFunctionParameter> parameters = new ArrayList<CFFunctionParameter>();
        this.aggregator.push(parameters);
        this.visitChildren((RuleNode)ctx.parameterList());
        this.aggregator.pop();
        LinkedHashMap<CFExpression, CFExpression> attributes = new LinkedHashMap<CFExpression, CFExpression>();
        for (CFSCRIPTParser.FunctionAttributeContext attr : ctx.functionAttribute()) {
            ParserRuleContext idAttr = attr.identifierWithColon() != null ? attr.identifierWithColon() : attr.id;
            CFExpression name = (CFExpression)this.cfExpressionVisitor.visit((ParseTree)idAttr);
            CFExpression value = attr.value != null ? (CFExpression)this.cfExpressionVisitor.visit((ParseTree)attr.value) : null;
            CFExpression stringValue = attr.valueString != null ? (CFExpression)this.cfExpressionVisitor.visit((ParseTree)attr.valueString) : null;
            attributes.put(name, value != null ? value : stringValue);
        }
        CFFuncDeclStatement funcDeclStatement = new CFFuncDeclStatement(ctx.FUNCTION().getSymbol(), (CFIdentifier)this.visitExpression((ParseTree)ctx.identifier()), this.getText((ParseTree)ctx.accessType()), (CFIdentifier)this.visitExpression((ParseTree)ctx.typeSpec()), parameters, attributes, (CFScriptStatement)this.visit((ParseTree)ctx.body));
        return funcDeclStatement;
    }

    @Override
    public CFScriptStatement visitAnonymousFunctionDeclaration(CFSCRIPTParser.AnonymousFunctionDeclarationContext ctx) {
        ArrayList<CFFunctionParameter> parameters = new ArrayList<CFFunctionParameter>();
        this.aggregator.push(parameters);
        this.visitChildren((RuleNode)ctx.parameterList());
        this.aggregator.pop();
        LinkedHashMap<CFExpression, CFExpression> attributes = new LinkedHashMap<CFExpression, CFExpression>();
        for (CFSCRIPTParser.FunctionAttributeContext attr : ctx.functionAttribute()) {
            ParserRuleContext idAttr = attr.identifierWithColon() != null ? attr.identifierWithColon() : attr.id;
            CFExpression name = (CFExpression)this.cfExpressionVisitor.visit((ParseTree)idAttr);
            CFExpression value = attr.value != null ? (CFExpression)this.cfExpressionVisitor.visit((ParseTree)attr.value) : null;
            CFExpression stringValue = attr.valueString != null ? (CFExpression)this.cfExpressionVisitor.visit((ParseTree)attr.valueString) : null;
            attributes.put(name, value != null ? value : stringValue);
        }
        CFFuncDeclStatement funcDeclStatement = new CFFuncDeclStatement(ctx.FUNCTION().getSymbol(), null, this.getText((ParseTree)ctx.accessType()), (CFIdentifier)this.visitExpression((ParseTree)ctx.typeSpec()), parameters, attributes, (CFScriptStatement)this.visit((ParseTree)ctx.body));
        return funcDeclStatement;
    }

    @Override
    public CFScriptStatement visitParameter(CFSCRIPTParser.ParameterContext ctx) {
        CFExpression defaultExpr = ctx.startExpression() != null ? (CFExpression)this.cfExpressionVisitor.visitStartExpression(ctx.startExpression()) : null;
        CFFunctionParameter functionParameter = new CFFunctionParameter((CFIdentifier)this.cfExpressionVisitor.visitIdentifier(ctx.identifier()), ctx.REQUIRED() != null, this.getText((ParseTree)ctx.parameterType()), defaultExpr);
        if (!this.aggregator.isEmpty() && this.aggregator.peek() instanceof List) {
            ((List)this.aggregator.peek()).add(functionParameter);
        }
        return (CFScriptStatement)super.visitParameter(ctx);
    }

    @Override
    public CFScriptStatement visitCompoundStatement(CFSCRIPTParser.CompoundStatementContext ctx) {
        CFCompoundStatement compoundStatement = new CFCompoundStatement(ctx.getStart());
        if (ctx.statement().size() > 0) {
            this.aggregator.push(compoundStatement);
            CFScriptStatement result = (CFScriptStatement)this.visitChildren((RuleNode)ctx);
            if (result != compoundStatement) {
                compoundStatement.add(result);
            }
            this.aggregator.pop();
        }
        return compoundStatement;
    }

    @Override
    public CFScriptStatement visitStatement(CFSCRIPTParser.StatementContext ctx) {
        if (ctx.getChild(0) instanceof CFSCRIPTParser.LocalAssignmentExpressionContext || ctx.getChild(0) instanceof CFSCRIPTParser.AssignmentExpressionContext || ctx.getChild(0) instanceof CFSCRIPTParser.BaseExpressionContext || ctx.getChild(0) instanceof CFSCRIPTParser.CompareExpressionContext || ctx.getChild(0) instanceof CFSCRIPTParser.FunctionCallContext || ctx.getChild(0) instanceof CFSCRIPTParser.QualifiedFunctionCallContext) {
            CFExpressionStatement expressionStmt = new CFExpressionStatement((CFExpression)this.cfExpressionVisitor.visit(ctx.getChild(0)));
            return expressionStmt;
        }
        return (CFScriptStatement)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public CFScriptStatement visitTagFunctionStatement(CFSCRIPTParser.TagFunctionStatementContext ctx) {
        CFExpressionStatement expressionStmt = new CFExpressionStatement((CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx));
        return expressionStmt;
    }

    @Override
    public CFScriptStatement visitReturnStatement(CFSCRIPTParser.ReturnStatementContext ctx) {
        CFReturnStatement returnStatement = new CFReturnStatement(ctx.getStart(), ctx.getChild(1) != null ? (CFExpression)this.cfExpressionVisitor.visit(ctx.getChild(1)) : null);
        return returnStatement;
    }

    @Override
    public CFScriptStatement visitIfStatement(CFSCRIPTParser.IfStatementContext ctx) {
        CFIfStatement ifStatement = new CFIfStatement(ctx.getStart(), (CFExpression)this.cfExpressionVisitor.visit(ctx.getChild(1)), (CFScriptStatement)this.visit(ctx.getChild(2)), ctx.getChildCount() > 4 ? (CFScriptStatement)this.visit(ctx.getChild(4)) : null);
        return ifStatement;
    }

    @Override
    public CFScriptStatement visitWhileStatement(CFSCRIPTParser.WhileStatementContext ctx) {
        CFWhileStatement whileStatement = new CFWhileStatement(ctx.WHILE().getSymbol(), this.visitExpression((ParseTree)ctx.condition()), (CFScriptStatement)this.visit((ParseTree)ctx.statement()));
        return whileStatement;
    }

    @Override
    public CFScriptStatement visitDoWhileStatement(CFSCRIPTParser.DoWhileStatementContext ctx) {
        CFDoWhileStatement doWhileStatement = new CFDoWhileStatement(ctx.DO().getSymbol(), this.visitExpression((ParseTree)ctx.condition()), (CFScriptStatement)this.visit((ParseTree)ctx.statement()));
        return doWhileStatement;
    }

    @Override
    public CFScriptStatement visitForStatement(CFSCRIPTParser.ForStatementContext ctx) {
        if (ctx.forInKey() != null) {
            CFForInStatement forInStatement = new CFForInStatement(ctx.FOR().getSymbol(), (CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.forInKey()), (CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.inExpr), (CFScriptStatement)this.visit((ParseTree)ctx.statement()));
            return forInStatement;
        }
        ParserRuleContext localOrInit = ExpressionUtils.coalesce(ctx.localAssignmentExpression(), ctx.initExpression);
        CFExpression LocalOrInitVisited = localOrInit != null ? (CFExpression)this.cfExpressionVisitor.visit((ParseTree)localOrInit) : null;
        CFForStatement forStatement = new CFForStatement(ctx.FOR().getSymbol(), LocalOrInitVisited, (CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.condExpression), (CFExpression)this.cfExpressionVisitor.visit((ParseTree)ExpressionUtils.coalesce(ctx.incrExpression, ctx.incrExpression2)), (CFScriptStatement)this.visit((ParseTree)ctx.statement()));
        return forStatement;
    }

    @Override
    public CFScriptStatement visitTryCatchStatement(CFSCRIPTParser.TryCatchStatementContext ctx) {
        ArrayList<CFCatchStatement> _catches = new ArrayList<CFCatchStatement>();
        for (CFSCRIPTParser.CatchConditionContext catchCond : ctx.catchCondition()) {
            CFCatchStatement clause = new CFCatchStatement(this.getText((ParseTree)catchCond.typeSpec()), (CFIdentifier)this.cfExpressionVisitor.visit((ParseTree)catchCond.identifier()), (CFScriptStatement)this.visit((ParseTree)catchCond.compoundStatement()));
            _catches.add(clause);
        }
        CFTryCatchStatement tryCatchStatement = new CFTryCatchStatement(ctx.start, (CFScriptStatement)this.visit((ParseTree)ctx.statement()), _catches, this.visitNullSafe((ParseTree)ctx.finallyStatement()));
        return tryCatchStatement;
    }

    @Override
    public CFScriptStatement visitCatchCondition(CFSCRIPTParser.CatchConditionContext ctx) {
        return new CFCatchStatement((CFIdentifier)this.visit((ParseTree)ctx.typeSpec()), (CFIdentifier)this.visit((ParseTree)ctx.identifier()), (CFScriptStatement)this.visit((ParseTree)ctx.compoundStatement()));
    }

    @Override
    public CFScriptStatement visitSwitchStatement(CFSCRIPTParser.SwitchStatementContext ctx) {
        ArrayList<CFCase> _cases = new ArrayList<CFCase>();
        CFSwitchStatement switchStatement = new CFSwitchStatement(ctx.SWITCH().getSymbol(), (CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.condition()), _cases);
        this.aggregator.push(switchStatement);
        for (CFSCRIPTParser.CaseStatementContext caseSt : ctx.caseStatement()) {
            _cases.add((CFCase)this.visit((ParseTree)caseSt));
        }
        this.aggregator.pop();
        return switchStatement;
    }

    @Override
    public CFScriptStatement visitCaseStatement(CFSCRIPTParser.CaseStatementContext ctx) {
        ArrayList<CFScriptStatement> statements = new ArrayList<CFScriptStatement>();
        for (CFSCRIPTParser.StatementContext statement : ctx.statement()) {
            CFScriptStatement st = (CFScriptStatement)this.visit((ParseTree)statement);
            if (st == null) continue;
            statements.add(st);
        }
        if (ctx.DEFAULT() != null) {
            return new CFCase(statements);
        }
        if (ctx.constantExpression() != null) {
            return new CFCase((CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.constantExpression()), statements);
        }
        return new CFCase((CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.memberExpression()), statements);
    }

    @Override
    public CFScriptStatement visitBreakStatement(CFSCRIPTParser.BreakStatementContext ctx) {
        return new CFBreakStatement(ctx.BREAK().getSymbol());
    }

    @Override
    public CFScriptStatement visitContinueStatement(CFSCRIPTParser.ContinueStatementContext ctx) {
        return new CFContinueStatement(ctx.CONTINUE().getSymbol());
    }

    @Override
    public CFScriptStatement visitRethrowStatment(CFSCRIPTParser.RethrowStatmentContext ctx) {
        return new CFReThrowStatement(ctx.RETHROW().getSymbol());
    }

    @Override
    public CFScriptStatement visitIncludeStatement(CFSCRIPTParser.IncludeStatementContext ctx) {
        CFIncludeStatement includeStatement = new CFIncludeStatement(ctx.INCLUDE().getSymbol(), (CFExpression)this.cfExpressionVisitor.visit((ParseTree)ctx.baseExpression()));
        return includeStatement;
    }

    @Override
    public CFScriptStatement visitImportStatement(CFSCRIPTParser.ImportStatementContext ctx) {
        CFImportStatement importStatement = new CFImportStatement(ctx.IMPORT().getSymbol(), this.visitExpression((ParseTree)ctx.componentPath()), ctx.all != null);
        return importStatement;
    }

    @Override
    public CFScriptStatement visitTransactionStatement(CFSCRIPTParser.TransactionStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attr = new HashMap<CFIdentifier, CFExpression>();
        CFTransactionStatement transactionStatement = new CFTransactionStatement(ctx.TRANSACTION().getSymbol(), _attr, this.visitNullSafe((ParseTree)ctx.compoundStatement()));
        if (ctx.paramStatementAttributes() != null) {
            this.aggregator.push(transactionStatement);
            this.visitChildren((RuleNode)ctx.paramStatementAttributes());
            this.aggregator.pop();
        }
        return transactionStatement;
    }

    @Override
    public CFScriptStatement visitCfmlfunctionStatement(CFSCRIPTParser.CfmlfunctionStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attr = new HashMap<CFIdentifier, CFExpression>();
        CFMLFunctionStatement cfmlFunctionStatement = new CFMLFunctionStatement(ctx.start, ctx.cfmlFunction().start, _attr, this.visitNullSafe((ParseTree)ctx.compoundStatement()));
        if (ctx.paramStatementAttributes() != null) {
            this.aggregator.push(cfmlFunctionStatement);
            this.visitChildren((RuleNode)ctx.paramStatementAttributes());
            this.aggregator.pop();
        }
        return cfmlFunctionStatement;
    }

    @Override
    public CFScriptStatement visitLockStatement(CFSCRIPTParser.LockStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attr = new HashMap<CFIdentifier, CFExpression>();
        CFLockStatement lockStatement = new CFLockStatement(ctx.LOCK().getSymbol(), _attr, (CFScriptStatement)this.visit((ParseTree)ctx.compoundStatement()));
        this.aggregator.push(lockStatement);
        this.visitChildren((RuleNode)ctx.paramStatementAttributes());
        this.aggregator.pop();
        return lockStatement;
    }

    @Override
    public CFScriptStatement visitThreadStatement(CFSCRIPTParser.ThreadStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attr = new HashMap<CFIdentifier, CFExpression>();
        CFThreadStatement threadStatement = new CFThreadStatement(ctx.THREAD().getSymbol(), _attr, this.visitNullSafe((ParseTree)ctx.compoundStatement()));
        this.aggregator.push(threadStatement);
        this.visitChildren((RuleNode)ctx.paramStatementAttributes());
        this.aggregator.pop();
        return threadStatement;
    }

    @Override
    public CFScriptStatement visitAbortStatement(CFSCRIPTParser.AbortStatementContext ctx) {
        CFAbortStatement abortStatement = new CFAbortStatement(ctx.ABORT().getSymbol(), this.visitExpression((ParseTree)ctx.memberExpression()));
        return abortStatement;
    }

    @Override
    public CFScriptStatement visitAdminStatement(CFSCRIPTParser.AdminStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attr = new HashMap<CFIdentifier, CFExpression>();
        CFAdminStatement adminStatement = new CFAdminStatement(ctx.ADMIN().getSymbol(), _attr);
        this.aggregator.push(adminStatement);
        this.visitChildren((RuleNode)ctx.paramStatementAttributes());
        this.aggregator.pop();
        return adminStatement;
    }

    @Override
    public CFScriptStatement visitThrowStatement(CFSCRIPTParser.ThrowStatementContext ctx) {
        CFThrowStatement throwStatement = new CFThrowStatement(ctx.THROW().getSymbol(), this.visitExpression((ParseTree)ctx.memberExpression()));
        return throwStatement;
    }

    @Override
    public CFScriptStatement visitExitStatement(CFSCRIPTParser.ExitStatementContext ctx) {
        CFExitStatement exitStatement = new CFExitStatement(ctx.EXIT().getSymbol(), this.visitExpression((ParseTree)ctx.memberExpression()));
        return exitStatement;
    }

    @Override
    public CFScriptStatement visitParamStatement(CFSCRIPTParser.ParamStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attributes = new HashMap<CFIdentifier, CFExpression>();
        CFParamStatement paramStatement = new CFParamStatement(ctx.PARAM().getSymbol(), _attributes);
        this.aggregator.push(paramStatement);
        if (ctx.paramStatementAttributes() != null) {
            this.visitChildren((RuleNode)ctx.paramStatementAttributes());
        }
        this.aggregator.pop();
        return paramStatement;
    }

    @Override
    public CFScriptStatement visitPropertyStatement(CFSCRIPTParser.PropertyStatementContext ctx) {
        HashMap<CFIdentifier, CFExpression> _attributes = new HashMap<CFIdentifier, CFExpression>();
        CFPropertyStatement propertyStatement = new CFPropertyStatement(ctx.PROPERTY().getSymbol(), _attributes);
        this.aggregator.push(propertyStatement);
        if (ctx.paramStatementAttributes() != null) {
            this.visitChildren((RuleNode)ctx.paramStatementAttributes());
        } else {
            propertyStatement.setIsShortHand(true);
            propertyStatement.setPropertyName((CFIdentifier)this.visitExpression((ParseTree)ctx.multipartIdentifier()));
            propertyStatement.setPropertyType(this.visitExpression((ParseTree)ctx.typeSpec()));
        }
        this.aggregator.pop();
        return propertyStatement;
    }

    @Override
    public CFScriptStatement visitParamStatementAttributes(CFSCRIPTParser.ParamStatementAttributesContext ctx) {
        return (CFScriptStatement)super.visitParamStatementAttributes(ctx);
    }

    @Override
    public CFScriptStatement visitParam(CFSCRIPTParser.ParamContext ctx) {
        if (!this.aggregator.isEmpty() && this.aggregator.peek() instanceof CFParsedAttributeStatement) {
            ((CFParsedAttributeStatement)this.aggregator.peek()).getAttributes().put((CFIdentifier)this.visitExpression((ParseTree)ctx.multipartIdentifier()), this.visitExpression((ParseTree)ctx.startExpression()));
            return null;
        }
        return (CFScriptStatement)super.visitParam(ctx);
    }

    @Override
    public CFScriptStatement visitExpression(CFSCRIPTParser.ExpressionContext ctx) {
        return (CFScriptStatement)super.visitExpression(ctx);
    }

    @Override
    public CFScriptStatement visitLocalAssignmentExpression(CFSCRIPTParser.LocalAssignmentExpressionContext ctx) {
        return new CFExpressionStatement(this.visitExpression((ParseTree)ctx));
    }

    @Override
    public CFScriptStatement visitAssignmentExpression(CFSCRIPTParser.AssignmentExpressionContext ctx) {
        return new CFExpressionStatement(this.visitExpression((ParseTree)ctx));
    }

    @Override
    public CFScriptStatement visitStartExpression(CFSCRIPTParser.StartExpressionContext ctx) {
        return new CFExpressionStatement(this.visitExpression((ParseTree)ctx));
    }

    protected CFScriptStatement aggregateResult(CFScriptStatement aggregate, CFScriptStatement nextResult) {
        if (nextResult == null) {
            return aggregate;
        }
        if (aggregate == null) {
            return nextResult;
        }
        if (!this.aggregator.isEmpty() && this.aggregator.peek() instanceof CFCompoundStatement && aggregate != this.aggregator.peek()) {
            ((CFCompoundStatement)this.aggregator.peek()).add(aggregate);
            ((CFCompoundStatement)this.aggregator.peek()).add(nextResult);
            return (CFCompoundStatement)this.aggregator.peek();
        }
        if (aggregate instanceof CFCompoundStatement) {
            ((CFCompoundStatement)aggregate).add(nextResult);
            return aggregate;
        }
        CFCompoundStatement statement = new CFCompoundStatement();
        if (aggregate instanceof CFFuncDeclStatement) {
            statement.addFunction(aggregate);
        } else {
            statement.add(aggregate);
        }
        if (nextResult instanceof CFFuncDeclStatement) {
            statement.addFunction(nextResult);
        } else {
            statement.add(nextResult);
        }
        aggregate = statement;
        return statement;
    }

    String getText(ParseTree t) {
        if (t == null) {
            return null;
        }
        if (t.getChildCount() > 0) {
            return this.getText(t.getChild(0));
        }
        return t.getText();
    }

    CFScriptStatement visitNullSafe(ParseTree tree) {
        if (tree == null) {
            return null;
        }
        return (CFScriptStatement)this.visit(tree);
    }

    CFExpression visitExpression(ParseTree tree) {
        if (tree != null) {
            return (CFExpression)this.cfExpressionVisitor.visit(tree);
        }
        return null;
    }

    public void clear() {
        this.aggregator.clear();
        this.cfExpressionVisitor.clear();
    }
}

