/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript.script;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;

public class CFFunctionParameter {
    private String name;
    private boolean required;
    private String type;
    private CFExpression defaultExp;

    public CFFunctionParameter(CFIdentifier t, boolean _required, String _type, CFExpression _default) {
        this.name = t.getName();
        this.required = _required;
        this.type = _type;
        this.defaultExp = _default;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDefaulted() {
        return this.defaultExp != null;
    }

    public boolean isFormallyTyped() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.required) {
            sb.append("required ");
        }
        sb.append(this.name);
        if (this.defaultExp != null) {
            sb.append('=');
            sb.append(this.defaultExp.Decompile(0));
        }
        return sb.toString();
    }

    public CFExpression getDefaultExpression() {
        return this.defaultExp;
    }
}

