/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFLiteral;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFStringExpression
extends CFExpression {
    List<CFExpression> subExpressions = new ArrayList<CFExpression>();
    private static final long serialVersionUID = 233826913909000678L;

    public CFStringExpression(Token t) {
        super(t);
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        for (CFExpression expression : this.subExpressions) {
            if (expression instanceof CFLiteral) {
                String txt = expression.Decompile(0);
                if (txt == null || txt.length() <= 0) continue;
                sb.append(txt.substring(1, txt.length() - 1));
                continue;
            }
            sb.append("#");
            sb.append(expression.Decompile(0));
            sb.append("#");
        }
        sb.append("'");
        return sb.toString();
    }

    public List<CFExpression> getSubExpressions() {
        return this.subExpressions;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return this.subExpressions;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

