/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.io.Serializable;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFLiteral
extends CFExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String val;
    private int kind;
    private String image;

    public CFLiteral(Token _t, String img) {
        this(_t);
        this.val = img;
        this.image = img;
    }

    public CFLiteral(Token _t) {
        super(_t);
        this.kind = _t.getType();
        this.image = _t.getText();
        switch (this.kind) {
            case 169: 
            case 172: {
                this.val = _t.getText();
                break;
            }
            case 175: {
                String str;
                this.image = str = _t.getText();
                this.val = str;
                break;
            }
            case 8: {
                this.val = _t.getText();
                break;
            }
        }
    }

    @Override
    public byte getType() {
        return CFExpression.LITERAL;
    }

    public String getStringImage() {
        return this.image;
    }

    @Override
    public String Decompile(int indent) {
        try {
            if (175 == this.kind && this.val != null) {
                return "'" + this.val + "'";
            }
            return this.val == null ? "" : this.val;
        }
        catch (Exception e) {
            return "Couldn't get literal value";
        }
    }

    public String getVal() {
        return this.val;
    }

    public int getKind() {
        return this.kind;
    }

    public String getImage() {
        return this.image;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        return ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[0]);
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

