/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFAssignmentExpression;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFFullVarExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.CFMember;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.reporting.ParseException;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFFunctionExpression
extends CFMember {
    private static final long serialVersionUID = 1L;
    private CFIdentifier nameId;
    private ArrayList<CFExpression> args;
    private boolean isUDF = true;
    private CFScriptStatement body;

    public CFFunctionExpression(CFIdentifier _name, ArrayList<CFExpression> _args) throws ParseException {
        this(_name.getToken(), _name, _args);
    }

    public CFFunctionExpression(Token t, CFIdentifier _name, ArrayList<CFExpression> _args) throws ParseException {
        super(t, null);
        this.nameId = _name;
        this.args = _args;
        this.isUDF = false;
    }

    @Override
    public byte getType() {
        return CFExpression.FUNCTION;
    }

    public String getFunctionName() {
        if (this.nameId instanceof CFFullVarExpression) {
            return ((CFFullVarExpression)this.nameId).getLastIdentifier().Decompile(0).toLowerCase();
        }
        return this.nameId == null ? "" : this.nameId.Decompile(0).toLowerCase();
    }

    public boolean isUDF() {
        return this.isUDF;
    }

    @Override
    public String Decompile(int indent) {
        String s = this.nameId == null ? "" : this.nameId.Decompile(indent);
        s = s + "(";
        for (int i = 0; i < this.args.size(); ++i) {
            s = s + this.args.get(i).Decompile(indent);
            if (i >= this.args.size() - 1) continue;
            s = s + ", ";
        }
        s = s + ")";
        if (this.body != null) {
            s = s + this.body.Decompile(indent + 2);
        }
        return s;
    }

    public ArrayList<CFExpression> getArgs() {
        return this.args;
    }

    public String getName() {
        return this.nameId == null ? "" : this.nameId.Decompile(0);
    }

    public CFIdentifier getIdentifier() {
        return this.nameId;
    }

    public CFIdentifier getNameId() {
        return this.nameId;
    }

    public CFScriptStatement getBody() {
        return this.body;
    }

    public void setBody(CFScriptStatement body) {
        this.body = body;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        ArrayList<CFExpression> retval = new ArrayList<CFExpression>();
        for (CFExpression expr : this.getArgs()) {
            if (expr instanceof CFAssignmentExpression) {
                retval.add(((CFAssignmentExpression)expr).getRight());
                continue;
            }
            retval.add(expr);
        }
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[]{this.body});
    }
}

