/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing.cfscript;

import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.CFIdentifier;
import cfml.parsing.cfscript.CFVarExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.util.ArrayBuilder;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class CFAssignmentExpression
extends CFExpression {
    private static final long serialVersionUID = 1L;
    private CFExpression left;
    private CFExpression right;
    List<CFIdentifier> otherIds = new ArrayList<CFIdentifier>();

    public List<CFIdentifier> getOtherIds() {
        return this.otherIds;
    }

    public CFAssignmentExpression(Token t, CFExpression _left, CFExpression _right) {
        super(t);
        this.left = _left;
        this.right = _right;
    }

    @Override
    public byte getType() {
        return CFExpression.ASSIGNMENT;
    }

    public void checkIndirect(String expr) {
        String lhs;
        if (this.left instanceof CFVarExpression && ((lhs = expr.substring(0, expr.indexOf(61)).trim()).startsWith("\"#") && lhs.endsWith("#\"") || lhs.startsWith("'#") && lhs.endsWith("#'"))) {
            ((CFVarExpression)this.left).setIndirect(true);
        }
    }

    @Override
    public void checkIndirectAssignments(String[] scriptSource) {
        if (this.left instanceof CFVarExpression) {
            int i;
            String expr = scriptSource[this.left.getLine() - 1];
            int lhsEnd = expr.indexOf("=", this.left.getColumn());
            if (lhsEnd == -1) {
                lhsEnd = expr.length();
            }
            char[] exprChars = expr.substring(0, lhsEnd).toCharArray();
            for (i = exprChars.length - 1; i >= 0 && Character.isWhitespace(exprChars[i]); --i) {
            }
            if (i >= 0 && (exprChars[i] == '\"' || exprChars[i] == '\'') && --i >= 0 && exprChars[i] == '#') {
                ((CFVarExpression)this.left).setIndirect(true);
            }
        }
    }

    @Override
    public String Decompile(int indent) {
        StringBuilder sb = new StringBuilder();
        if (this.left != null) {
            sb.append(this.left.Decompile(indent));
        }
        sb.append(" = ");
        for (CFIdentifier id : this.otherIds) {
            sb.append(id.Decompile(indent));
            sb.append(" = ");
        }
        if (this.right != null) {
            sb.append(this.right.Decompile(indent));
        }
        return sb.toString();
    }

    public CFExpression getLeft() {
        return this.left;
    }

    public CFExpression getRight() {
        return this.right;
    }

    @Override
    public List<CFExpression> decomposeExpression() {
        List retval = ArrayBuilder.createCFExpression((CFExpression[])new CFExpression[]{this.left, this.right});
        retval.addAll(this.otherIds);
        return retval;
    }

    @Override
    public List<CFScriptStatement> decomposeScript() {
        return ArrayBuilder.createCFScriptStatement((CFScriptStatement[])new CFScriptStatement[0]);
    }
}

