/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing;

import cfml.parsing.ParserTag;
import cfml.parsing.cfmentat.tag.CFMLTags;
import cfml.parsing.preferences.ParserPreferences;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.SourceFormatter;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;

public class CFMLSource
implements Logger {
    private Source fSource;
    private List<String> messages = new ArrayList<String>();

    public CFMLSource(String contents) {
        CFMLTags.register();
        this.fSource = contents != null && contents.contains("<!---") ? new Source((CharSequence)contents) : new Source((CharSequence)contents);
        this.fSource.setLogger((Logger)this);
    }

    public CFMLSource(String contents, ParserPreferences prefs) {
        CFMLTags.register(prefs);
        this.fSource = new Source((CharSequence)contents);
        this.fSource.setLogger((Logger)this);
    }

    public CFMLSource(URL url) throws IOException {
        CFMLTags.register();
        this.fSource = new Source(url);
        this.fSource.setLogger((Logger)this);
    }

    public CFMLSource(URL url, ParserPreferences prefs) throws IOException {
        CFMLTags.register(prefs);
        this.fSource = new Source(url);
        this.fSource.setLogger((Logger)this);
    }

    public String getDebuggingInfo() {
        return this.fSource.getDebugInfo();
    }

    public List<Element> getAllElements(StartTagType startTagType) {
        return this.fSource.getAllElements(startTagType);
    }

    public List<Element> getChildElements() {
        return this.fSource.getChildElements();
    }

    public void ignoreWhenParsing(List allElements) {
        this.fSource.ignoreWhenParsing((Collection)allElements);
    }

    public String getCacheDebugInfo() {
        return this.fSource.getCacheDebugInfo();
    }

    public List<Element> getAllElements() {
        return this.fSource.getAllElements();
    }

    public SourceFormatter getSourceFormatter() {
        return this.fSource.getSourceFormatter();
    }

    public List<StartTag> getAllStartTags() {
        return this.fSource.getAllStartTags();
    }

    public OutputDocument getOutputDocument() {
        return new OutputDocument(this.fSource);
    }

    public int getRow(int begin) {
        return this.fSource.getRow(begin);
    }

    public List<StartTag> getAllCFMLTags() {
        return this.getTagsByName("cf");
    }

    public ParserTag getTagAt(int i) {
        ParserTag parserTag = this.makeParserTag(this.fSource.getTagAt(i));
        return parserTag;
    }

    public List<StartTag> getTagsByName(String tagName) {
        ArrayList<StartTag> tags = new ArrayList<StartTag>();
        for (StartTag tagStart : this.getAllStartTags()) {
            if (!tagStart.getName().startsWith(tagName)) continue;
            tags.add(tagStart);
        }
        return tags;
    }

    public ParserTag getEnclosingTag(int i) {
        Tag tag = this.fSource.getEnclosingTag(i);
        if (tag == null) {
            return null;
        }
        return this.makeParserTag(tag);
    }

    public ParserTag getNextTag(int i) {
        Tag tag = this.fSource.getNextTag(i);
        return this.makeParserTag(tag);
    }

    public ParserTag getPreviousTag(int i) {
        Tag encosingTag = this.fSource.getEnclosingTag(i);
        Tag parserTag = this.fSource.getPreviousTag(i);
        if (parserTag.getBegin() == encosingTag.getBegin()) {
            return this.makeParserTag(this.fSource.getPreviousTag(encosingTag.getBegin() - 1));
        }
        return this.makeParserTag(this.fSource.getPreviousTag(i));
    }

    private ParserTag makeParserTag(Tag nextTag) {
        if (nextTag == null) {
            return null;
        }
        ParserTag newTag = new ParserTag(nextTag);
        return newTag;
    }

    private ParserTag makeParserTag(StartTag tag) {
        ParserTag newTag = new ParserTag(tag);
        return newTag;
    }

    public void error(String message) {
        this.messages.add(message);
    }

    public void warn(String message) {
    }

    public void info(String message) {
    }

    public void debug(String message) {
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public List<String> getMessages() {
        return this.messages;
    }
}

