/*
 * Decompiled with CFR 0.152.
 */
package cfml.parsing;

import cfml.CFSCRIPTLexer;
import cfml.CFSCRIPTParser;
import cfml.dictionary.DictionaryManager;
import cfml.dictionary.SyntaxDictionary;
import cfml.dictionary.preferences.DictionaryPreferences;
import cfml.parsing.CFMLSource;
import cfml.parsing.ParseError;
import cfml.parsing.ParseMessage;
import cfml.parsing.cfml.CFMLVisitor;
import cfml.parsing.cfscript.CFExpression;
import cfml.parsing.cfscript.script.CFScriptStatement;
import cfml.parsing.cfscript.walker.CFExpressionVisitor;
import cfml.parsing.cfscript.walker.CFScriptStatementVisitor;
import cfml.parsing.reporting.IErrorReporter;
import cfml.parsing.reporting.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.StartTag;
import org.antlr.runtime.BitSet;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.LexerATNSimulator;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;

public class CFMLParser {
    private Map fCfmlSources = new HashMap();
    protected ArrayList<ParseMessage> messages = new ArrayList();
    private boolean hadFatal;
    private int errCount = 0;
    private SyntaxDictionary cfdic;
    private DictionaryPreferences fDictPrefs = new DictionaryPreferences();
    IErrorReporter errorReporter = new StdErrReporter();
    CFExpressionVisitor expressionVisitor = new CFExpressionVisitor();
    CFScriptStatementVisitor scriptVisitor = new CFScriptStatementVisitor();
    CFSCRIPTLexer lexer = null;
    CFSCRIPTParser parser = null;
    int skipToPosition = 0;

    public void clearDFA() {
        if (this.parser != null) {
            ((ParserATNSimulator)this.parser.getInterpreter()).clearDFA();
        }
        if (this.lexer != null) {
            ((LexerATNSimulator)this.lexer.getInterpreter()).clearDFA();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFExpression parseCFExpression(String _infix, ANTLRErrorListener errorReporter) throws Exception {
        if (errorReporter == null) {
            errorReporter = this.errorReporter;
        }
        ANTLRInputStream input = new ANTLRInputStream(_infix);
        if (this.lexer == null) {
            this.lexer = new CFSCRIPTLexer((CharStream)input);
        } else {
            this.lexer.setInputStream((IntStream)input);
        }
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lexer);
        if (this.parser == null) {
            this.parser = new CFSCRIPTParser((TokenStream)tokens);
            if (errorReporter == null) {
                this.lexer.addErrorListener(this.errorReporter);
                this.parser.addErrorListener(this.errorReporter);
            }
        } else {
            this.parser.setTokenStream((TokenStream)tokens);
        }
        if (errorReporter != null) {
            this.lexer.addErrorListener(errorReporter);
            this.parser.addErrorListener(errorReporter);
        }
        ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        this.parser.reset();
        CFSCRIPTParser.ExpressionContext expressionContext = null;
        try {
            expressionContext = this.parser.expression();
        }
        catch (Exception e) {
            tokens.reset();
            this.parser.reset();
            ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            expressionContext = this.parser.expression();
        }
        finally {
            if (errorReporter != null) {
                this.lexer.removeErrorListener(errorReporter);
                this.parser.removeErrorListener(errorReporter);
            }
        }
        if (expressionContext != null) {
            return (CFExpression)this.expressionVisitor.visit((ParseTree)expressionContext);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFExpression parseCFMLExpression(String _infix, ANTLRErrorListener errorReporter) throws Exception {
        if (errorReporter == null) {
            errorReporter = this.errorReporter;
        }
        ANTLRInputStream input = new ANTLRInputStream(_infix);
        if (this.lexer == null) {
            this.lexer = new CFSCRIPTLexer((CharStream)input);
        } else {
            this.lexer.setInputStream((IntStream)input);
        }
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lexer);
        if (this.parser == null) {
            this.parser = new CFSCRIPTParser((TokenStream)tokens);
            if (errorReporter == null) {
                this.lexer.addErrorListener(this.errorReporter);
                this.parser.addErrorListener(this.errorReporter);
            }
        } else {
            this.parser.setTokenStream((TokenStream)tokens);
        }
        if (errorReporter != null) {
            this.lexer.addErrorListener(errorReporter);
            this.parser.addErrorListener(errorReporter);
        }
        ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        this.parser.reset();
        CFSCRIPTParser.CfmlExpressionContext expressionContext = null;
        try {
            expressionContext = this.parser.cfmlExpression();
        }
        catch (Exception e) {
            tokens.reset();
            this.parser.reset();
            ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            expressionContext = this.parser.cfmlExpression();
        }
        finally {
            if (errorReporter != null) {
                this.lexer.removeErrorListener(errorReporter);
                this.parser.removeErrorListener(errorReporter);
            }
        }
        if (expressionContext != null) {
            return (CFExpression)this.expressionVisitor.visit((ParseTree)expressionContext);
        }
        return null;
    }

    public void visit(Element elem, int level, CFMLVisitor visitor) throws Exception {
        if (this.skipToPosition > elem.getBegin()) {
            return;
        }
        this.skipToPosition = 0;
        visitor.visitElementStart(elem);
        if (elem.getName().equalsIgnoreCase("cfset") || elem.getName().equalsIgnoreCase("cfreturn")) {
            String cfscript = elem.toString().substring(elem.getName().length() + 1, elem.toString().length() - 1).trim();
            if (cfscript.length() > 0 && visitor.visitPreParseExpression("TAG", cfscript)) {
                CFExpression expression = this.parseCFExpression(cfscript, visitor);
                if (expression == null) {
                    throw new NullPointerException("expression is null, parsing error");
                }
                visitor.visitExpression("TAG", expression);
            }
        } else if (elem.getName().equalsIgnoreCase("cfif") || elem.getName().equalsIgnoreCase("cfelseif")) {
            String cfscript;
            int nextPos;
            int uglyNotPos = elem.toString().lastIndexOf("<>");
            int endPos = elem.getStartTag().getEnd() - 1;
            if (uglyNotPos > 0 && (nextPos = elem.toString().indexOf(">", uglyNotPos + 2)) > 0 && nextPos < elem.getEndTag().getBegin()) {
                endPos = nextPos;
            }
            if ((cfscript = elem.toString().substring(elem.getName().length() + 1, endPos)).length() > 0 && visitor.visitPreParseExpression("TAG", cfscript)) {
                CFExpression expression = this.parseCFExpression(cfscript, visitor);
                if (expression == null) {
                    throw new NullPointerException("expression is null, parsing error");
                }
                visitor.visitExpression("TAG", expression);
            }
        } else if (!elem.getName().equalsIgnoreCase("cfargument")) {
            if (elem.getName().equalsIgnoreCase("cfscript")) {
                if (elem.getEndTag() != null) {
                    String cfscript = elem.getContent().toString();
                    visitor.visitScript(this.parseScript(cfscript));
                } else {
                    EndTag nextTag = elem.getSource().getNextEndTag(elem.getBegin());
                    while (nextTag != null && !nextTag.getName().equalsIgnoreCase(elem.getName())) {
                        nextTag = elem.getSource().getNextEndTag(nextTag.getEnd());
                    }
                    if (nextTag.getName().equalsIgnoreCase(elem.getName())) {
                        String cfscript = elem.getSource().subSequence(elem.getStartTag().getEnd(), nextTag.getBegin()).toString();
                        visitor.visitScript(this.parseScript(cfscript));
                        this.skipToPosition = nextTag.getEnd();
                    }
                }
            } else if (elem.getName().equalsIgnoreCase("cffunction") || elem.getName().equalsIgnoreCase("cfcomponent") || elem.getName().equalsIgnoreCase("cfquery") || elem.getName().equalsIgnoreCase("cfqueryparam")) {
                // empty if block
            }
        }
        for (Element child : elem.getChildElements()) {
            this.visit(child, level + 1, visitor);
        }
        visitor.visitElementEnd(elem);
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public CFMLParser() {
        DictionaryManager.initDictionaries();
        this.cfdic = DictionaryManager.getDictionaryByVersion((String)this.fDictPrefs.getCFDictionary());
        if (this.cfdic == null) {
            throw new IllegalArgumentException("The syntax dictionary could not be loaded!");
        }
    }

    public CFMLParser(String dictionariesPath, String dictionary) {
        this.fDictPrefs.setDictionaryDir(dictionariesPath);
        this.fDictPrefs.setCFDictionary(dictionary);
        DictionaryManager.initDictionaries((DictionaryPreferences)this.fDictPrefs);
        this.cfdic = DictionaryManager.getDictionaryByVersion((String)dictionary);
        if (this.cfdic == null) {
            throw new IllegalArgumentException("The syntax dictionary could not be loaded!");
        }
    }

    public void setDictionary(SyntaxDictionary newDict) {
        this.cfdic = newDict;
    }

    public void addDictionary(String dictionary) {
    }

    public CFMLSource addCFMLSource(String path, String cfmlsource) {
        CFMLSource source = new CFMLSource(cfmlsource);
        this.fCfmlSources.put(path, source);
        return source;
    }

    public CFMLSource addCFMLSource(File cfmlsource) throws IOException {
        return this.addCFMLSource(cfmlsource.getPath(), CFMLParser.readFileAsString(cfmlsource.getPath()));
    }

    public CFMLSource addCFMLSource(URL url) throws IOException {
        CFMLSource source = new CFMLSource(url);
        this.fCfmlSources.put(url.getPath(), source);
        return source;
    }

    public ArrayList<StartTag> getCFMLTags() {
        ArrayList<StartTag> cfmlTags = new ArrayList<StartTag>();
        Iterator sources = this.fCfmlSources.keySet().iterator();
        while (sources.hasNext()) {
            cfmlTags.addAll(((CFMLSource)this.fCfmlSources.get(sources.next())).getAllCFMLTags());
        }
        return cfmlTags;
    }

    public ArrayList getAllTags() {
        ArrayList<Element> allTags = new ArrayList<Element>();
        Iterator sources = this.fCfmlSources.keySet().iterator();
        while (sources.hasNext()) {
            allTags.addAll(((CFMLSource)this.fCfmlSources.get(sources.next())).getAllElements());
        }
        return allTags;
    }

    public String getCacheDebugInfo() {
        String info = "";
        Iterator sources = this.fCfmlSources.keySet().iterator();
        while (sources.hasNext()) {
            info = info.concat(((CFMLSource)this.fCfmlSources.get(sources.next())).getCacheDebugInfo());
        }
        return info;
    }

    public String getDebuggingInfo() {
        String info = "";
        Iterator sources = this.fCfmlSources.keySet().iterator();
        while (sources.hasNext()) {
            info = info.concat(((CFMLSource)this.fCfmlSources.get(sources.next())).getDebuggingInfo());
        }
        return info;
    }

    public boolean hadFatal() {
        return this.hadFatal;
    }

    public void addMessage(ParseMessage newMsg) {
        if (newMsg instanceof ParseError) {
            if (((ParseError)newMsg).isFatal()) {
                this.hadFatal = true;
            }
            ++this.errCount;
        }
        this.messages.add(newMsg);
    }

    public void addMessages(ArrayList newMessages) {
        Iterator msgIter = newMessages.iterator();
        ParseMessage currMsg = null;
        while (msgIter.hasNext()) {
            currMsg = (ParseMessage)msgIter.next();
            if (currMsg instanceof ParseError) {
                if (((ParseError)currMsg).isFatal()) {
                    this.hadFatal = true;
                }
                ++this.errCount;
            }
            this.messages.add(currMsg);
        }
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public String printMessages() {
        String messagesText = "";
        for (ParseMessage message : this.messages) {
            messagesText = messagesText + message.toString() + "\n";
        }
        return messagesText;
    }

    public void parseElements(CFMLSource cfmlSource) {
        for (Element element : cfmlSource.getAllElements()) {
            HashMap suggestedAttributes = new HashMap();
            String attributesFound = "";
            Set dictAttributes = this.cfdic.getElementAttributes(element.getName());
            if (dictAttributes == null) continue;
            Object[] params = dictAttributes.toArray();
            HashMap itemAttributes = new HashMap();
            element.getAttributes().populateMap(itemAttributes, true);
            if (itemAttributes.size() > 0) {
                attributesFound = " (Found: " + ((Object)itemAttributes).toString() + ")";
            }
            int lineNumber = cfmlSource.getRow(element.getBegin());
            int startPosition = element.getBegin();
            int endPosition = element.getEnd();
            String name = element.getName();
            String string = element.getTextExtractor().toString();
        }
    }

    public CFScriptStatement parseScriptFile(String file) throws ParseException, IOException {
        return this.parseScript(CFMLParser.readFileAsString(file));
    }

    public CFScriptStatement parseScript(String cfscript) throws ParseException, IOException {
        CommonTokenStream tokens = this.createTokenStream(cfscript);
        CFSCRIPTParser.ScriptBlockContext scriptBlockContext = this.parseScriptBlockContext(tokens);
        CFScriptStatement result = (CFScriptStatement)this.scriptVisitor.visit((ParseTree)scriptBlockContext);
        if (result != null) {
            result.setTokens(tokens);
        }
        return result;
    }

    public CommonTokenStream createTokenStream(String cfscript) throws ParseException, IOException {
        ANTLRInputStream input = new ANTLRInputStream(cfscript);
        CFSCRIPTLexer lexer = new CFSCRIPTLexer((CharStream)input);
        return new CommonTokenStream((TokenSource)lexer);
    }

    public CFSCRIPTParser.ScriptBlockContext parseScriptBlockContext(String cfscript) throws ParseException, IOException {
        CommonTokenStream tokens = this.createTokenStream(cfscript);
        return this.parseScriptBlockContext(tokens);
    }

    public CFSCRIPTParser.ScriptBlockContext parseScriptBlockContext(CommonTokenStream tokens) throws ParseException, IOException {
        CFSCRIPTParser.ScriptBlockContext scriptStatement = null;
        CFSCRIPTParser parser = new CFSCRIPTParser((TokenStream)tokens);
        parser.getErrorListeners().clear();
        if (tokens.getTokenSource() instanceof CFSCRIPTLexer) {
            ((CFSCRIPTLexer)tokens.getTokenSource()).addErrorListener(this.errorReporter);
        }
        parser.reset();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            scriptStatement = parser.scriptBlock();
        }
        catch (Exception e) {
            tokens.reset();
            parser.reset();
            parser.addErrorListener(this.errorReporter);
            parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            scriptStatement = parser.scriptBlock();
        }
        return scriptStatement;
    }

    public void parse() {
        Iterator sources = this.fCfmlSources.keySet().iterator();
        while (sources.hasNext()) {
            this.parseElements((CFMLSource)this.fCfmlSources.get(sources.next()));
        }
    }

    public CFMLSource getCFMLSource(String path) {
        CFMLSource cfmlSource = (CFMLSource)this.fCfmlSources.get(path);
        return cfmlSource;
    }

    public void setErrorReporter(IErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void reset() {
        this.expressionVisitor.clear();
        this.scriptVisitor.clear();
    }

    public class StdErrReporter
    implements IErrorReporter {
        @Override
        public void reportError(String error) {
            CFMLParser.this.addMessage(new ParseError(0, 0, 0, error, error));
        }

        @Override
        public void reportError(RecognitionException re) {
            if (re.getOffendingToken() != null) {
                // empty if block
            }
            CFMLParser.this.addMessage(new ParseError(re.getOffendingToken().getLine(), re.getOffendingToken().getCharPositionInLine(), re.getOffendingToken().getCharPositionInLine(), re.getMessage(), re.getMessage()));
        }

        @Override
        public void reportError(String[] tokenNames, RecognitionException re) {
            CFMLParser.this.addMessage(new ParseError(re.getOffendingToken().getLine(), re.getOffendingToken().getCharPositionInLine(), re.getOffendingToken().getCharPositionInLine(), tokenNames.toString(), re.getMessage()));
        }

        @Override
        public void reportError(IntStream input, RecognitionException re, BitSet follow) {
            CFMLParser.this.addMessage(new ParseError(re.getOffendingToken().getLine(), re.getOffendingToken().getCharPositionInLine(), re.getOffendingToken().getCharPositionInLine(), re.getMessage(), re.getMessage()));
        }

        public void reportAmbiguity(Parser arg0, DFA arg1, int arg2, int arg3, boolean arg4, java.util.BitSet arg5, ATNConfigSet arg6) {
        }

        public void reportAttemptingFullContext(Parser arg0, DFA arg1, int arg2, int arg3, java.util.BitSet arg4, ATNConfigSet arg5) {
        }

        public void reportContextSensitivity(Parser arg0, DFA arg1, int arg2, int arg3, int arg4, ATNConfigSet arg5) {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException re) {
            CFMLParser.this.addMessage(new ParseError(line, charPositionInLine, charPositionInLine, msg, re == null ? null : re.getMessage()));
        }
    }
}

