/*
 * Decompiled with CFR 0.152.
 */
package com.carlosmuvi.segmentedprogressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.carlosmuvi.segmentedprogressbar.DrawingTimer;
import com.carlosmuvi.segmentedprogressbar.PropertiesModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0015\u001a\u00020\t2\b\b\u0001\u0010\u0016\u001a\u00020\u000bH\u0002J\u0012\u0010\u0017\u001a\u00020\t2\b\b\u0001\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J8\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\tH\u0002J\u0006\u0010%\u001a\u00020\u0019J\b\u0010&\u001a\u00020\u0019H\u0002J\u0012\u0010'\u001a\u00020\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010(\u001a\u00020\u00192\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0006\u0010,\u001a\u00020\u0019J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020\u0019J\u0006\u00101\u001a\u00020\u0019J\u000e\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u000bJ\u0010\u00104\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u000bJ\u0010\u00105\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00068"}, d2={"Lcom/carlosmuvi/segmentedprogressbar/SegmentedProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "containerRectanglePaint", "Landroid/graphics/Paint;", "currentSegmentProgressInPx", "", "drawingTimer", "Lcom/carlosmuvi/segmentedprogressbar/DrawingTimer;", "fillRectanglePaint", "lastCompletedSegment", "properties", "Lcom/carlosmuvi/segmentedprogressbar/PropertiesModel;", "segmentWidth", "getSegmentWidth", "()I", "buildContainerRectanglePaint", "color", "buildFillRectanglePaint", "drawCompletedRectangles", "", "canvas", "Landroid/graphics/Canvas;", "drawContainerRectangles", "drawCurrentRectangle", "drawRoundedRect", "left", "", "top", "right", "bottom", "paint", "incrementCompletedSegments", "initDrawingTimer", "initPropertiesModel", "initView", "isPaused", "", "onDraw", "pause", "playSegment", "timeInMilliseconds", "", "reset", "resume", "setCompletedSegments", "completedSegments", "setContainerColor", "setFillColor", "setSegmentCount", "segmentCount", "library_release"})
public final class SegmentedProgressBar
extends View {
    private int lastCompletedSegment;
    private int currentSegmentProgressInPx;
    private Paint containerRectanglePaint;
    private Paint fillRectanglePaint;
    private DrawingTimer drawingTimer;
    private PropertiesModel properties;

    private final void initView(AttributeSet attrs) {
        this.initDrawingTimer();
        this.initPropertiesModel(attrs);
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        this.containerRectanglePaint = this.buildContainerRectanglePaint(propertiesModel.getContainerColor());
        PropertiesModel propertiesModel2 = this.properties;
        if (propertiesModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        this.fillRectanglePaint = this.buildFillRectanglePaint(propertiesModel2.getFillColor());
    }

    static /* synthetic */ void initView$default(SegmentedProgressBar segmentedProgressBar, AttributeSet attributeSet, int n, Object object) {
        if ((n & 1) != 0) {
            attributeSet = null;
        }
        segmentedProgressBar.initView(attributeSet);
    }

    private final void initPropertiesModel(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.properties = new PropertiesModel(context, attrs);
    }

    private final void initDrawingTimer() {
        DrawingTimer drawingTimer = this.drawingTimer = new DrawingTimer();
        if (drawingTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
        }
        drawingTimer.setListener(new DrawingTimer.Listener(this){
            final /* synthetic */ SegmentedProgressBar this$0;

            public final void onTick(int currentTicks, int totalTicks) {
                int segmentWidth = SegmentedProgressBar.access$getSegmentWidth$p(this.this$0);
                SegmentedProgressBar.access$setCurrentSegmentProgressInPx$p(this.this$0, currentTicks * segmentWidth / totalTicks);
                if (totalTicks <= currentTicks) {
                    SegmentedProgressBar segmentedProgressBar = this.this$0;
                    int n = SegmentedProgressBar.access$getLastCompletedSegment$p(segmentedProgressBar);
                    SegmentedProgressBar.access$setLastCompletedSegment$p(segmentedProgressBar, n + 1);
                    SegmentedProgressBar.access$setCurrentSegmentProgressInPx$p(this.this$0, 0);
                }
                this.this$0.invalidate();
            }
            {
                this.this$0 = segmentedProgressBar;
            }
        });
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawContainerRectangles(canvas);
        this.drawCompletedRectangles(canvas);
        this.drawCurrentRectangle(canvas);
    }

    public final void setContainerColor(@ColorInt int color) {
        this.containerRectanglePaint = this.buildContainerRectanglePaint(color);
    }

    public final void setFillColor(@ColorInt int color) {
        this.fillRectanglePaint = this.buildFillRectanglePaint(color);
    }

    public final void setSegmentCount(int segmentCount) {
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        propertiesModel.setSegmentCount(segmentCount);
    }

    public final void playSegment(long timeInMilliseconds) {
        DrawingTimer drawingTimer = this.drawingTimer;
        if (drawingTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
        }
        if (!drawingTimer.isRunning()) {
            DrawingTimer drawingTimer2 = this.drawingTimer;
            if (drawingTimer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
            }
            drawingTimer2.start(timeInMilliseconds);
        }
    }

    public final void pause() {
        DrawingTimer drawingTimer = this.drawingTimer;
        if (drawingTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
        }
        drawingTimer.pause();
    }

    public final void resume() {
        DrawingTimer drawingTimer = this.drawingTimer;
        if (drawingTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
        }
        drawingTimer.resume();
    }

    public final void reset() {
        this.setCompletedSegments(0);
    }

    public final boolean isPaused() {
        DrawingTimer drawingTimer = this.drawingTimer;
        if (drawingTimer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
        }
        return drawingTimer.isPaused();
    }

    public final void setCompletedSegments(int completedSegments) {
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        if (completedSegments <= propertiesModel.getSegmentCount()) {
            this.currentSegmentProgressInPx = 0;
            DrawingTimer drawingTimer = this.drawingTimer;
            if (drawingTimer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
            }
            drawingTimer.reset();
            this.lastCompletedSegment = completedSegments;
            this.invalidate();
        }
    }

    public final void incrementCompletedSegments() {
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        if (this.lastCompletedSegment <= propertiesModel.getSegmentCount()) {
            this.currentSegmentProgressInPx = 0;
            DrawingTimer drawingTimer = this.drawingTimer;
            if (drawingTimer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"drawingTimer");
            }
            drawingTimer.reset();
            int n = this.lastCompletedSegment;
            this.lastCompletedSegment = n + 1;
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawContainerRectangles(Canvas canvas) {
        int n;
        int segmentWidth = this.getSegmentWidth();
        int leftX = 0;
        int rightX = leftX + segmentWidth;
        boolean topY = false;
        int botY = this.getHeight();
        int n2 = 0;
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        if (n2 <= (n = propertiesModel.getSegmentCount() - 1)) {
            while (true) {
                void i;
                float f = leftX;
                float f2 = (float)topY;
                float f3 = rightX;
                float f4 = botY;
                Paint paint = this.containerRectanglePaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"containerRectanglePaint");
                }
                this.drawRoundedRect(canvas, f, f2, f3, f4, paint);
                PropertiesModel propertiesModel2 = this.properties;
                if (propertiesModel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
                }
                leftX = leftX + segmentWidth + propertiesModel2.getSegmentGapWidth();
                rightX = leftX + segmentWidth;
                if (i == n) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCompletedRectangles(Canvas canvas) {
        int segmentWidth = this.getSegmentWidth();
        int leftX = 0;
        int rightX = leftX + segmentWidth;
        boolean topY = false;
        int botY = this.getHeight();
        int n = 0;
        int n2 = this.lastCompletedSegment - 1;
        if (n <= n2) {
            while (true) {
                void i;
                float f = leftX;
                float f2 = (float)topY;
                float f3 = rightX;
                float f4 = botY;
                Paint paint = this.fillRectanglePaint;
                if (paint == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fillRectanglePaint");
                }
                this.drawRoundedRect(canvas, f, f2, f3, f4, paint);
                PropertiesModel propertiesModel = this.properties;
                if (propertiesModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
                }
                leftX = leftX + segmentWidth + propertiesModel.getSegmentGapWidth();
                rightX = leftX + segmentWidth;
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void drawCurrentRectangle(Canvas canvas) {
        int segmentWidth = this.getSegmentWidth();
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        int leftX = this.lastCompletedSegment * (segmentWidth + propertiesModel.getSegmentGapWidth());
        int rightX = leftX + this.currentSegmentProgressInPx;
        boolean topY = false;
        int botY = this.getHeight();
        float f = leftX;
        float f2 = (float)topY;
        float f3 = rightX;
        float f4 = botY;
        Paint paint = this.fillRectanglePaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fillRectanglePaint");
        }
        this.drawRoundedRect(canvas, f, f2, f3, f4, paint);
    }

    private final void drawRoundedRect(Canvas canvas, float left, float top, float right, float bottom, Paint paint) {
        float ry;
        Path path = new Path();
        float rx = 6.0f;
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if ((ry = 6.0f) < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / (float)2) {
            rx = width / (float)2;
        }
        if (ry > height / (float)2) {
            ry = height / (float)2;
        }
        float widthMinusCorners = width - (float)2 * rx;
        float heightMinusCorners = height - (float)2 * ry;
        Path $receiver = path;
        $receiver.moveTo(right, top + ry);
        $receiver.rQuadTo(0.0f, -ry, -rx, -ry);
        $receiver.rLineTo(-widthMinusCorners, 0.0f);
        $receiver.rQuadTo(-rx, 0.0f, -rx, ry);
        $receiver.rLineTo(0.0f, heightMinusCorners);
        $receiver.rQuadTo(0.0f, ry, rx, ry);
        $receiver.rLineTo(widthMinusCorners, 0.0f);
        $receiver.rQuadTo(rx, 0.0f, rx, -ry);
        $receiver.rLineTo(0.0f, -heightMinusCorners);
        $receiver.close();
        canvas.drawPath(path, paint);
    }

    private final Paint buildFillRectanglePaint(@ColorInt int color) {
        Paint paint = new Paint();
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        return paint;
    }

    private final Paint buildContainerRectanglePaint(@ColorInt int color) {
        Paint paint = new Paint();
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        return paint;
    }

    private final int getSegmentWidth() {
        int n = this.getWidth();
        PropertiesModel propertiesModel = this.properties;
        if (propertiesModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        int n2 = n / propertiesModel.getSegmentCount();
        PropertiesModel propertiesModel2 = this.properties;
        if (propertiesModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"properties");
        }
        return n2 - propertiesModel2.getSegmentGapWidth();
    }

    public SegmentedProgressBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        SegmentedProgressBar.initView$default(this, null, 1, null);
    }

    public SegmentedProgressBar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.initView(attrs);
    }

    public static final /* synthetic */ int access$getSegmentWidth$p(SegmentedProgressBar $this) {
        return $this.getSegmentWidth();
    }

    public static final /* synthetic */ int access$getCurrentSegmentProgressInPx$p(SegmentedProgressBar $this) {
        return $this.currentSegmentProgressInPx;
    }

    public static final /* synthetic */ void access$setCurrentSegmentProgressInPx$p(SegmentedProgressBar $this, int n) {
        $this.currentSegmentProgressInPx = n;
    }

    public static final /* synthetic */ int access$getLastCompletedSegment$p(SegmentedProgressBar $this) {
        return $this.lastCompletedSegment;
    }

    public static final /* synthetic */ void access$setLastCompletedSegment$p(SegmentedProgressBar $this, int n) {
        $this.lastCompletedSegment = n;
    }
}

