/*
 * Decompiled with CFR 0.152.
 */
package com.carlosmuvi.segmentedprogressbar;

import android.os.Handler;

public class DrawingTimer {
    private final Handler handler;
    private final long tickTimeInMilliseconds = 30L;
    private int totalTicks;
    private int currentTick = 0;
    private Listener listener;
    private TimerState timerState = TimerState.IDLE;

    public DrawingTimer() {
        this.handler = new Handler();
    }

    public void start(long timeInMilliseconds) {
        if (this.timerState == TimerState.IDLE) {
            this.totalTicks = (int)(timeInMilliseconds / 30L);
        }
        if (this.timerState != TimerState.RUNNING) {
            this.timerState = TimerState.RUNNING;
            this.runDrawingTask();
        }
    }

    private void runDrawingTask() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                DrawingTimer.this.listener.onTick(DrawingTimer.this.currentTick, DrawingTimer.this.totalTicks);
                DrawingTimer.this.currentTick++;
                if (DrawingTimer.this.currentTick <= DrawingTimer.this.totalTicks) {
                    DrawingTimer.this.handler.postDelayed((Runnable)this, 30L);
                } else {
                    DrawingTimer.this.reset();
                }
            }
        });
    }

    public void pause() {
        if (this.timerState == TimerState.RUNNING) {
            this.timerState = TimerState.PAUSED;
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    public void resume() {
        if (this.timerState == TimerState.PAUSED) {
            this.timerState = TimerState.RUNNING;
            this.runDrawingTask();
        }
    }

    public void reset() {
        this.pause();
        this.timerState = TimerState.IDLE;
        this.currentTick = 0;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean isRunning() {
        return this.timerState == TimerState.RUNNING;
    }

    public boolean isPaused() {
        return this.timerState == TimerState.PAUSED;
    }

    static interface Listener {
        public void onTick(int var1, int var2);
    }

    static enum TimerState {
        RUNNING,
        PAUSED,
        IDLE;

    }
}

