/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.view.View;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;
import java.lang.ref.WeakReference;

public final class MeasureHelper {
    private WeakReference<View> mWeakView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private int mVideoRotationDegree;
    private int mMeasuredWidth;
    private int mMeasuredHeight;
    private int mCurrentAspectRatio = 0;
    private final MeasureFormVideoParamsListener mParamsListener;

    public MeasureHelper(View view, MeasureFormVideoParamsListener listener) {
        this.mParamsListener = listener;
        this.mWeakView = new WeakReference<View>(view);
    }

    public View getView() {
        if (this.mWeakView == null) {
            return null;
        }
        return (View)this.mWeakView.get();
    }

    public void setVideoSize(int videoWidth, int videoHeight) {
        this.mVideoWidth = videoWidth;
        this.mVideoHeight = videoHeight;
    }

    public void setVideoSampleAspectRatio(int videoSarNum, int videoSarDen) {
        this.mVideoSarNum = videoSarNum;
        this.mVideoSarDen = videoSarDen;
    }

    public void setVideoRotation(int videoRotationDegree) {
        this.mVideoRotationDegree = videoRotationDegree;
    }

    public void doMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mCurrentAspectRatio = GSYVideoType.getShowType();
        if (this.mVideoHeight == 0 || this.mVideoWidth == 0) {
            this.mMeasuredWidth = 1;
            this.mMeasuredHeight = 1;
            return;
        }
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            int tempSpec = widthMeasureSpec;
            widthMeasureSpec = heightMeasureSpec;
            heightMeasureSpec = tempSpec;
        }
        int realWidth = this.mVideoWidth;
        if (this.mVideoSarNum != 0 && this.mVideoSarDen != 0) {
            double pixelWidthHeightRatio = (double)this.mVideoSarNum / ((double)this.mVideoSarDen / 1.0);
            realWidth = (int)(pixelWidthHeightRatio * (double)this.mVideoWidth);
        }
        int width = View.getDefaultSize((int)realWidth, (int)widthMeasureSpec);
        int height = View.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        if (this.mCurrentAspectRatio == -4) {
            width = widthMeasureSpec;
            height = heightMeasureSpec;
        } else if (realWidth > 0 && this.mVideoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == Integer.MIN_VALUE && heightSpecMode == Integer.MIN_VALUE) {
                float displayAspectRatio;
                float specAspectRatio = (float)widthSpecSize / (float)heightSpecSize;
                switch (this.mCurrentAspectRatio) {
                    case 1: {
                        displayAspectRatio = 1.7777778f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        displayAspectRatio = 1.0f / displayAspectRatio;
                        break;
                    }
                    case 6: {
                        displayAspectRatio = 2.0f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        displayAspectRatio = 1.0f / displayAspectRatio;
                        break;
                    }
                    case 2: {
                        displayAspectRatio = 1.3333334f;
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        displayAspectRatio = 1.0f / displayAspectRatio;
                        break;
                    }
                    case -5: {
                        displayAspectRatio = GSYVideoType.getScreenScaleRatio();
                        if (this.mVideoRotationDegree != 90 && this.mVideoRotationDegree != 270) break;
                        displayAspectRatio = 1.0f / displayAspectRatio;
                        break;
                    }
                    default: {
                        displayAspectRatio = (float)realWidth / (float)this.mVideoHeight;
                        if (this.mVideoSarNum <= 0 || this.mVideoSarDen <= 0) break;
                        displayAspectRatio = displayAspectRatio * (float)this.mVideoSarNum / (float)this.mVideoSarDen;
                    }
                }
                boolean shouldBeWider = displayAspectRatio > specAspectRatio;
                switch (this.mCurrentAspectRatio) {
                    case -5: 
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: {
                        if (shouldBeWider) {
                            width = widthSpecSize;
                            height = (int)((float)width / displayAspectRatio);
                            break;
                        }
                        height = heightSpecSize;
                        width = (int)((float)height * displayAspectRatio);
                        break;
                    }
                    case 4: {
                        if (shouldBeWider) {
                            height = heightSpecSize;
                            width = (int)((float)height * displayAspectRatio);
                            break;
                        }
                        width = widthSpecSize;
                        height = (int)((float)width / displayAspectRatio);
                        break;
                    }
                    default: {
                        if (shouldBeWider) {
                            width = Math.min(realWidth, widthSpecSize);
                            height = (int)((float)width / displayAspectRatio);
                            break;
                        }
                        height = Math.min(this.mVideoHeight, heightSpecSize);
                        width = (int)((float)height * displayAspectRatio);
                        break;
                    }
                }
            } else if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (realWidth * height < width * this.mVideoHeight) {
                    width = height * realWidth / this.mVideoHeight;
                } else if (realWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / realWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / realWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * realWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = realWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * realWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / realWidth;
                }
            }
        }
        this.mMeasuredWidth = width;
        this.mMeasuredHeight = height;
    }

    public void prepareMeasure(int widthMeasureSpec, int heightMeasureSpec, int rotate) {
        if (this.mParamsListener != null) {
            try {
                int videoWidth = this.mParamsListener.getCurrentVideoWidth();
                int videoHeight = this.mParamsListener.getCurrentVideoHeight();
                Debuger.printfLog("videoWidth: " + videoWidth + " videoHeight: " + videoHeight);
                int videoSarNum = this.mParamsListener.getVideoSarNum();
                int videoSarDen = this.mParamsListener.getVideoSarDen();
                if (videoWidth > 0 && videoHeight > 0) {
                    this.setVideoSampleAspectRatio(videoSarNum, videoSarDen);
                    this.setVideoSize(videoWidth, videoHeight);
                }
                this.setVideoRotation(rotate);
                this.doMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight;
    }

    public void setAspectRatio(int aspectRatio) {
        this.mCurrentAspectRatio = aspectRatio;
    }

    public static interface MeasureFormVideoParamsListener {
        public int getCurrentVideoWidth();

        public int getCurrentVideoHeight();

        public int getVideoSarNum();

        public int getVideoSarDen();
    }
}

