/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer.managed;

import com.github.caciocavallosilano.cacio.peer.CacioComponent;
import com.github.caciocavallosilano.cacio.peer.CacioEventPump;
import com.github.caciocavallosilano.cacio.peer.CacioEventSource;
import com.github.caciocavallosilano.cacio.peer.PlatformToplevelWindow;
import com.github.caciocavallosilano.cacio.peer.PlatformWindow;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import com.github.caciocavallosilano.cacio.peer.managed.EventData;
import com.github.caciocavallosilano.cacio.peer.managed.FullScreenEventPump;
import com.github.caciocavallosilano.cacio.peer.managed.ManagedWindow;
import com.github.caciocavallosilano.cacio.peer.managed.PlatformScreen;
import com.github.caciocavallosilano.cacio.peer.managed.PlatformScreenSelector;
import com.github.caciocavallosilano.cacio.peer.managed.ScreenManagedWindowContainer;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.security.action.GetPropertyAction;

public class FullScreenWindowFactory
implements PlatformWindowFactory {
    private static final Dimension screenSize;
    private final PlatformScreenSelector selector;
    private final Map<PlatformScreen, ScreenManagedWindowContainer> screenMap;
    private CacioEventSource eventSource;

    public FullScreenWindowFactory(PlatformScreen screen, CacioEventSource s) {
        this(new DefaultScreenSelector(screen), s);
    }

    public FullScreenWindowFactory(PlatformScreenSelector screenSelector, CacioEventSource s) {
        this.selector = screenSelector;
        this.eventSource = s;
        this.screenMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public final PlatformWindow createPlatformWindow(CacioComponent awtComponent, PlatformWindow parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        ManagedWindow p = (ManagedWindow)parent;
        return new ManagedWindow(p, awtComponent);
    }

    @Override
    public final PlatformToplevelWindow createPlatformToplevelWindow(CacioComponent comp) {
        PlatformScreen screen = this.selector.getPlatformScreen(comp);
        ScreenManagedWindowContainer smwc = this.screenMap.get(screen);
        if (smwc == null) {
            smwc = new ScreenManagedWindowContainer(screen);
            this.screenMap.put(screen, smwc);
        }
        return new ManagedWindow(smwc, comp);
    }

    @Override
    public PlatformWindow createPlatformToplevelWindow(CacioComponent component, PlatformWindow notUsed) {
        return this.createPlatformToplevelWindow(component);
    }

    @Override
    public CacioEventPump<?> createEventPump() {
        FullScreenEventSource s = new FullScreenEventSource();
        return new FullScreenEventPump(s);
    }

    public static Dimension getScreenDimension() {
        return screenSize;
    }

    public ScreenManagedWindowContainer getScreenManagedWindowContainer(PlatformScreen screen) {
        return this.screenMap.get(screen);
    }

    static {
        String size = AccessController.doPrivileged(new GetPropertyAction("cacio.managed.screensize", "1024x768"));
        int x = size.indexOf(120);
        int width = Integer.parseInt(size.substring(0, x));
        int height = Integer.parseInt(size.substring(x + 1));
        screenSize = new Dimension(width, height);
    }

    private static final class DefaultScreenSelector
    implements PlatformScreenSelector {
        PlatformScreen screen = null;

        DefaultScreenSelector(PlatformScreen screen) {
            this.screen = screen;
        }

        @Override
        public PlatformScreen getPlatformScreen(GraphicsConfiguration config) {
            return this.screen;
        }

        @Override
        public PlatformScreen getPlatformScreen(CacioComponent comp) {
            return this.getPlatformScreen(comp.getAWTComponent().getGraphicsConfiguration());
        }
    }

    private class FullScreenEventSource
    implements CacioEventSource {
        private FullScreenEventSource() {
        }

        @Override
        public EventData getNextEvent() throws InterruptedException {
            EventData d = FullScreenWindowFactory.this.eventSource.getNextEvent();
            PlatformScreen source = (PlatformScreen)d.getSource();
            d.setSource(FullScreenWindowFactory.this.screenMap.get(source));
            return d;
        }
    }
}

