/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.CacioContainerPeer;
import com.github.caciocavallosilano.cacio.peer.CacioDialogPeer;
import com.github.caciocavallosilano.cacio.peer.CacioKeyboardFocusManagerPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformToplevelWindow;
import com.github.caciocavallosilano.cacio.peer.PlatformWindow;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import com.github.caciocavallosilano.cacio.peer.ProxyWindow;
import com.github.caciocavallosilano.cacio.peer.ProxyWindowPeer;
import com.github.caciocavallosilano.cacio.peer.WindowClippedGraphics;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import sun.awt.AWTAccessor;

class CacioWindowPeer
extends CacioContainerPeer<Window, JRootPane>
implements WindowPeer {
    private static boolean decorateWindows = false;
    private static boolean decorateDialogs = false;
    private static final Font defaultFont = new Font("Dialog", 0, 12);
    protected boolean blocked;

    static void setDecorateWindows(boolean decorate) {
        decorateWindows = decorate;
        decorateDialogs = decorate;
    }

    static boolean isDecorateWindows() {
        return decorateWindows;
    }

    static void setDecorateDialogs(boolean decorate) {
        decorateDialogs = decorate;
    }

    static boolean isDecorateDialogs() {
        return decorateDialogs;
    }

    CacioWindowPeer(Window awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    void init(PlatformWindowFactory pwf) {
        Window w = (Window)this.getAWTComponent();
        Container parentComp = w.getParent();
        if (parentComp != null) {
            CacioComponentPeer parentPeer = null;
            ComponentPeer parentComponentPeer = CacioWindowPeer.getPeer(parentComp);
            if (parentComponentPeer instanceof CacioComponentPeer) {
                parentPeer = (CacioComponentPeer)parentComponentPeer;
            } else if (parentComponentPeer instanceof ProxyWindowPeer) {
                parentPeer = ((ProxyWindowPeer)parentComponentPeer).getTarget();
            } else {
                throw new InternalError("Invalid component type: " + parentComponentPeer.getClass());
            }
            PlatformWindow owner = parentPeer.platformWindow;
            this.platformWindow = pwf.createPlatformToplevelWindow(this, owner);
        } else {
            this.platformWindow = pwf.createPlatformToplevelWindow(this);
        }
        if (!w.isForegroundSet()) {
            w.setForeground(UIManager.getColor("windowText"));
        }
        if (!w.isBackgroundSet()) {
            Color c = UIManager.getColor("window");
            if (c != null) {
                c = UIManager.getColor("Panel.background");
            }
            w.setBackground(c);
        }
        if (!w.isFontSet()) {
            w.setFont(defaultFont);
        }
    }

    @Override
    JRootPane initSwingComponent() {
        Window window = (Window)this.getAWTComponent();
        JRootPane jrootpane = new JRootPane();
        jrootpane.setDoubleBuffered(false);
        return jrootpane;
    }

    @Override
    void postInitSwingComponent() {
        super.postInitSwingComponent();
        JRootPane jrootpane = (JRootPane)this.getSwingComponent();
        if (jrootpane != null) {
            int deco = this.getRootPaneDecorationStyle();
            jrootpane.setWindowDecorationStyle(deco);
        }
    }

    protected int getRootPaneDecorationStyle() {
        return 0;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
    }

    @Override
    public void setModalBlocked(Dialog blocker, boolean blocked) {
        CacioDialogPeer dialogPeer;
        if (this.blocked == blocked) {
            return;
        }
        if (blocker != null && (dialogPeer = (CacioDialogPeer)AWTAccessor.getComponentAccessor().getPeer(blocker)) != null) {
            dialogPeer.setModalBlocked(null, !blocked);
        }
        this.getToplevelWindow().setBlocked(blocked);
        this.blocked = blocked;
    }

    @Override
    public void toBack() {
    }

    @Override
    public void toFront() {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    @Override
    public void updateIconImages() {
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void handlePeerEvent(AWTEvent ev) {
        Window w = (Window)this.getAWTComponent();
        switch (ev.getID()) {
            case 1004: {
                CacioKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow(w);
                Window opposite = this.getOppositeWindow((FocusEvent)ev);
                WindowEvent we = new WindowEvent(w, 207, opposite);
                super.handlePeerEvent(we);
                break;
            }
            case 1005: {
                CacioKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow(null);
                Window opposite = this.getOppositeWindow((FocusEvent)ev);
                WindowEvent we = new WindowEvent(w, 208, opposite);
                super.handlePeerEvent(we);
                break;
            }
            default: {
                super.handlePeerEvent(ev);
            }
        }
    }

    private Window getOppositeWindow(FocusEvent ev) {
        Component c = ev.getOppositeComponent();
        if (c instanceof Window) {
            return (Window)c;
        }
        return null;
    }

    protected PlatformToplevelWindow getToplevelWindow() {
        return (PlatformToplevelWindow)this.platformWindow;
    }

    @Override
    boolean hasInsets() {
        return true;
    }

    protected boolean shouldDecorate() {
        return CacioWindowPeer.isDecorateWindows() || this instanceof CacioDialogPeer && CacioWindowPeer.isDecorateDialogs();
    }

    @Override
    public Insets getInsets() {
        Insets insets;
        if (this.shouldDecorate()) {
            int right;
            int bottom;
            JRootPane rp = (JRootPane)this.getSwingComponent();
            if (rp == null) {
                return new Insets(0, 0, 0, 0);
            }
            ProxyWindow proxy = this.getProxyWindow();
            if (!proxy.isVisible()) {
                proxy.setVisible(true);
            }
            Container cp = rp.getContentPane();
            Rectangle cpBounds = cp.getBounds();
            JLayeredPane lp = rp.getLayeredPane();
            Point lpLoc = lp.getLocation();
            int top = cpBounds.y + lpLoc.y;
            int left = cpBounds.x + lpLoc.x;
            Border b = rp.getBorder();
            if (b != null) {
                Insets bi = b.getBorderInsets(rp);
                bottom = bi.bottom;
                right = bi.right;
            } else {
                bottom = 0;
                right = 0;
            }
            insets = new Insets(top, left, bottom, right);
        } else {
            insets = (Insets)this.platformWindow.getInsets().clone();
            JMenuBar jmb = ((JRootPane)this.getSwingComponent()).getJMenuBar();
            if (jmb != null) {
                insets.top += jmb.getPreferredSize().height;
            }
        }
        return insets;
    }

    @Override
    public void setOpacity(float opacity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    @Override
    public void repositionSecurityWarning() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateWindow() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void peerPaint(Graphics g, boolean update) {
        Object c;
        if ((this.shouldDecorate() || ((JRootPane)this.getSwingComponent()).getJMenuBar() != null) && (c = this.getSwingComponent()) != null) {
            Insets insets = this.getInsets();
            Area clip = new Area(((Component)c).getBounds());
            Rectangle clip2 = new Rectangle(insets.left, insets.top, ((JComponent)c).getWidth() - insets.left - insets.right, ((JComponent)c).getHeight() - insets.bottom - insets.top);
            clip.subtract(new Area(clip2));
            WindowClippedGraphics peerG = new WindowClippedGraphics((Graphics2D)g, clip);
            try {
                ((JComponent)c).paint(peerG);
            }
            finally {
                ((Graphics)peerG).dispose();
            }
        }
    }

    @Override
    public void updateAlwaysOnTopState() {
    }

    @Override
    public boolean isFocusable() {
        boolean ret = super.isFocusable();
        if (ret) {
            ret = ((Window)this.getAWTComponent()).isFocusable() && ((Window)this.getAWTComponent()).getFocusableWindowState();
        }
        return ret;
    }
}

