/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioButtonPeer;
import com.github.caciocavallosilano.cacio.peer.CacioCanvasPeer;
import com.github.caciocavallosilano.cacio.peer.CacioCheckboxMenuItemPeer;
import com.github.caciocavallosilano.cacio.peer.CacioCheckboxPeer;
import com.github.caciocavallosilano.cacio.peer.CacioChoicePeer;
import com.github.caciocavallosilano.cacio.peer.CacioDialogPeer;
import com.github.caciocavallosilano.cacio.peer.CacioEventPump;
import com.github.caciocavallosilano.cacio.peer.CacioFileDialogPeer;
import com.github.caciocavallosilano.cacio.peer.CacioFramePeer;
import com.github.caciocavallosilano.cacio.peer.CacioKeyboardFocusManagerPeer;
import com.github.caciocavallosilano.cacio.peer.CacioLabelPeer;
import com.github.caciocavallosilano.cacio.peer.CacioListPeer;
import com.github.caciocavallosilano.cacio.peer.CacioMenuBarPeer;
import com.github.caciocavallosilano.cacio.peer.CacioMenuItemPeer;
import com.github.caciocavallosilano.cacio.peer.CacioMenuPeer;
import com.github.caciocavallosilano.cacio.peer.CacioMouseInfoPeer;
import com.github.caciocavallosilano.cacio.peer.CacioPanelPeer;
import com.github.caciocavallosilano.cacio.peer.CacioPopupMenuPeer;
import com.github.caciocavallosilano.cacio.peer.CacioScrollBarPeer;
import com.github.caciocavallosilano.cacio.peer.CacioScrollPanePeer;
import com.github.caciocavallosilano.cacio.peer.CacioTextAreaPeer;
import com.github.caciocavallosilano.cacio.peer.CacioTextFieldPeer;
import com.github.caciocavallosilano.cacio.peer.CacioWindowPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import com.github.caciocavallosilano.cacio.peer.ProxyWindow;
import com.github.caciocavallosilano.cacio.peer.ProxyWindowPeer;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import sun.awt.SunToolkit;
import sun.awt.image.OffScreenImage;

public abstract class CacioToolkit
extends SunToolkit {
    private static final int DEFAULT_SCREEN_RESOLUTION = 96;
    private static final int screenResolution;
    private Clipboard clipboard;

    private static boolean isLinux() {
        return "Linux".equals(System.getProperty("os.name"));
    }

    public CacioToolkit() {
        CacioEventPump<?> pump = this.getPlatformWindowFactory().createEventPump();
        pump.start();
        this.clipboard = new Clipboard("Cacio system clipboard");
    }

    @Override
    public ButtonPeer createButton(Button target) throws HeadlessException {
        CacioButtonPeer peer = new CacioButtonPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        CacioCanvasPeer peer = new CacioCanvasPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox target) throws HeadlessException {
        CacioCheckboxPeer peer = new CacioCheckboxPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) throws HeadlessException {
        CacioCheckboxMenuItemPeer peer = new CacioCheckboxMenuItemPeer(target);
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ChoicePeer createChoice(Choice target) throws HeadlessException {
        CacioChoicePeer peer = new CacioChoicePeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public DialogPeer createDialog(Dialog target) throws HeadlessException {
        CacioDialogPeer peer = new CacioDialogPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog target) throws HeadlessException {
        CacioFileDialogPeer peer = new CacioFileDialogPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public FramePeer createFrame(Frame target) throws HeadlessException {
        CacioFramePeer peer = new CacioFramePeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public LabelPeer createLabel(Label target) throws HeadlessException {
        CacioLabelPeer peer = new CacioLabelPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ListPeer createList(List target) throws HeadlessException {
        CacioListPeer peer = new CacioListPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuPeer createMenu(Menu target) throws HeadlessException {
        CacioMenuPeer peer = new CacioMenuPeer(target);
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) throws HeadlessException {
        CacioMenuBarPeer peer = new CacioMenuBarPeer(target);
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) throws HeadlessException {
        CacioMenuItemPeer peer = new CacioMenuItemPeer(target);
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        CacioPanelPeer peer = new CacioPanelPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) throws HeadlessException {
        CacioPopupMenuPeer peer = new CacioPopupMenuPeer(target);
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane target) {
        CacioScrollPanePeer peer = new CacioScrollPanePeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar target) throws HeadlessException {
        CacioScrollBarPeer peer = new CacioScrollBarPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea target) throws HeadlessException {
        CacioTextAreaPeer peer = new CacioTextAreaPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public TextFieldPeer createTextField(TextField target) throws HeadlessException {
        CacioTextFieldPeer peer = new CacioTextFieldPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public WindowPeer createWindow(Window target) throws HeadlessException {
        WindowPeer windowPeer = target instanceof ProxyWindow ? new ProxyWindowPeer((ProxyWindow)target) : new CacioWindowPeer(target, this.getPlatformWindowFactory());
        SunToolkit.targetCreatedPeer(target, windowPeer);
        return windowPeer;
    }

    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager manager) throws HeadlessException {
        return this.getKeyboardFocusManagerPeer();
    }

    @Override
    public KeyboardFocusManagerPeer getKeyboardFocusManagerPeer() throws HeadlessException {
        return CacioKeyboardFocusManagerPeer.getInstance();
    }

    static void disposePeer(Object target, Object peer) {
        SunToolkit.targetDisposedPeer(target, peer);
    }

    protected static boolean useManagedWindows() {
        return Boolean.getBoolean("cacio.usemanaged");
    }

    protected void setDecorateWindows(boolean decorate) {
        CacioWindowPeer.setDecorateWindows(decorate);
    }

    protected void setDecorateDialogs(boolean decorate) {
        CacioWindowPeer.setDecorateDialogs(decorate);
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String propName) {
        if (propName.equals("awt.font.desktophints") && this.desktopProperties.get("awt.font.desktophints") == null) {
            this.desktopProperties.put("awt.font.desktophints", SunToolkit.getDesktopFontHints());
        }
        return this.desktopProperties.get(propName);
    }

    public abstract PlatformWindowFactory getPlatformWindowFactory();

    public Image createOffScreenImage(Component component, int width, int height) {
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        ColorModel model = gc.getColorModel(1);
        WritableRaster wr = model.createCompatibleWritableRaster(width, height);
        return new OffScreenImage(component, model, wr, model.isAlphaPremultiplied());
    }

    @Override
    public boolean areExtraMouseButtonsEnabled() {
        return false;
    }

    @Override
    public int getScreenResolution() throws HeadlessException {
        return screenResolution;
    }

    @Override
    public Clipboard getSystemClipboard() throws HeadlessException {
        return this.clipboard;
    }

    @Override
    public MouseInfoPeer getMouseInfoPeer() {
        return CacioMouseInfoPeer.getInstance();
    }

    static {
        if (CacioToolkit.isLinux()) {
            System.setProperty("sun.font.fontmanager", "sun.awt.FcFontManager");
        }
        String resolution = System.getProperty("cacio.screenResolution");
        int res = 96;
        if (resolution != null) {
            try {
                res = Integer.parseInt(resolution);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        screenResolution = res;
    }
}

