/*
 * Decompiled with CFR 0.152.
 */
package com.github.caciocavallosilano.cacio.peer;

import com.github.caciocavallosilano.cacio.peer.CacioComponentPeer;
import com.github.caciocavallosilano.cacio.peer.PlatformWindowFactory;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

class CacioCheckboxPeer
extends CacioComponentPeer<Checkbox, JPanel>
implements CheckboxPeer {
    private JToggleButton toggleButton;

    public CacioCheckboxPeer(Checkbox awtC, PlatformWindowFactory pwf) {
        super(awtC, pwf);
    }

    @Override
    public JPanel initSwingComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.toggleButton = ((Checkbox)this.getAWTComponent()).getCheckboxGroup() == null ? new JCheckBox() : new JRadioButton();
        panel.add(this.toggleButton);
        return panel;
    }

    @Override
    void postInitSwingComponent() {
        super.postInitSwingComponent();
        this.toggleButton.addItemListener(new SwingCheckboxListener());
        Checkbox checkbox = (Checkbox)this.getAWTComponent();
        this.setLabel(checkbox.getLabel());
        this.setState(checkbox.getState());
    }

    @Override
    public void setCheckboxGroup(CheckboxGroup group) {
        this.toggleButton = group == null ? new JCheckBox() : new JRadioButton();
        ((JPanel)this.getSwingComponent()).removeAll();
        ((JPanel)this.getSwingComponent()).add(this.toggleButton);
        this.postInitSwingComponent();
    }

    @Override
    public void setLabel(String label) {
        this.toggleButton.setText(label);
    }

    @Override
    public void setState(boolean state) {
        this.toggleButton.setSelected(state);
    }

    @Override
    void setEnabledImpl(boolean e) {
        super.setEnabledImpl(e);
        this.toggleButton.setEnabled(e);
    }

    class SwingCheckboxListener
    implements ItemListener {
        SwingCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Checkbox awtCheckbox = (Checkbox)CacioCheckboxPeer.this.getAWTComponent();
            if (event.getStateChange() == 2 && awtCheckbox.getCheckboxGroup() != null) {
                return;
            }
            awtCheckbox.setState(event.getStateChange() == 1);
            ItemListener[] l = awtCheckbox.getItemListeners();
            if (l.length == 0) {
                return;
            }
            ItemEvent ev = new ItemEvent(awtCheckbox, 701, awtCheckbox.getLabel(), event.getStateChange());
            for (int i = 0; i < l.length; ++i) {
                l[i].itemStateChanged(ev);
            }
        }
    }
}

