/*
 * Decompiled with CFR 0.152.
 */
package net.cachapa.expandablelayout;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import net.cachapa.expandablelayout.R;
import net.cachapa.expandablelayout.util.FastOutSlowInInterpolator;

public class ExpandableLayout
extends FrameLayout {
    public static final String KEY_SUPER_STATE = "super_state";
    public static final String KEY_EXPANSION = "expansion";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int DEFAULT_DURATION = 300;
    private int duration = 300;
    private float parallax;
    private float expansion;
    private int orientation;
    private int state;
    private Interpolator interpolator = new FastOutSlowInInterpolator();
    private ValueAnimator animator;
    private OnExpansionUpdateListener listener;

    public ExpandableLayout(Context context) {
        this(context, null);
    }

    public ExpandableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableLayout);
            this.duration = a.getInt(R.styleable.ExpandableLayout_el_duration, 300);
            this.expansion = a.getBoolean(R.styleable.ExpandableLayout_el_expanded, false) ? 1.0f : 0.0f;
            this.orientation = a.getInt(R.styleable.ExpandableLayout_android_orientation, 1);
            this.parallax = a.getFloat(R.styleable.ExpandableLayout_el_parallax, 1.0f);
            a.recycle();
            this.state = this.expansion == 0.0f ? 0 : 3;
            this.setParallax(this.parallax);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        this.expansion = this.isExpanded() ? 1.0f : 0.0f;
        bundle.putFloat(KEY_EXPANSION, this.expansion);
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        Bundle bundle = (Bundle)parcelable;
        this.expansion = bundle.getFloat(KEY_EXPANSION);
        this.state = this.expansion == 1.0f ? 3 : 0;
        Parcelable superState = bundle.getParcelable(KEY_SUPER_STATE);
        super.onRestoreInstanceState(superState);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int size = this.orientation == 0 ? width : height;
        this.setVisibility(this.expansion == 0.0f && size == 0 ? 8 : 0);
        int expansionDelta = size - Math.round((float)size * this.expansion);
        if (this.parallax > 0.0f) {
            float parallaxDelta = (float)expansionDelta * this.parallax;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (this.orientation == 0) {
                    int direction = -1;
                    if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
                        direction = 1;
                    }
                    child.setTranslationX((float)direction * parallaxDelta);
                    continue;
                }
                child.setTranslationY(-parallaxDelta);
            }
        }
        if (this.orientation == 0) {
            this.setMeasuredDimension(width - expansionDelta, height);
        } else {
            this.setMeasuredDimension(width, height - expansionDelta);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (this.animator != null) {
            this.animator.cancel();
        }
        super.onConfigurationChanged(newConfig);
    }

    public int getState() {
        return this.state;
    }

    public boolean isExpanded() {
        return this.state == 2 || this.state == 3;
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean animate) {
        if (this.isExpanded()) {
            this.collapse(animate);
        } else {
            this.expand(animate);
        }
    }

    public void expand() {
        this.expand(true);
    }

    public void expand(boolean animate) {
        this.setExpanded(true, animate);
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapse(boolean animate) {
        this.setExpanded(false, animate);
    }

    public void setExpanded(boolean expand) {
        this.setExpanded(expand, true);
    }

    public void setExpanded(boolean expand, boolean animate) {
        int targetExpansion;
        if (expand == this.isExpanded()) {
            return;
        }
        int n = targetExpansion = expand ? 1 : 0;
        if (animate) {
            this.animateSize(targetExpansion);
        } else {
            this.setExpansion(targetExpansion);
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public float getExpansion() {
        return this.expansion;
    }

    public void setExpansion(float expansion) {
        if (this.expansion == expansion) {
            return;
        }
        float delta = expansion - this.expansion;
        if (expansion == 0.0f) {
            this.state = 0;
        } else if (expansion == 1.0f) {
            this.state = 3;
        } else if (delta < 0.0f) {
            this.state = 1;
        } else if (delta > 0.0f) {
            this.state = 2;
        }
        this.setVisibility(this.state == 0 ? 8 : 0);
        this.expansion = expansion;
        this.requestLayout();
        if (this.listener != null) {
            this.listener.onExpansionUpdate(expansion, this.state);
        }
    }

    public float getParallax() {
        return this.parallax;
    }

    public void setParallax(float parallax) {
        this.parallax = parallax = Math.min(1.0f, Math.max(0.0f, parallax));
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation < 0 || orientation > 1) {
            throw new IllegalArgumentException("Orientation must be either 0 (horizontal) or 1 (vertical)");
        }
        this.orientation = orientation;
    }

    public void setOnExpansionUpdateListener(OnExpansionUpdateListener listener) {
        this.listener = listener;
    }

    private void animateSize(int targetExpansion) {
        if (this.animator != null) {
            this.animator.cancel();
            this.animator = null;
        }
        this.animator = ValueAnimator.ofFloat((float[])new float[]{this.expansion, targetExpansion});
        this.animator.setInterpolator((TimeInterpolator)this.interpolator);
        this.animator.setDuration((long)this.duration);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ExpandableLayout.this.setExpansion(((Float)valueAnimator.getAnimatedValue()).floatValue());
            }
        });
        this.animator.addListener((Animator.AnimatorListener)new ExpansionListener(targetExpansion));
        this.animator.start();
    }

    private class ExpansionListener
    implements Animator.AnimatorListener {
        private int targetExpansion;
        private boolean canceled;

        public ExpansionListener(int targetExpansion) {
            this.targetExpansion = targetExpansion;
        }

        public void onAnimationStart(Animator animation) {
            ExpandableLayout.this.state = this.targetExpansion == 0 ? 1 : 2;
        }

        public void onAnimationEnd(Animator animation) {
            if (!this.canceled) {
                ExpandableLayout.this.state = this.targetExpansion == 0 ? 0 : 3;
                ExpandableLayout.this.setExpansion(this.targetExpansion);
            }
        }

        public void onAnimationCancel(Animator animation) {
            this.canceled = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface OnExpansionUpdateListener {
        public void onExpansionUpdate(float var1, int var2);
    }

    public static interface State {
        public static final int COLLAPSED = 0;
        public static final int COLLAPSING = 1;
        public static final int EXPANDING = 2;
        public static final int EXPANDED = 3;
    }
}

