/*
 * Decompiled with CFR 0.152.
 */
package net.cachapa.expandablelayout.util;

import android.view.animation.Interpolator;

abstract class LookupTableInterpolator
implements Interpolator {
    private final float[] mValues;
    private final float mStepSize;

    public LookupTableInterpolator(float[] values) {
        this.mValues = values;
        this.mStepSize = 1.0f / (float)(this.mValues.length - 1);
    }

    public float getInterpolation(float input) {
        if (input >= 1.0f) {
            return 1.0f;
        }
        if (input <= 0.0f) {
            return 0.0f;
        }
        int position = Math.min((int)(input * (float)(this.mValues.length - 1)), this.mValues.length - 2);
        float quantized = (float)position * this.mStepSize;
        float diff = input - quantized;
        float weight = diff / this.mStepSize;
        return this.mValues[position] + weight * (this.mValues[position + 1] - this.mValues[position]);
    }
}

