/*
 * Decompiled with CFR 0.152.
 */
package net.cachapa.expandablelayout;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import net.cachapa.expandablelayout.R;

public class ExpandableLinearLayout
extends LinearLayout {
    public static final String KEY_SUPER_STATE = "super_state";
    public static final String KEY_EXPANDED = "expanded";
    private static final int DEFAULT_DURATION = 300;
    private int wms;
    private int hms;
    private List<View> expandableViews;
    private int duration = 300;
    private boolean expanded = false;
    private Interpolator interpolator = new FastOutSlowInInterpolator();
    private AnimatorSet animatorSet;
    private OnExpansionUpdateListener listener;

    public ExpandableLinearLayout(Context context) {
        super(context);
        this.init(null);
    }

    public ExpandableLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ExpandableLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public ExpandableLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableLayout);
            this.duration = a.getInt(R.styleable.ExpandableLayout_el_duration, 300);
            this.expanded = a.getBoolean(R.styleable.ExpandableLayout_el_expanded, false);
            a.recycle();
        }
        this.expandableViews = new ArrayList<View>();
        this.setOrientation(1);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putBoolean(KEY_EXPANDED, this.expanded);
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle = (Bundle)state;
        this.expanded = bundle.getBoolean(KEY_EXPANDED);
        Parcelable superState = bundle.getParcelable(KEY_SUPER_STATE);
        for (View expandableView : this.expandableViews) {
            expandableView.setVisibility(this.expanded ? 0 : 8);
        }
        super.onRestoreInstanceState(superState);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        LayoutParams lp = (LayoutParams)params;
        if (lp.expandable) {
            this.expandableViews.add(child);
            child.setVisibility(this.expanded ? 0 : 8);
        }
        super.addView(child, index, params);
    }

    public void removeView(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.expandable) {
            this.expandableViews.remove(child);
        }
        super.removeView(child);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.wms = widthMeasureSpec;
        this.hms = heightMeasureSpec;
    }

    public LinearLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        super.onConfigurationChanged(newConfig);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean animate) {
        if (this.expanded) {
            this.collapse(animate);
        } else {
            this.expand(animate);
        }
    }

    public void expand() {
        this.expand(true);
    }

    @SuppressLint(value={"WrongCall"})
    public void expand(boolean animate) {
        if (this.expanded) {
            return;
        }
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
            this.animatorSet = null;
        }
        this.expanded = true;
        for (View expandableView : this.expandableViews) {
            LayoutParams lp = (LayoutParams)expandableView.getLayoutParams();
            expandableView.setVisibility(0);
            lp.weight = lp.originalWeight;
            lp.height = lp.originalHeight;
            super.onMeasure(this.wms, this.hms);
        }
        for (View expandableView : this.expandableViews) {
            if (animate) {
                this.animateHeight(expandableView, expandableView.getMeasuredHeight());
                continue;
            }
            this.setHeight(expandableView, expandableView.getMeasuredHeight());
        }
        if (this.animatorSet != null && animate) {
            this.animatorSet.start();
        }
    }

    public void collapse() {
        this.collapse(true);
    }

    public void collapse(boolean animate) {
        if (!this.expanded) {
            return;
        }
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
            this.animatorSet = null;
        }
        this.expanded = false;
        for (View expandableView : this.expandableViews) {
            if (animate) {
                this.animateHeight(expandableView, 0);
                continue;
            }
            this.setHeight(expandableView, 0);
        }
        if (this.animatorSet != null && animate) {
            this.animatorSet.start();
        }
    }

    public void setOnExpansionUpdateListener(OnExpansionUpdateListener listener) {
        this.listener = listener;
    }

    private void animateHeight(final View view, final int targetHeight) {
        if (this.animatorSet == null) {
            this.animatorSet = new AnimatorSet();
            this.animatorSet.setInterpolator((TimeInterpolator)this.interpolator);
            this.animatorSet.setDuration((long)this.duration);
        }
        final LayoutParams lp = (LayoutParams)view.getLayoutParams();
        lp.weight = 0.0f;
        int height = view.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{height, targetHeight});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                view.getLayoutParams().height = (Integer)valueAnimator.getAnimatedValue();
                view.requestLayout();
                if (ExpandableLinearLayout.this.listener != null) {
                    float fraction = targetHeight == 0 ? 1.0f - valueAnimator.getAnimatedFraction() : valueAnimator.getAnimatedFraction();
                    ExpandableLinearLayout.this.listener.onExpansionUpdate(fraction);
                }
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                view.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
                if (targetHeight == 0) {
                    view.setVisibility(8);
                } else {
                    lp.height = lp.originalHeight;
                    lp.weight = lp.originalWeight;
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.animatorSet.playTogether(new Animator[]{animator});
    }

    private void setHeight(View view, int targetHeight) {
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (targetHeight == 0) {
            view.setVisibility(8);
        } else {
            lp.height = lp.originalHeight;
            lp.weight = lp.originalWeight;
            view.requestLayout();
        }
        if (this.listener != null) {
            this.listener.onExpansionUpdate(targetHeight == 0 ? 0.0f : 1.0f);
        }
    }

    public static interface OnExpansionUpdateListener {
        public void onExpansionUpdate(float var1);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        private final boolean expandable;
        private final int originalHeight;
        private final float originalWeight;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ExpandableLayout);
            this.expandable = a.getBoolean(R.styleable.ExpandableLayout_layout_expandable, false);
            this.originalHeight = this.height;
            this.originalWeight = this.weight;
            a.recycle();
        }
    }
}

