/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import com.github.moduth.blockcanary.AbstractSampler;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.internal.BlockInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;

class StackSampler
extends AbstractSampler {
    private static final int DEFAULT_MAX_ENTRY_COUNT = BlockCanaryInternals.getContext().reportRecentOneMessage() ? 1 : 100;
    private static final LinkedHashMap<Long, String> sStackMap = new LinkedHashMap();
    private int mMaxEntryCount = DEFAULT_MAX_ENTRY_COUNT;
    private Thread mCurrentThread;

    public StackSampler(Thread thread, long sampleIntervalMillis) {
        this(thread, DEFAULT_MAX_ENTRY_COUNT, sampleIntervalMillis);
    }

    public StackSampler(Thread thread, int maxEntryCount, long sampleIntervalMillis) {
        super(sampleIntervalMillis);
        this.mCurrentThread = thread;
        this.mMaxEntryCount = maxEntryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getThreadStackEntries(long startTime, long endTime) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedHashMap<Long, String> linkedHashMap = sStackMap;
        synchronized (linkedHashMap) {
            for (Long entryTime : sStackMap.keySet()) {
                if (startTime >= entryTime || entryTime >= endTime) continue;
                result.add(BlockInfo.TIME_FORMATTER.format(entryTime) + "\r\n" + "\r\n" + sStackMap.get(entryTime));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSample() {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : this.mCurrentThread.getStackTrace()) {
            stringBuilder.append(stackTraceElement.toString()).append("\r\n");
        }
        LinkedHashMap<Long, String> linkedHashMap = sStackMap;
        synchronized (linkedHashMap) {
            if (sStackMap.size() == this.mMaxEntryCount && this.mMaxEntryCount > 0) {
                sStackMap.remove(sStackMap.keySet().iterator().next());
            }
            sStackMap.put(System.currentTimeMillis(), stringBuilder.toString());
        }
    }
}

