/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.compose;

import android.graphics.drawable.Drawable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import androidx.compose.ui.platform.ValueElementSequence;
import com.bumptech.glide.ModelExtractorKt;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.integration.compose.CrossFade;
import com.bumptech.glide.integration.compose.DoNotTransition;
import com.bumptech.glide.integration.compose.ExperimentalGlideComposeApi;
import com.bumptech.glide.integration.compose.GlideNode;
import com.bumptech.glide.integration.compose.RequestListener;
import com.bumptech.glide.integration.compose.SizesKt;
import com.bumptech.glide.integration.compose.Transition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0081\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BU\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c2\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00c2\u0003\u00a2\u0006\u0002\u0010\u001bJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u00c2\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u00c2\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u00c2\u0003\u00a2\u0006\u0002\u0010\u001fJ\u000b\u0010 \u001a\u0004\u0018\u00010\u0013H\u00c2\u0003Jn\u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0002H\u0016J\u0013\u0010$\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0002H\u0016J\f\u0010.\u001a\u00020,*\u00020/H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/bumptech/glide/integration/compose/GlideNodeElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Lcom/bumptech/glide/integration/compose/GlideNode;", "requestBuilder", "Lcom/bumptech/glide/RequestBuilder;", "Landroid/graphics/drawable/Drawable;", "contentScale", "Landroidx/compose/ui/layout/ContentScale;", "alignment", "Landroidx/compose/ui/Alignment;", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "requestListener", "Lcom/bumptech/glide/integration/compose/RequestListener;", "draw", "", "transitionFactory", "Lcom/bumptech/glide/integration/compose/Transition$Factory;", "(Lcom/bumptech/glide/RequestBuilder;Landroidx/compose/ui/layout/ContentScale;Landroidx/compose/ui/Alignment;Ljava/lang/Float;Landroidx/compose/ui/graphics/ColorFilter;Lcom/bumptech/glide/integration/compose/RequestListener;Ljava/lang/Boolean;Lcom/bumptech/glide/integration/compose/Transition$Factory;)V", "Ljava/lang/Float;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "component4", "()Ljava/lang/Float;", "component5", "component6", "component7", "()Ljava/lang/Boolean;", "component8", "copy", "(Lcom/bumptech/glide/RequestBuilder;Landroidx/compose/ui/layout/ContentScale;Landroidx/compose/ui/Alignment;Ljava/lang/Float;Landroidx/compose/ui/graphics/ColorFilter;Lcom/bumptech/glide/integration/compose/RequestListener;Ljava/lang/Boolean;Lcom/bumptech/glide/integration/compose/Transition$Factory;)Lcom/bumptech/glide/integration/compose/GlideNodeElement;", "create", "equals", "other", "", "hashCode", "", "toString", "", "update", "", "node", "inspectableProperties", "Landroidx/compose/ui/platform/InspectorInfo;", "compose_release"})
@ExperimentalGlideComposeApi
public final class GlideNodeElement
extends ModifierNodeElement<GlideNode> {
    @NotNull
    private final RequestBuilder<Drawable> requestBuilder;
    @NotNull
    private final ContentScale contentScale;
    @NotNull
    private final Alignment alignment;
    @Nullable
    private final Float alpha;
    @Nullable
    private final ColorFilter colorFilter;
    @Nullable
    private final RequestListener requestListener;
    @Nullable
    private final Boolean draw;
    @Nullable
    private final Transition.Factory transitionFactory;

    public GlideNodeElement(@NotNull RequestBuilder<Drawable> requestBuilder2, @NotNull ContentScale contentScale, @NotNull Alignment alignment, @Nullable Float alpha, @Nullable ColorFilter colorFilter, @Nullable RequestListener requestListener, @Nullable Boolean draw2, @Nullable Transition.Factory transitionFactory) {
        Intrinsics.checkNotNullParameter(requestBuilder2, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        this.requestBuilder = requestBuilder2;
        this.contentScale = contentScale;
        this.alignment = alignment;
        this.alpha = alpha;
        this.colorFilter = colorFilter;
        this.requestListener = requestListener;
        this.draw = draw2;
        this.transitionFactory = transitionFactory;
    }

    @NotNull
    public GlideNode create() {
        GlideNode result = new GlideNode();
        this.update(result);
        return result;
    }

    public void update(@NotNull GlideNode node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        node.onNewRequest(this.requestBuilder, this.contentScale, this.alignment, this.alpha, this.colorFilter, this.requestListener, this.draw, this.transitionFactory);
    }

    public void inspectableProperties(@NotNull InspectorInfo $this$inspectableProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$inspectableProperties, (String)"<this>");
        $this$inspectableProperties.setName("GlideNode");
        $this$inspectableProperties.getProperties().set("model", ModelExtractorKt.getInternalModel(this.requestBuilder));
        ValueElementSequence valueElementSequence = $this$inspectableProperties.getProperties();
        Object object = SizesKt.overrideSize(this.requestBuilder);
        if (object == null) {
            object = "LayoutBased";
        }
        valueElementSequence.set("size", object);
        $this$inspectableProperties.getProperties().set("alignment", (Object)this.alignment);
        $this$inspectableProperties.getProperties().set("contentScale", (Object)this.contentScale);
        $this$inspectableProperties.getProperties().set("colorFilter", (Object)this.colorFilter);
        $this$inspectableProperties.getProperties().set("draw", (Object)this.draw);
        Transition.Factory factory = this.transitionFactory;
        $this$inspectableProperties.getProperties().set("transition", (Object)(factory instanceof DoNotTransition.Factory ? "None" : (factory instanceof CrossFade ? "CrossFade" : "Custom: " + this.transitionFactory)));
    }

    private final RequestBuilder<Drawable> component1() {
        return this.requestBuilder;
    }

    private final ContentScale component2() {
        return this.contentScale;
    }

    private final Alignment component3() {
        return this.alignment;
    }

    private final Float component4() {
        return this.alpha;
    }

    private final ColorFilter component5() {
        return this.colorFilter;
    }

    private final RequestListener component6() {
        return this.requestListener;
    }

    private final Boolean component7() {
        return this.draw;
    }

    private final Transition.Factory component8() {
        return this.transitionFactory;
    }

    @NotNull
    public final GlideNodeElement copy(@NotNull RequestBuilder<Drawable> requestBuilder2, @NotNull ContentScale contentScale, @NotNull Alignment alignment, @Nullable Float alpha, @Nullable ColorFilter colorFilter, @Nullable RequestListener requestListener, @Nullable Boolean draw2, @Nullable Transition.Factory transitionFactory) {
        Intrinsics.checkNotNullParameter(requestBuilder2, (String)"requestBuilder");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        return new GlideNodeElement(requestBuilder2, contentScale, alignment, alpha, colorFilter, requestListener, draw2, transitionFactory);
    }

    public static /* synthetic */ GlideNodeElement copy$default(GlideNodeElement glideNodeElement, RequestBuilder requestBuilder2, ContentScale contentScale, Alignment alignment, Float f, ColorFilter colorFilter, RequestListener requestListener, Boolean bl, Transition.Factory factory, int n, Object object) {
        if ((n & 1) != 0) {
            requestBuilder2 = glideNodeElement.requestBuilder;
        }
        if ((n & 2) != 0) {
            contentScale = glideNodeElement.contentScale;
        }
        if ((n & 4) != 0) {
            alignment = glideNodeElement.alignment;
        }
        if ((n & 8) != 0) {
            f = glideNodeElement.alpha;
        }
        if ((n & 0x10) != 0) {
            colorFilter = glideNodeElement.colorFilter;
        }
        if ((n & 0x20) != 0) {
            requestListener = glideNodeElement.requestListener;
        }
        if ((n & 0x40) != 0) {
            bl = glideNodeElement.draw;
        }
        if ((n & 0x80) != 0) {
            factory = glideNodeElement.transitionFactory;
        }
        return glideNodeElement.copy(requestBuilder2, contentScale, alignment, f, colorFilter, requestListener, bl, factory);
    }

    @NotNull
    public String toString() {
        return "GlideNodeElement(requestBuilder=" + this.requestBuilder + ", contentScale=" + this.contentScale + ", alignment=" + this.alignment + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ", requestListener=" + this.requestListener + ", draw=" + this.draw + ", transitionFactory=" + this.transitionFactory + ')';
    }

    public int hashCode() {
        int result = this.requestBuilder.hashCode();
        result = result * 31 + this.contentScale.hashCode();
        result = result * 31 + this.alignment.hashCode();
        result = result * 31 + (this.alpha == null ? 0 : ((Object)this.alpha).hashCode());
        result = result * 31 + (this.colorFilter == null ? 0 : this.colorFilter.hashCode());
        result = result * 31 + (this.requestListener == null ? 0 : this.requestListener.hashCode());
        result = result * 31 + (this.draw == null ? 0 : ((Object)this.draw).hashCode());
        result = result * 31 + (this.transitionFactory == null ? 0 : this.transitionFactory.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlideNodeElement)) {
            return false;
        }
        GlideNodeElement glideNodeElement = (GlideNodeElement)((Object)other);
        if (!Intrinsics.areEqual(this.requestBuilder, glideNodeElement.requestBuilder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentScale, (Object)glideNodeElement.contentScale)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alignment, (Object)glideNodeElement.alignment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alpha, (Object)glideNodeElement.alpha)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.colorFilter, (Object)glideNodeElement.colorFilter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestListener, (Object)glideNodeElement.requestListener)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.draw, (Object)glideNodeElement.draw)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.transitionFactory, (Object)glideNodeElement.transitionFactory);
    }
}

