/*
 * Decompiled with CFR 0.152.
 */
package com.github.buchandersenn.android_permission_manager;

import android.support.annotation.NonNull;
import com.github.buchandersenn.android_permission_manager.PermissionManager;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionDeniedCallback;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionGrantedCallback;
import com.github.buchandersenn.android_permission_manager.callbacks.OnPermissionShowRationaleCallback;

public class PermissionRequest {
    @NonNull
    private final PermissionManager permissionManager;
    @NonNull
    private final String[] permissions;
    private final int requestCode;
    private final OnPermissionGrantedCallback grantedCallback;
    private final OnPermissionDeniedCallback deniedCallback;
    private final OnPermissionShowRationaleCallback showRationaleCallback;

    public PermissionRequest(@NonNull PermissionManager permissionManager, @NonNull String[] permissions, int requestCode, OnPermissionGrantedCallback grantedCallback, OnPermissionDeniedCallback deniedCallback, OnPermissionShowRationaleCallback showRationaleCallback) {
        this.permissionManager = permissionManager;
        this.permissions = permissions;
        this.requestCode = requestCode;
        this.grantedCallback = grantedCallback;
        this.deniedCallback = deniedCallback;
        this.showRationaleCallback = showRationaleCallback;
    }

    public void acceptPermissionRationale() {
        this.permissionManager.requestPermission(this);
    }

    @NonNull
    protected String[] getPermissions() {
        return this.permissions;
    }

    protected int getRequestCode() {
        return this.requestCode;
    }

    protected void fireOnPermissionGrantedCallback() {
        if (this.grantedCallback != null) {
            this.grantedCallback.onPermissionGranted();
        }
    }

    protected void fireOnPermissionDeniedCallback() {
        if (this.deniedCallback != null) {
            this.deniedCallback.onPermissionDenied();
        }
    }

    protected void fireOnPermissionShowRationaleCallback() {
        if (this.showRationaleCallback != null) {
            this.showRationaleCallback.onPermissionShowRationale(this);
        }
    }
}

