/*
 * Decompiled with CFR 0.152.
 */
package com.github.buchandersenn.android_permission_manager;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentCompat;
import android.support.v4.app.ActivityCompat;
import android.util.SparseArray;
import com.github.buchandersenn.android_permission_manager.PermissionRequest;
import com.github.buchandersenn.android_permission_manager.PermissionRequestBuilder;
import com.github.buchandersenn.android_permission_manager.PermissionUtil;

public abstract class PermissionManager {
    private static final int MAX_REQUEST_CODE = 255;
    private final Object requestCodeLock = new Object();
    private final SparseArray<PermissionRequest> requests = new SparseArray();

    public static PermissionManager create(Activity activity) {
        return new ActivityPermissionManager(activity);
    }

    public static PermissionManager create(Fragment fragment) {
        return new FragmentPermissionManager(fragment);
    }

    public PermissionRequestBuilder with(String ... permissions) {
        if (permissions.length < 1) {
            throw new IllegalArgumentException("PermissionManager.with(String... permissions) must be called with at least one permission");
        }
        return new PermissionRequestBuilder(this, permissions);
    }

    public boolean handlePermissionResult(int requestCode, @NonNull int[] grantResults) {
        PermissionRequest request = (PermissionRequest)this.requests.get(requestCode);
        if (request == null) {
            return false;
        }
        this.requests.delete(requestCode);
        if (PermissionUtil.verifyPermissionResults(grantResults)) {
            request.fireOnPermissionGrantedCallback();
        } else {
            request.fireOnPermissionDeniedCallback();
        }
        return true;
    }

    protected void check(PermissionRequest permissionRequest) {
        if (this.checkPermissions(permissionRequest.getPermissions())) {
            permissionRequest.fireOnPermissionGrantedCallback();
        } else {
            permissionRequest.fireOnPermissionDeniedCallback();
        }
    }

    protected void request(PermissionRequest permissionRequest) {
        if (this.checkPermissions(permissionRequest.getPermissions())) {
            permissionRequest.fireOnPermissionGrantedCallback();
            return;
        }
        if (this.shouldShowPermissionRationale(permissionRequest.getPermissions())) {
            permissionRequest.fireOnPermissionShowRationaleCallback();
        } else {
            this.requestPermission(permissionRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestPermission(PermissionRequest permissionRequest) {
        int requestCode;
        Object object = this.requestCodeLock;
        synchronized (object) {
            int userSuppliedRequestCode = permissionRequest.getRequestCode();
            if (userSuppliedRequestCode == -1) {
                requestCode = this.calculateRequestCode();
                this.requests.put(requestCode, (Object)permissionRequest);
            } else if (this.requests.get(userSuppliedRequestCode) == null) {
                requestCode = userSuppliedRequestCode;
                this.requests.put(requestCode, (Object)permissionRequest);
            } else {
                throw new IllegalStateException("The requestCode " + userSuppliedRequestCode + " is already in use");
            }
        }
        this.requestPermission(requestCode, permissionRequest.getPermissions());
    }

    protected abstract void requestPermission(int var1, String[] var2);

    protected abstract boolean checkPermissions(String[] var1);

    protected abstract boolean shouldShowPermissionRationale(String[] var1);

    private int calculateRequestCode() {
        for (int i = 0; i < 255; ++i) {
            if (this.requests.get(i) != null) continue;
            return i;
        }
        throw new IllegalStateException("Unable to calculate request code. Try setting a request code manually by calling PermissionRequestBuilder#usingRequestCode(int)");
    }

    private static class FragmentPermissionManager
    extends PermissionManager {
        @NonNull
        private final Fragment fragment;

        public FragmentPermissionManager(@NonNull Fragment fragment) {
            this.fragment = fragment;
        }

        @Override
        public void requestPermission(int requestCode, String[] permissions) {
            FragmentCompat.requestPermissions((Fragment)this.fragment, (String[])permissions, (int)requestCode);
        }

        @Override
        protected boolean checkPermissions(String[] permissions) {
            return PermissionUtil.checkPermissions((Context)this.fragment.getActivity(), permissions);
        }

        @Override
        protected boolean shouldShowPermissionRationale(String[] permissions) {
            return PermissionUtil.shouldShowPermissionRationale(this.fragment, permissions);
        }
    }

    private static class ActivityPermissionManager
    extends PermissionManager {
        @NonNull
        private final Activity activity;

        public ActivityPermissionManager(@NonNull Activity activity) {
            this.activity = activity;
        }

        @Override
        public void requestPermission(int requestCode, String[] permissions) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissions, (int)requestCode);
        }

        @Override
        protected boolean checkPermissions(String[] permissions) {
            return PermissionUtil.checkPermissions((Context)this.activity, permissions);
        }

        @Override
        protected boolean shouldShowPermissionRationale(String[] permissions) {
            return PermissionUtil.shouldShowPermissionRationale(this.activity, permissions);
        }
    }
}

