/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android.handler.notifydeveloper;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import androidx.core.content.FileProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.brightinventions.slf4android.handler.notifydeveloper.Slf4AndroidLogFileProvider;

class EmailErrorReport {
    private static final Logger LOG = LoggerFactory.getLogger((String)EmailErrorReport.class.getSimpleName());
    private final List<String> emailAddresses;
    private String message;
    private String emailSubject;
    private String emailBody;
    private List<AsyncTask<?, ?, File>> attachments = new ArrayList();

    EmailErrorReport(String message, List<String> emailAddresses, String emailSubject, String emailBody) {
        this.message = message;
        this.emailAddresses = emailAddresses;
        this.emailSubject = emailSubject;
        this.emailBody = emailBody;
    }

    public void addFileAttachmentFrom(AsyncTask<?, ?, File> attachment) {
        this.attachments.add(attachment);
    }

    public void configureRecipients(Intent sendEmail) {
        String[] emails = new String[this.emailAddresses.size()];
        this.emailAddresses.toArray(emails);
        sendEmail.putExtra("android.intent.extra.EMAIL", emails);
    }

    public void configureSubject(Intent sendEmail) {
        sendEmail.putExtra("android.intent.extra.SUBJECT", this.emailSubject);
    }

    public void configureMessage(Intent sendEmail) {
        sendEmail.putExtra("android.intent.extra.TEXT", this.emailBody + this.message);
    }

    public void configureAttachments(Intent sendEmail, Context context) {
        String authority = Slf4AndroidLogFileProvider.getAuthority(context);
        ArrayList<Uri> attachmentsUris = new ArrayList<Uri>();
        for (AsyncTask<?, ?, File> fileAttachmentSource : this.attachments) {
            Uri uri = this.buildAttachmentUri(fileAttachmentSource, context, authority);
            if (uri == null) continue;
            attachmentsUris.add(uri);
        }
        sendEmail.putParcelableArrayListExtra("android.intent.extra.STREAM", attachmentsUris);
        sendEmail.addFlags(1);
    }

    private Uri buildAttachmentUri(AsyncTask<?, ?, File> attachmentTask, Context context, String authority) {
        try {
            File file = (File)attachmentTask.get(5L, TimeUnit.SECONDS);
            if (file != null) {
                return FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            }
            LOG.warn("Attachment task {} returned null", (Object)attachmentTask.getClass().getSimpleName());
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for attachment", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn("Error while waiting for attachment", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn("Timed out while waiting for attachment", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("The selected file can't be shared", (Throwable)e);
        }
        return null;
    }
}

