/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import pl.brightinventions.slf4android.FileHandlerExpose;
import pl.brightinventions.slf4android.FileLogHandlerConfiguration;
import pl.brightinventions.slf4android.LogRecordFormatter;
import pl.brightinventions.slf4android.LogRecordFormatterUtilFormatterAdapter;

class FileLogHandler
extends FileLogHandlerConfiguration {
    private static String TAG = FileLogHandler.class.getSimpleName();
    private FileHandler fileHandler;
    private FileHandlerConfigParams config;
    private FileHandlerExpose fileHandlerExpose;
    private boolean triedInititializing;

    public FileLogHandler(Context context, LogRecordFormatter formatter) {
        this.config = FileHandlerConfigParams.defaults(context);
        this.config.formatter = formatter;
        this.fileHandlerExpose = new FileHandlerExpose();
    }

    @Override
    public Filter getFilter() {
        this.ensureInitialized();
        return this.fileHandler.getFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (!this.triedInititializing) {
            FileLogHandler fileLogHandler = this;
            synchronized (fileLogHandler) {
                if (!this.triedInititializing) {
                    try {
                        this.fileHandler = new FileHandler(this.config.fileName, this.config.limit, this.config.count, this.config.append);
                        this.fileHandler.setFormatter(this.config.getFormatterAdapter());
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Could not create FileHandler", (Throwable)e);
                    }
                    this.triedInititializing = true;
                }
            }
        }
    }

    @Override
    public void setFilter(Filter newFilter) {
        super.setFilter(newFilter);
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.setFilter(newFilter);
        }
    }

    @Override
    public Formatter getFormatter() {
        this.ensureInitialized();
        if (this.fileHandler != null) {
            return this.fileHandler.getFormatter();
        }
        return null;
    }

    @Override
    public void setFormatter(Formatter newFormatter) {
        super.setFormatter(newFormatter);
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.setFormatter(newFormatter);
        }
    }

    @Override
    public void setLevel(Level newLevel) {
        super.setLevel(newLevel);
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.setLevel(newLevel);
        }
    }

    @Override
    public void setEncoding(String charsetName) throws UnsupportedEncodingException {
        super.setEncoding(charsetName);
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.setEncoding(charsetName);
        }
    }

    @Override
    public void setErrorManager(ErrorManager newErrorManager) {
        super.setErrorManager(newErrorManager);
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.setErrorManager(newErrorManager);
        }
    }

    @Override
    public void close() {
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }

    @Override
    public void flush() {
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.flush();
        }
    }

    @Override
    public void publish(LogRecord record) {
        this.ensureInitialized();
        if (this.fileHandler != null) {
            this.fileHandler.publish(record);
        }
    }

    @Override
    public FileLogHandlerConfiguration setFullFilePathPattern(String fullPathPattern) {
        this.ensureNotInitialized();
        this.config.fileName = fullPathPattern;
        return this;
    }

    private void ensureNotInitialized() {
        if (this.fileHandler != null) {
            throw new IllegalStateException("You can only change configuration before file handler is added to logger");
        }
    }

    @Override
    public FileLogHandlerConfiguration setRotateFilesCountLimit(int count) {
        this.ensureNotInitialized();
        this.config.count = count;
        return this;
    }

    @Override
    public FileLogHandlerConfiguration setLogFileSizeLimitInBytes(int maxFileSizeInBytes) {
        this.ensureNotInitialized();
        this.config.limit = maxFileSizeInBytes;
        return this;
    }

    @Override
    public String getCurrentFileName() {
        this.ensureInitialized();
        return this.fileHandlerExpose.getCurrentFileName(this.fileHandler);
    }

    private static class FileHandlerConfigParams {
        String fileName;
        int limit;
        int count;
        boolean append;
        LogRecordFormatter formatter;

        private FileHandlerConfigParams() {
        }

        static FileHandlerConfigParams defaults(Context context) {
            FileHandlerConfigParams configParams = new FileHandlerConfigParams();
            configParams.limit = 524288;
            configParams.count = 5;
            configParams.fileName = new File(context.getApplicationInfo().dataDir, context.getPackageName() + ".%g.%u.log").getAbsolutePath();
            configParams.append = true;
            return configParams;
        }

        LogRecordFormatterUtilFormatterAdapter getFormatterAdapter() {
            return new LogRecordFormatterUtilFormatterAdapter(this.formatter);
        }
    }
}

