/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.hardware.SensorManager;
import android.os.AsyncTask;
import android.os.Looper;
import android.util.Log;
import com.squareup.seismic.ShakeDetector;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import pl.brightinventions.slf4android.ActivityStateListener;
import pl.brightinventions.slf4android.AtLeastFilter;
import pl.brightinventions.slf4android.Lists;
import pl.brightinventions.slf4android.LogLevel;
import pl.brightinventions.slf4android.LogRecord;
import pl.brightinventions.slf4android.NotifyDeveloperDialogDisplayActivity;

public class NotifyDeveloperHandler
extends Handler {
    private static final String TAG = NotifyDeveloperHandler.class.getSimpleName();
    private final Context context;
    private final List<String> emailAddress;
    private final WeakReference<ActivityStateListener> activityState;
    private final ShakeDetector shakeDetector;
    private Filter filter;
    private AlertDialog dialog;
    private android.os.Handler mailLoopHandler = new android.os.Handler(Looper.getMainLooper());
    private ArrayList<String> attachmentClassList;

    NotifyDeveloperHandler(Application context, Iterable<String> emailAddress, ActivityStateListener activityState) {
        this(context, emailAddress, LogLevel.ERROR, activityState);
    }

    NotifyDeveloperHandler(Application context, Iterable<String> emailAddress, LogLevel minLevel, ActivityStateListener stateListener) {
        this.context = context;
        this.emailAddress = Lists.newArrayList(emailAddress);
        this.filter = new AtLeastFilter(minLevel);
        this.activityState = new WeakReference<ActivityStateListener>(stateListener);
        this.attachmentClassList = new ArrayList();
        this.shakeDetector = new ShakeDetector(new ShakeDetector.Listener(){

            @Override
            public void hearShake() {
                ActivityStateListener listener = (ActivityStateListener)NotifyDeveloperHandler.this.activityState.get();
                if (listener != null) {
                    if (listener.isAppInForeground()) {
                        NotifyDeveloperHandler.this.beginPublishOnMainThread(new java.util.logging.LogRecord(Level.INFO, "Report a problem with app"));
                    } else {
                        Log.i((String)TAG, (String)"Ignore shake event - the app appears to be in background");
                    }
                } else {
                    Log.i((String)TAG, (String)"Ignore shake event - can't detect if app is in foreground (API < 14)");
                }
            }
        });
    }

    private void beginPublishOnMainThread(java.util.logging.LogRecord record) {
        this.mailLoopHandler.post((Runnable)new ShowDialogBecauseOfRecord(LogRecord.fromRecord(record)));
    }

    public void setMinLogLevel(LogLevel logLevel) {
        this.setFilter(new AtLeastFilter(logLevel));
    }

    @Override
    public void setFilter(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter must not be null");
        }
        this.filter = filter;
    }

    @Override
    public void close() {
        this.mailLoopHandler.removeCallbacksAndMessages(null);
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        this.shakeDetector.stop();
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(java.util.logging.LogRecord record) {
        if (this.filter.isLoggable(record)) {
            this.beginPublishOnMainThread(record);
        }
    }

    private boolean isQuestionPending() {
        return this.dialog != null && this.dialog.isShowing();
    }

    private void destroyDialog() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    public void addAttachmentClass(Class<? extends AsyncTask<Context, Void, File>> attachmentClass) {
        if (attachmentClass == null) {
            throw new IllegalArgumentException("attachmentClass must not be null");
        }
        try {
            attachmentClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't create attachment factory from class " + attachmentClass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't create attachment factory from class " + attachmentClass, e);
        }
        this.attachmentClassList.add(attachmentClass.getName());
    }

    public void notifyWhenDeviceIsShaken() {
        if (this.activityState.get() != null) {
            SensorManager manager = (SensorManager)this.context.getSystemService("sensor");
            if (manager == null) {
                Log.w((String)TAG, (String)"Sensor manager is null will not install shake reporter");
            } else if (!this.shakeDetector.start(manager)) {
                Log.w((String)TAG, (String)"Failed to start shake detector");
            }
        } else {
            Log.w((String)TAG, (String)"Will not notify on shake - can't detect if app is in foreground (API < 14)");
        }
    }

    private ArrayList<String> getAttachmentClassList() {
        return this.attachmentClassList;
    }

    private class ShowDialogBecauseOfRecord
    implements Runnable {
        private final LogRecord record;

        public ShowDialogBecauseOfRecord(LogRecord record) {
            this.record = record;
        }

        @Override
        public void run() {
            if (NotifyDeveloperHandler.this.isQuestionPending()) {
                return;
            }
            NotifyDeveloperHandler.this.destroyDialog();
            Activity currentActivity = this.obtainActivityContext();
            if (currentActivity != null) {
                NotifyDeveloperHandler.this.dialog = NotifyDeveloperDialogDisplayActivity.showDialogIn((Context)currentActivity, this.record, NotifyDeveloperHandler.this.emailAddress, NotifyDeveloperHandler.this.getAttachmentClassList());
            } else {
                Intent showDialogActivityIntent = NotifyDeveloperDialogDisplayActivity.showIntent(NotifyDeveloperHandler.this.context, this.record, NotifyDeveloperHandler.this.emailAddress, NotifyDeveloperHandler.this.getAttachmentClassList());
                NotifyDeveloperHandler.this.context.startActivity(showDialogActivityIntent);
            }
        }

        private Activity obtainActivityContext() {
            ActivityStateListener activityStateListener = (ActivityStateListener)NotifyDeveloperHandler.this.activityState.get();
            Activity activity = null;
            if (activityStateListener != null) {
                activity = activityStateListener.getLastUsedActivity();
            }
            return activity;
        }
    }
}

