/*
 * Decompiled with CFR 0.152.
 */
package pl.brightinventions.slf4android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import pl.brightinventions.slf4android.Disposable;
import pl.brightinventions.slf4android.EmailErrorReport;
import pl.brightinventions.slf4android.LogRecord;
import pl.brightinventions.slf4android.MessageValueSupplier;

public class NotifyDeveloperDialogDisplayActivity
extends Activity {
    private static final String TAG = NotifyDeveloperDialogDisplayActivity.class.getSimpleName();
    private static final MessageValueSupplier messageFormatter = new MessageValueSupplier();
    private AlertDialog dialog;

    public static Intent showIntent(Context context, LogRecord record, List<String> emailAddresses, Iterable<String> attachmentsClasses) {
        Intent intent = new Intent(context, NotifyDeveloperDialogDisplayActivity.class);
        intent.setFlags(0x14000000);
        intent.putExtra("log_record", NotifyDeveloperDialogDisplayActivity.getMessage(record));
        intent.putExtra("email_addresses", new ArrayList<String>(emailAddresses));
        ArrayList<String> attachmentClassNames = new ArrayList<String>();
        for (String reporterClass : attachmentsClasses) {
            attachmentClassNames.add(reporterClass);
        }
        intent.putExtra("attachments", attachmentClassNames);
        return intent;
    }

    private static String getMessage(LogRecord record) {
        StringBuilder builderBuilder = new StringBuilder();
        messageFormatter.append(record, builderBuilder);
        return builderBuilder.toString();
    }

    public static AlertDialog showDialogIn(Context activityContext, LogRecord record, List<String> emailAddresses, Iterable<String> attachmentTasks) {
        return NotifyDeveloperDialogDisplayActivity.showDialogIn(activityContext, NotifyDeveloperDialogDisplayActivity.getMessage(record), emailAddresses, NotifyDeveloperDialogDisplayActivity.buildAttachmentFactories(attachmentTasks), null);
    }

    private static AlertDialog showDialogIn(final Context activityContext, String message, List<String> emailAddresses, Iterable<AsyncTask<Context, Void, File>> attachmentTasks, final Disposable onDialogClose) {
        final EmailErrorReport emailErrorReport = new EmailErrorReport(message, emailAddresses);
        for (AsyncTask<Context, Void, File> attachment : attachmentTasks) {
            NotifyDeveloperDialogDisplayActivity.startTaskExecution(activityContext, attachment);
            emailErrorReport.addFileAttachmentFrom(attachment);
        }
        String shortMessage = message;
        int end = message.indexOf("\n");
        if (end > 0) {
            shortMessage = message.substring(0, end);
        }
        AlertDialog alertDialog = new AlertDialog.Builder(activityContext).setTitle((CharSequence)"Notify developer about error?").setMessage((CharSequence)shortMessage).setCancelable(true).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                NotifyDeveloperDialogDisplayActivity.sendEmailWithError(activityContext, emailErrorReport);
                dialog.dismiss();
                if (onDialogClose != null) {
                    onDialogClose.dispose();
                }
            }
        }).setNegativeButton(17039369, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (onDialogClose != null) {
                    onDialogClose.dispose();
                }
            }
        }).create();
        alertDialog.show();
        return alertDialog;
    }

    private static List<AsyncTask<Context, Void, File>> buildAttachmentFactories(Iterable<String> attachmentsClasses) {
        ArrayList<AsyncTask<Context, Void, File>> attachmentTasks = new ArrayList<AsyncTask<Context, Void, File>>();
        for (String attachmentClassName : attachmentsClasses) {
            Class<? extends AsyncTask<Context, Void, File>> attachmentClass = NotifyDeveloperDialogDisplayActivity.loadAttachmentFactoryClass(attachmentClassName);
            if (attachmentClass == null) continue;
            try {
                attachmentTasks.add(attachmentClass.newInstance());
            }
            catch (InstantiationException e) {
                Log.e((String)TAG, (String)("Can't create attachment factory from class " + attachmentClassName + " " + e));
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)("Can't create attachment factory from class " + attachmentClassName + " " + e));
            }
        }
        return attachmentTasks;
    }

    @TargetApi(value=11)
    private static void startTaskExecution(Context activityContext, AsyncTask<Context, Void, File> attachment) {
        if (Build.VERSION.SDK_INT < 11) {
            attachment.execute((Object[])new Context[]{activityContext});
        } else {
            attachment.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Context[]{activityContext});
        }
    }

    private static void sendEmailWithError(Context activityContext, EmailErrorReport emailErrorReport) {
        Intent sendEmail = new Intent("android.intent.action.SEND_MULTIPLE");
        sendEmail.setType("message/rfc822");
        emailErrorReport.configureRecipients(sendEmail);
        emailErrorReport.configureSubject(sendEmail, activityContext);
        emailErrorReport.configureMessage(sendEmail);
        emailErrorReport.configureAttachments(sendEmail);
        try {
            activityContext.startActivity(Intent.createChooser((Intent)sendEmail, (CharSequence)"Send mail..."));
        }
        catch (ActivityNotFoundException ex) {
            Toast.makeText((Context)activityContext, (CharSequence)"There are no email clients installed.", (int)0).show();
        }
    }

    private static Class<? extends AsyncTask<Context, Void, File>> loadAttachmentFactoryClass(String attachmentClassName) {
        Class<?> attachmentClass = null;
        try {
            attachmentClass = Class.forName(attachmentClassName);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Class not found for attachment " + attachmentClassName + " " + e));
        }
        return attachmentClass;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String log_record = (String)((Object)this.getIntent().getSerializableExtra("log_record"));
        List emailAddresses = (List)((Object)this.getIntent().getSerializableExtra("email_addresses"));
        List<AsyncTask<Context, Void, File>> attachmentTasks = this.buildAttachmentFactoriesFromIntent();
        if (log_record != null) {
            this.dialog = NotifyDeveloperDialogDisplayActivity.showDialogIn((Context)this, log_record, emailAddresses, attachmentTasks, new Disposable(){

                @Override
                public void dispose() {
                    NotifyDeveloperDialogDisplayActivity.this.finish();
                }
            });
        } else {
            this.finish();
        }
    }

    private List<AsyncTask<Context, Void, File>> buildAttachmentFactoriesFromIntent() {
        ArrayList<String> attachmentsClasses = this.getAttachmentFactoriesClassNames();
        return NotifyDeveloperDialogDisplayActivity.buildAttachmentFactories(attachmentsClasses);
    }

    private ArrayList<String> getAttachmentFactoriesClassNames() {
        return (ArrayList)this.getIntent().getSerializableExtra("attachments");
    }

    protected void onDestroy() {
        if (this.dialog != null) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        super.onDestroy();
    }
}

