/*
 * Decompiled with CFR 0.152.
 */
package com.desmond.squarecamera;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Base64;
import android.view.Display;
import android.view.WindowManager;
import com.desmond.squarecamera.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ImageUtility {
    public static String convertBitmapToString(Bitmap bitmap) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
        return Base64.encodeToString((byte[])out.toByteArray(), (int)0);
    }

    public static byte[] convertBitmapStringToByteArray(String bitmapByteString) {
        return Base64.decode((String)bitmapByteString, (int)0);
    }

    public static Bitmap rotatePicture(Context context, int rotation, byte[] data) {
        Bitmap bitmap = ImageUtility.decodeSampledBitmapFromByte(context, data);
        if (rotation != 0) {
            Bitmap oldBitmap = bitmap;
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotation);
            bitmap = Bitmap.createBitmap((Bitmap)oldBitmap, (int)0, (int)0, (int)oldBitmap.getWidth(), (int)oldBitmap.getHeight(), (Matrix)matrix, (boolean)false);
            oldBitmap.recycle();
        }
        return bitmap;
    }

    public static Uri savePicture(Context context, Bitmap bitmap) {
        int cropHeight = bitmap.getHeight() > bitmap.getWidth() ? bitmap.getWidth() : bitmap.getHeight();
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)cropHeight, (int)cropHeight, (int)2);
        File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), context.getString(R.string.squarecamera__app_name));
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        File mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            FileOutputStream stream = new FileOutputStream(mediaFile);
            stream.write(out.toByteArray());
            stream.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        Intent mediaScannerIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        Uri fileContentUri = Uri.fromFile((File)mediaFile);
        mediaScannerIntent.setData(fileContentUri);
        context.sendBroadcast(mediaScannerIntent);
        return fileContentUri;
    }

    public static Bitmap decodeSampledBitmapFromPath(String path, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inMutable = true;
        options.inBitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtility.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inScaled = true;
        options.inDensity = options.outWidth;
        options.inTargetDensity = reqWidth * options.inSampleSize;
        options.inJustDecodeBounds = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeSampledBitmapFromByte(Context context, byte[] bitmapBytes) {
        int reqHeight;
        int reqWidth;
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 13) {
            display.getSize(point);
            reqWidth = point.x;
            reqHeight = point.y;
        } else {
            reqWidth = display.getWidth();
            reqHeight = display.getHeight();
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inMutable = true;
        options.inBitmap = BitmapFactory.decodeByteArray((byte[])bitmapBytes, (int)0, (int)bitmapBytes.length, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtility.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inScaled = true;
        options.inDensity = options.outWidth;
        options.inTargetDensity = reqWidth * options.inSampleSize;
        options.inJustDecodeBounds = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        return BitmapFactory.decodeByteArray((byte[])bitmapBytes, (int)0, (int)bitmapBytes.length, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int roundedInSampleSize;
        int initialInSampleSize = ImageUtility.computeInitialSampleSize(options, reqWidth, reqHeight);
        if (initialInSampleSize <= 8) {
            for (roundedInSampleSize = 1; roundedInSampleSize < initialInSampleSize; roundedInSampleSize <<= 1) {
            }
        } else {
            roundedInSampleSize = (initialInSampleSize + 7) / 8 * 8;
        }
        return roundedInSampleSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int upperBound;
        double height = options.outHeight;
        double width = options.outWidth;
        long maxNumOfPixels = reqWidth * reqHeight;
        int minSideLength = Math.min(reqHeight, reqWidth);
        int lowerBound = maxNumOfPixels < 0L ? 1 : (int)Math.ceil(Math.sqrt(width * height / (double)maxNumOfPixels));
        int n = upperBound = minSideLength < 0 ? 128 : (int)Math.min(Math.floor(width / (double)minSideLength), Math.floor(height / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels < 0L && minSideLength < 0) {
            return 1;
        }
        if (minSideLength < 0) {
            return lowerBound;
        }
        return upperBound;
    }
}

