/*
 * Decompiled with CFR 0.152.
 */
package com.desmond.squarecamera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.TextView;
import com.desmond.squarecamera.EditSavePhotoFragment;
import com.desmond.squarecamera.ImageParameters;
import com.desmond.squarecamera.R;
import com.desmond.squarecamera.ResizeAnimation;
import com.desmond.squarecamera.SquareCameraPreview;
import java.io.IOException;
import java.util.List;

public class CameraFragment
extends Fragment
implements SurfaceHolder.Callback,
Camera.PictureCallback {
    public static final String TAG = CameraFragment.class.getSimpleName();
    public static final String CAMERA_ID_KEY = "camera_id";
    public static final String CAMERA_FLASH_KEY = "flash_mode";
    public static final String IMAGE_INFO = "image_info";
    private static final int PICTURE_SIZE_MAX_WIDTH = 1280;
    private static final int PREVIEW_SIZE_MAX_WIDTH = 640;
    private int mCameraID;
    private String mFlashMode;
    private Camera mCamera;
    private SquareCameraPreview mPreviewView;
    private SurfaceHolder mSurfaceHolder;
    private ImageParameters mImageParameters;
    private CameraOrientationListener mOrientationListener;

    public static Fragment newInstance() {
        return new CameraFragment();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mOrientationListener = new CameraOrientationListener((Context)activity);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.mCameraID = this.getBackCameraID();
            this.mFlashMode = "auto";
            this.mImageParameters = new ImageParameters();
        } else {
            this.mCameraID = savedInstanceState.getInt(CAMERA_ID_KEY);
            this.mFlashMode = savedInstanceState.getString(CAMERA_FLASH_KEY);
            this.mImageParameters = (ImageParameters)savedInstanceState.getParcelable(IMAGE_INFO);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.squarecamera__fragment_camera, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mOrientationListener.enable();
        this.mPreviewView = (SquareCameraPreview)view.findViewById(R.id.camera_preview_view);
        this.mPreviewView.getHolder().addCallback((SurfaceHolder.Callback)this);
        final View topCoverView = view.findViewById(R.id.cover_top_view);
        final View btnCoverView = view.findViewById(R.id.cover_bottom_view);
        boolean bl = this.mImageParameters.mIsPortrait = this.getResources().getConfiguration().orientation == 1;
        if (savedInstanceState == null) {
            ViewTreeObserver observer = this.mPreviewView.getViewTreeObserver();
            observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ((CameraFragment)CameraFragment.this).mImageParameters.mPreviewWidth = CameraFragment.this.mPreviewView.getWidth();
                    ((CameraFragment)CameraFragment.this).mImageParameters.mPreviewHeight = CameraFragment.this.mPreviewView.getHeight();
                    ((CameraFragment)CameraFragment.this).mImageParameters.mCoverWidth = ((CameraFragment)CameraFragment.this).mImageParameters.mCoverHeight = CameraFragment.this.mImageParameters.calculateCoverWidthHeight();
                    CameraFragment.this.resizeTopAndBtmCover(topCoverView, btnCoverView);
                    if (Build.VERSION.SDK_INT >= 16) {
                        CameraFragment.this.mPreviewView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        CameraFragment.this.mPreviewView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        } else if (this.mImageParameters.isPortrait()) {
            topCoverView.getLayoutParams().height = this.mImageParameters.mCoverHeight;
            btnCoverView.getLayoutParams().height = this.mImageParameters.mCoverHeight;
        } else {
            topCoverView.getLayoutParams().width = this.mImageParameters.mCoverWidth;
            btnCoverView.getLayoutParams().width = this.mImageParameters.mCoverWidth;
        }
        ImageView swapCameraBtn = (ImageView)view.findViewById(R.id.change_camera);
        swapCameraBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CameraFragment.this.mCameraID == 1) {
                    CameraFragment.this.mCameraID = CameraFragment.this.getBackCameraID();
                } else {
                    CameraFragment.this.mCameraID = CameraFragment.this.getFrontCameraID();
                }
                CameraFragment.this.restartPreview();
            }
        });
        View changeCameraFlashModeBtn = view.findViewById(R.id.flash);
        changeCameraFlashModeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CameraFragment.this.mFlashMode.equalsIgnoreCase("auto")) {
                    CameraFragment.this.mFlashMode = "on";
                } else if (CameraFragment.this.mFlashMode.equalsIgnoreCase("on")) {
                    CameraFragment.this.mFlashMode = "off";
                } else if (CameraFragment.this.mFlashMode.equalsIgnoreCase("off")) {
                    CameraFragment.this.mFlashMode = "auto";
                }
                CameraFragment.this.setupFlashMode();
                CameraFragment.this.setupCamera();
            }
        });
        this.setupFlashMode();
        ImageView takePhotoBtn = (ImageView)view.findViewById(R.id.capture_image_button);
        takePhotoBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CameraFragment.this.takePicture();
            }
        });
    }

    private void setupFlashMode() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        TextView autoFlashIcon = (TextView)view.findViewById(R.id.auto_flash_icon);
        if ("auto".equalsIgnoreCase(this.mFlashMode)) {
            autoFlashIcon.setText((CharSequence)"Auto");
        } else if ("on".equalsIgnoreCase(this.mFlashMode)) {
            autoFlashIcon.setText((CharSequence)"On");
        } else if ("off".equalsIgnoreCase(this.mFlashMode)) {
            autoFlashIcon.setText((CharSequence)"Off");
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(CAMERA_ID_KEY, this.mCameraID);
        outState.putString(CAMERA_FLASH_KEY, this.mFlashMode);
        outState.putParcelable(IMAGE_INFO, (Parcelable)this.mImageParameters);
        super.onSaveInstanceState(outState);
    }

    private void resizeTopAndBtmCover(View topCover, View bottomCover) {
        ResizeAnimation resizeTopAnimation = new ResizeAnimation(topCover, this.mImageParameters);
        resizeTopAnimation.setDuration(800L);
        resizeTopAnimation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        topCover.startAnimation((Animation)resizeTopAnimation);
        ResizeAnimation resizeBtmAnimation = new ResizeAnimation(bottomCover, this.mImageParameters);
        resizeBtmAnimation.setDuration(800L);
        resizeBtmAnimation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        bottomCover.startAnimation((Animation)resizeBtmAnimation);
    }

    private void getCamera(int cameraID) {
        try {
            this.mCamera = Camera.open((int)cameraID);
            this.mPreviewView.setCamera(this.mCamera);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Can't open camera with id " + cameraID));
            e.printStackTrace();
        }
    }

    private void startCameraPreview() {
        this.determineDisplayOrientation();
        this.setupCamera();
        try {
            this.mCamera.setPreviewDisplay(this.mSurfaceHolder);
            this.mCamera.startPreview();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Can't start camera preview due to IOException " + e));
            e.printStackTrace();
        }
    }

    private void stopCameraPreview() {
        this.mCamera.stopPreview();
        this.mPreviewView.setCamera(null);
    }

    private void determineDisplayOrientation() {
        int displayOrientation;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCameraID, (Camera.CameraInfo)cameraInfo);
        int rotation = this.getActivity().getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (cameraInfo.facing == 1) {
            displayOrientation = (cameraInfo.orientation + degrees) % 360;
            displayOrientation = (360 - displayOrientation) % 360;
        } else {
            displayOrientation = (cameraInfo.orientation - degrees + 360) % 360;
        }
        this.mImageParameters.mDisplayOrientation = displayOrientation;
        this.mImageParameters.mLayoutOrientation = degrees;
        this.mCamera.setDisplayOrientation(this.mImageParameters.mDisplayOrientation);
    }

    private void setupCamera() {
        Camera.Parameters parameters = this.mCamera.getParameters();
        Camera.Size bestPreviewSize = this.determineBestPreviewSize(parameters);
        Camera.Size bestPictureSize = this.determineBestPictureSize(parameters);
        parameters.setPreviewSize(bestPreviewSize.width, bestPreviewSize.height);
        parameters.setPictureSize(bestPictureSize.width, bestPictureSize.height);
        if (parameters.getSupportedFocusModes().contains("continuous-picture")) {
            parameters.setFocusMode("continuous-picture");
        }
        View changeCameraFlashModeBtn = this.getView().findViewById(R.id.flash);
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes != null && flashModes.contains(this.mFlashMode)) {
            parameters.setFlashMode(this.mFlashMode);
            changeCameraFlashModeBtn.setVisibility(0);
        } else {
            changeCameraFlashModeBtn.setVisibility(4);
        }
        this.mCamera.setParameters(parameters);
    }

    private Camera.Size determineBestPreviewSize(Camera.Parameters parameters) {
        return this.determineBestSize(parameters.getSupportedPreviewSizes(), 640);
    }

    private Camera.Size determineBestPictureSize(Camera.Parameters parameters) {
        return this.determineBestSize(parameters.getSupportedPictureSizes(), 1280);
    }

    private Camera.Size determineBestSize(List<Camera.Size> sizes, int widthThreshold) {
        Camera.Size bestSize = null;
        int numOfSizes = sizes.size();
        for (int i = 0; i < numOfSizes; ++i) {
            boolean isBetterSize;
            Camera.Size size = sizes.get(i);
            boolean isDesireRatio = size.width / 4 == size.height / 3;
            boolean bl = isBetterSize = bestSize == null || size.width > bestSize.width;
            if (!isDesireRatio || !isBetterSize) continue;
            bestSize = size;
        }
        if (bestSize == null) {
            Log.d((String)TAG, (String)"cannot find the best camera size");
            return sizes.get(sizes.size() - 1);
        }
        return bestSize;
    }

    private void restartPreview() {
        if (this.mCamera != null) {
            this.stopCameraPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
        this.getCamera(this.mCameraID);
        this.startCameraPreview();
    }

    private int getFrontCameraID() {
        PackageManager pm = this.getActivity().getPackageManager();
        if (pm.hasSystemFeature("android.hardware.camera.front")) {
            return 1;
        }
        return this.getBackCameraID();
    }

    private int getBackCameraID() {
        return 0;
    }

    private void takePicture() {
        this.mOrientationListener.rememberOrientation();
        Camera.ShutterCallback shutterCallback = null;
        Camera.PictureCallback raw = null;
        Camera.PictureCallback postView = null;
        this.mCamera.takePicture(shutterCallback, raw, postView, (Camera.PictureCallback)this);
    }

    public void onStop() {
        this.mOrientationListener.disable();
        if (this.mCamera != null) {
            this.stopCameraPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
        super.onStop();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.getCamera(this.mCameraID);
        this.startCameraPreview();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 1: {
                Uri imageUri = data.getData();
                break;
            }
            default: {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void onPictureTaken(byte[] data, Camera camera) {
        int rotation = this.getPhotoRotation();
        this.getFragmentManager().beginTransaction().replace(R.id.fragment_container, EditSavePhotoFragment.newInstance(data, rotation, this.mImageParameters.createCopy()), EditSavePhotoFragment.TAG).addToBackStack(null).commit();
    }

    private int getPhotoRotation() {
        int orientation = this.mOrientationListener.getRememberedNormalOrientation();
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCameraID, (Camera.CameraInfo)info);
        int rotation = info.facing == 1 ? (info.orientation - orientation + 360) % 360 : (info.orientation + orientation) % 360;
        return rotation;
    }

    private static class CameraOrientationListener
    extends OrientationEventListener {
        private int mCurrentNormalizedOrientation;
        private int mRememberedNormalOrientation;

        public CameraOrientationListener(Context context) {
            super(context, 3);
        }

        public void onOrientationChanged(int orientation) {
            if (orientation != -1) {
                this.mCurrentNormalizedOrientation = this.normalize(orientation);
            }
        }

        private int normalize(int degrees) {
            if (degrees > 315 || degrees <= 45) {
                return 0;
            }
            if (degrees > 45 && degrees <= 135) {
                return 90;
            }
            if (degrees > 135 && degrees <= 225) {
                return 180;
            }
            if (degrees > 225 && degrees <= 315) {
                return 270;
            }
            throw new RuntimeException("The physics as we know them are no more. Watch out for anomalies.");
        }

        public void rememberOrientation() {
            this.mRememberedNormalOrientation = this.mCurrentNormalizedOrientation;
        }

        public int getRememberedNormalOrientation() {
            this.rememberOrientation();
            return this.mRememberedNormalOrientation;
        }
    }
}

