/*
 * Decompiled with CFR 0.152.
 */
package com.bosphere.filelogger;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.bosphere.filelogger.FLUtil;
import com.bosphere.filelogger.FileFormatter;
import com.bosphere.filelogger.Loggable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FLConfig {
    final Builder b;

    private FLConfig(Builder b) {
        this.b = b;
    }

    public static class DefaultFormatter
    implements FileFormatter {
        private final ThreadLocal<SimpleDateFormat> mTimeFmt = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
            }
        };
        private final ThreadLocal<SimpleDateFormat> mFileNameFmt = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("MM_dd_HH", Locale.ENGLISH);
            }
        };
        private final ThreadLocal<Date> mDate = new ThreadLocal<Date>(){

            @Override
            protected Date initialValue() {
                return new Date();
            }
        };
        private final String mLineFmt = "%s %d-%d %s/%s: %s";

        @Override
        public String formatLine(long timeInMillis, String level, String tag, String log) {
            this.mDate.get().setTime(timeInMillis);
            String timestamp = this.mTimeFmt.get().format(this.mDate.get());
            int processId = Process.myPid();
            int threadId = Process.myTid();
            return String.format(Locale.ENGLISH, "%s %d-%d %s/%s: %s", timestamp, processId, threadId, level, tag, log);
        }

        @Override
        public String formatFileName(long timeInMillis) {
            this.mDate.get().setTime(timeInMillis);
            return this.mFileNameFmt.get().format(this.mDate.get()) + "_00.txt";
        }
    }

    public static class DefaultLog
    implements Loggable {
        @Override
        public void v(String tag, String log) {
            Log.v((String)tag, (String)log);
        }

        @Override
        public void d(String tag, String log) {
            Log.d((String)tag, (String)log);
        }

        @Override
        public void i(String tag, String log) {
            Log.i((String)tag, (String)log);
        }

        @Override
        public void w(String tag, String log) {
            Log.w((String)tag, (String)log);
        }

        @Override
        public void e(String tag, String log) {
            Log.e((String)tag, (String)log);
        }

        @Override
        public void e(String tag, String log, Throwable tr) {
            Log.e((String)tag, (String)log, (Throwable)tr);
        }
    }

    public static class Builder {
        final Context context;
        Loggable logger = new DefaultLog();
        FileFormatter formatter;
        String dirPath;
        String defaultTag;
        boolean logToFile;
        int retentionPolicy = 1;
        int maxFileCount = 168;
        long maxSize = 0x2000000L;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder logger(Loggable logger) {
            this.logger = logger;
            return this;
        }

        public Builder formatter(FileFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder dir(File dir) {
            if (dir != null) {
                this.dirPath = dir.getAbsolutePath();
            }
            return this;
        }

        public Builder defaultTag(String tag) {
            this.defaultTag = tag;
            return this;
        }

        public Builder logToFile(boolean logToFile) {
            this.logToFile = logToFile;
            return this;
        }

        public Builder retentionPolicy(int retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        public Builder maxFileCount(int maxFileCount) {
            this.maxFileCount = maxFileCount;
            return this;
        }

        public Builder maxTotalSize(long maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public FLConfig build() {
            if (TextUtils.isEmpty((CharSequence)this.defaultTag)) {
                this.defaultTag = FLUtil.getAppName(this.context);
            }
            if (this.logToFile) {
                if (this.formatter == null) {
                    this.formatter = new DefaultFormatter();
                }
                if (TextUtils.isEmpty((CharSequence)this.dirPath)) {
                    File dir = this.context.getExternalFilesDir("log");
                    if (dir != null) {
                        this.dirPath = dir.getAbsolutePath();
                    } else {
                        Log.e((String)"FileLogger", (String)"failed to resolve default log file directory");
                    }
                }
                if (this.retentionPolicy < 0) {
                    throw new IllegalArgumentException("invalid retention policy: " + this.retentionPolicy);
                }
                switch (this.retentionPolicy) {
                    case 1: {
                        if (this.maxFileCount > 0) break;
                        throw new IllegalArgumentException("max file count must be > 0");
                    }
                    case 2: {
                        if (this.maxSize > 0L) break;
                        throw new IllegalArgumentException("max total size must be > 0");
                    }
                }
            }
            return new FLConfig(this);
        }
    }
}

