/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.types;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecord;
import com.innovatrics.mrz.records.FrenchIdCard;
import com.innovatrics.mrz.records.MRP;
import com.innovatrics.mrz.records.MrtdTd1;
import com.innovatrics.mrz.records.MrtdTd2;
import com.innovatrics.mrz.records.MrvA;
import com.innovatrics.mrz.records.MrvB;
import com.innovatrics.mrz.records.SlovakId2x34;

public enum MrzFormat {
    MRTD_TD1(3, 30, MrtdTd1.class),
    FRENCH_ID(2, 36, FrenchIdCard.class){

        @Override
        public boolean isFormatOf(String[] mrzRows) {
            if (!super.isFormatOf(mrzRows)) {
                return false;
            }
            return mrzRows[0].substring(0, 5).equals("IDFRA");
        }
    }
    ,
    MRV_VISA_B(2, 36, MrvB.class){

        @Override
        public boolean isFormatOf(String[] mrzRows) {
            if (!super.isFormatOf(mrzRows)) {
                return false;
            }
            return mrzRows[0].substring(0, 1).equals("V");
        }
    }
    ,
    MRTD_TD2(2, 36, MrtdTd2.class),
    MRV_VISA_A(2, 44, MrvA.class){

        @Override
        public boolean isFormatOf(String[] mrzRows) {
            if (!super.isFormatOf(mrzRows)) {
                return false;
            }
            return mrzRows[0].substring(0, 1).equals("V");
        }
    }
    ,
    PASSPORT(2, 44, MRP.class),
    SLOVAK_ID_234(2, 34, SlovakId2x34.class);

    private final int rows;
    private final int columns;
    private final Class<? extends MrzRecord> recordClass;

    private MrzFormat(int rows, int columns, Class<? extends MrzRecord> recordClass) {
        this.rows = rows;
        this.columns = columns;
        this.recordClass = recordClass;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final Class<? extends MrzRecord> getRecordClass() {
        return this.recordClass;
    }

    public boolean isFormatOf(String[] mrzRows) {
        return this.getRows() == mrzRows.length && this.getColumns() == mrzRows[0].length();
    }

    public static final MrzFormat get(String mrz) throws MrzParseException {
        String[] rows = mrz.split("\n");
        int cols = rows[0].length();
        for (int i = 1; i < rows.length; ++i) {
            if (rows[i].length() == cols) continue;
            throw new MrzParseException("Different row lengths: 0: " + cols + " and " + i + ": " + rows[i].length(), mrz, new MrzRange(0, 0, 0), null);
        }
        for (MrzFormat f : MrzFormat.values()) {
            if (!f.isFormatOf(rows)) continue;
            return f;
        }
        throw new MrzParseException("Unknown format / unsupported number of cols/rows: " + cols + "/" + rows.length, mrz, new MrzRange(0, 0, 0), null);
    }

    public final MrzRecord newRecord() {
        try {
            return this.getRecordClass().newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

