/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.records;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecordOptional;
import com.innovatrics.mrz.types.MrzFormat;

public class MrtdTd1
extends MrzRecordOptional {
    private static final long serialVersionUID = 1L;
    private String optional2;

    public MrtdTd1() {
        super(MrzFormat.MRTD_TD1, "MRTD-TD1");
    }

    @Override
    public void fromMrz(String mrz) throws MrzParseException {
        super.fromMrz(mrz);
        MrzParser parser = new MrzParser(mrz);
        this.setDocumentNumber(parser.parseString(new MrzRange(5, 14, 0)));
        this.setValidDocumentNumber(parser.checkDigit(14, 0, new MrzRange(5, 14, 0), "document number"));
        this.setOptional(parser.parseString(new MrzRange(15, 30, 0)));
        this.setDateOfBirth(parser.parseDate(new MrzRange(0, 6, 1)));
        this.setValidDateOfBirth(parser.checkDigit(6, 1, new MrzRange(0, 6, 1), "date of birth") && this.getDateOfBirth().isDateValid());
        this.setSex(parser.parseSex(7, 1));
        this.setExpirationDate(parser.parseDate(new MrzRange(8, 14, 1)));
        this.setValidExpirationDate(parser.checkDigit(14, 1, new MrzRange(8, 14, 1), "expiration date") && this.getExpirationDate().isDateValid());
        this.setNationality(parser.parseString(new MrzRange(15, 18, 1)));
        this.setOptional2(parser.parseString(new MrzRange(18, 29, 1)));
        this.setValidComposite(parser.checkDigit(29, 1, parser.rawValue(new MrzRange(5, 30, 0), new MrzRange(0, 7, 1), new MrzRange(8, 15, 1), new MrzRange(18, 29, 1)), "mrz"));
        this.setName(parser.parseName(new MrzRange(0, 30, 2)));
    }

    @Override
    public String toMrz() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCode1());
        sb.append(this.getCode2());
        sb.append(MrzParser.toMrz(this.getIssuingCountry(), 3));
        String dno = MrzParser.toMrz(this.getDocumentNumber(), 9) + MrzParser.computeCheckDigitChar(MrzParser.toMrz(this.getDocumentNumber(), 9)) + MrzParser.toMrz(this.getOptional(), 15);
        sb.append(dno);
        sb.append('\n');
        String dob = this.getDateOfBirth().toMrz() + MrzParser.computeCheckDigitChar(this.getDateOfBirth().toMrz());
        sb.append(dob);
        sb.append(this.getSex().getMrz());
        String ed = this.getExpirationDate().toMrz() + MrzParser.computeCheckDigitChar(this.getExpirationDate().toMrz());
        sb.append(ed);
        sb.append(MrzParser.toMrz(this.getNationality(), 3));
        sb.append(MrzParser.toMrz(this.getOptional2(), 11));
        sb.append(MrzParser.computeCheckDigitChar(dno + dob + ed + MrzParser.toMrz(this.getOptional2(), 11)));
        sb.append('\n');
        sb.append(MrzParser.nameToMrz(this.getSurname(), this.getGivenNames(), 30));
        sb.append('\n');
        return sb.toString();
    }

    public String getOptional2() {
        return this.optional2;
    }

    public void setOptional2(String optional2) {
        this.optional2 = optional2;
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        super.buildToString(sb);
        sb.append(", optional2=").append(this.getOptional2());
    }
}

