/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.records;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecord;
import com.innovatrics.mrz.types.MrzFormat;

public class MRP
extends MrzRecord {
    private static final long serialVersionUID = 1L;
    private String personalNumber;
    private boolean validPersonalNumber;

    public MRP() {
        super(MrzFormat.PASSPORT, "MRP");
    }

    @Override
    public void fromMrz(String mrz) throws MrzParseException {
        super.fromMrz(mrz);
        MrzParser parser = new MrzParser(mrz);
        this.setName(parser.parseName(new MrzRange(5, 44, 0)));
        this.setDocumentNumber(parser.parseString(new MrzRange(0, 9, 1)));
        this.setValidDocumentNumber(parser.checkDigit(9, 1, new MrzRange(0, 9, 1), "passport number"));
        this.setNationality(parser.parseString(new MrzRange(10, 13, 1)));
        this.setDateOfBirth(parser.parseDate(new MrzRange(13, 19, 1)));
        this.setValidDateOfBirth(parser.checkDigit(19, 1, new MrzRange(13, 19, 1), "date of birth") && this.getDateOfBirth().isDateValid());
        this.setSex(parser.parseSex(20, 1));
        this.setExpirationDate(parser.parseDate(new MrzRange(21, 27, 1)));
        this.setValidExpirationDate(parser.checkDigit(27, 1, new MrzRange(21, 27, 1), "expiration date") && this.getExpirationDate().isDateValid());
        this.setPersonalNumber(parser.parseString(new MrzRange(28, 42, 1)));
        this.setValidPersonalNumber(parser.checkDigit(42, 1, new MrzRange(28, 42, 1), "personal number"));
        this.setValidComposite(parser.checkDigit(43, 1, parser.rawValue(new MrzRange(0, 10, 1), new MrzRange(13, 20, 1), new MrzRange(21, 43, 1)), "mrz"));
    }

    @Override
    public String toMrz() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCode1());
        sb.append(this.getCode2());
        sb.append(MrzParser.toMrz(this.getIssuingCountry(), 3));
        sb.append(MrzParser.nameToMrz(this.getSurname(), this.getGivenNames(), 39));
        sb.append('\n');
        String docNum = MrzParser.toMrz(this.getDocumentNumber(), 9) + MrzParser.computeCheckDigitChar(MrzParser.toMrz(this.getDocumentNumber(), 9));
        sb.append(docNum);
        sb.append(MrzParser.toMrz(this.getNationality(), 3));
        String dob = this.getDateOfBirth().toMrz() + MrzParser.computeCheckDigitChar(this.getDateOfBirth().toMrz());
        sb.append(dob);
        sb.append(this.getSex().getMrz());
        String edpn = this.getExpirationDate().toMrz() + MrzParser.computeCheckDigitChar(this.getExpirationDate().toMrz()) + MrzParser.toMrz(this.getPersonalNumber(), 14) + MrzParser.computeCheckDigitChar(MrzParser.toMrz(this.getPersonalNumber(), 14));
        sb.append(edpn);
        sb.append(MrzParser.computeCheckDigitChar(docNum + dob + edpn));
        sb.append('\n');
        return sb.toString();
    }

    public String getPersonalNumber() {
        return this.personalNumber;
    }

    public void setPersonalNumber(String personalNumber) {
        this.personalNumber = personalNumber;
    }

    public boolean isValidPersonalNumber() {
        return this.validPersonalNumber;
    }

    protected void setValidPersonalNumber(boolean validPersonalNumber) {
        this.validPersonalNumber = validPersonalNumber;
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        super.buildToString(sb);
        sb.append(", personalNumber=").append(this.getPersonalNumber());
    }
}

