/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.docker;

import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Mount;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DockerContainer {
    private List<String> exposedPorts;
    private String imageId;
    private Optional<List<Bind>> binds;
    private Optional<List<String>> envs;
    private Optional<String> network;
    private Optional<List<String>> cmd;
    private Optional<List<String>> entryPoint;
    private Optional<List<Mount>> mounts;
    private Optional<Long> shmSize;
    private boolean privileged;
    private boolean sysadmin;
    private String containerId;
    private String containerUrl;
    private String gateway;
    private String address;
    private String vncPort;
    private String vncAddress;
    private String sessionId;
    private String browserName;
    private Path recordingPath;

    private DockerContainer(DockerBuilder builder) {
        this.imageId = builder.imageId;
        this.exposedPorts = builder.exposedPorts != null ? builder.exposedPorts : new ArrayList();
        this.binds = builder.binds != null ? Optional.of(builder.binds) : Optional.empty();
        this.envs = builder.envs != null ? Optional.of(builder.envs) : Optional.empty();
        this.network = builder.network != null ? Optional.of(builder.network) : Optional.empty();
        this.cmd = builder.cmd != null ? Optional.of(builder.cmd) : Optional.empty();
        this.entryPoint = builder.entryPoint != null ? Optional.of(builder.entryPoint) : Optional.empty();
        this.mounts = builder.mounts != null ? Optional.of(builder.mounts) : Optional.empty();
        this.privileged = builder.privileged;
        this.sysadmin = builder.sysadmin;
        this.shmSize = builder.shmSize != 0L ? Optional.of(builder.shmSize) : Optional.empty();
    }

    public static DockerBuilder dockerBuilder(String imageId) {
        return new DockerBuilder(imageId);
    }

    public String getImageId() {
        return this.imageId;
    }

    public Optional<List<Bind>> getBinds() {
        return this.binds;
    }

    public Optional<List<String>> getEnvs() {
        return this.envs;
    }

    public List<String> getExposedPorts() {
        return this.exposedPorts;
    }

    public Optional<String> getNetwork() {
        return this.network;
    }

    public Optional<List<String>> getCmd() {
        return this.cmd;
    }

    public Optional<List<String>> getEntryPoint() {
        return this.entryPoint;
    }

    public Optional<List<Mount>> getMounts() {
        return this.mounts;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public void setContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public boolean isSysadmin() {
        return this.sysadmin;
    }

    public Optional<Long> getShmSize() {
        return this.shmSize;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getVncPort() {
        return this.vncPort;
    }

    public void setVncPort(String vncPort) {
        this.vncPort = vncPort;
    }

    public String getVncAddress() {
        return this.vncAddress;
    }

    public void setVncAddress(String vncAddress) {
        this.vncAddress = vncAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public Path getRecordingPath() {
        return this.recordingPath;
    }

    public void setRecordingPath(Path recordingPath) {
        this.recordingPath = recordingPath;
    }

    public static class DockerBuilder {
        private String imageId;
        private List<Bind> binds;
        private List<String> envs;
        private List<String> cmd;
        private String network;
        private List<String> entryPoint;
        private List<Mount> mounts;
        private Long shmSize = 0L;
        private boolean privileged = false;
        private boolean sysadmin = false;
        private List<String> exposedPorts;

        public DockerBuilder(String imageId) {
            this.imageId = imageId;
        }

        public DockerBuilder exposedPorts(List<String> ports) {
            this.exposedPorts = ports;
            return this;
        }

        public DockerBuilder binds(List<String> binds) {
            this.binds = binds.stream().map(Bind::parse).collect(Collectors.toList());
            return this;
        }

        public DockerBuilder envs(List<String> envs) {
            this.envs = envs;
            return this;
        }

        public DockerBuilder network(String network) {
            this.network = network;
            return this;
        }

        public DockerBuilder cmd(List<String> cmd) {
            this.cmd = cmd;
            return this;
        }

        public DockerBuilder entryPoint(List<String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public DockerBuilder mounts(List<Mount> mounts) {
            this.mounts = mounts;
            return this;
        }

        public DockerBuilder shmSize(Long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        public DockerBuilder sysadmin() {
            this.sysadmin = true;
            return this;
        }

        public DockerBuilder privileged() {
            this.privileged = true;
            return this;
        }

        public DockerContainer build() {
            return new DockerContainer(this);
        }
    }
}

