/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.circle;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0004\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleRenderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "cycleColor", "", "(Landroid/graphics/Paint;Z)V", "(Z)V", "mAggresive", "", "mColorCounter", "mCycleColor", "mModulation", "mPaint", "mPoints", "", "calculate", "", "drawArea", "Landroid/graphics/Rect;", "data", "", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "toPolar", "cartesian", "rect", "core_release"})
public final class CircleRenderer
implements IRenderer {
    private double mColorCounter;
    private double mModulation;
    private double mAggresive;
    private float[] mPoints;
    private Paint mPaint;
    private boolean mCycleColor;

    @Override
    public void onStart(int captureSize) {
        this.mPoints = new float[captureSize * 4];
    }

    @Override
    public void onStop() {
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.WAVE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.mCycleColor) {
            this.cycleColor();
        }
        float height = drawArea.height();
        int n = 0;
        int n2 = data.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                float[] cartPoint = new float[]{(float)i / (float)(data.length - 1), height / (float)2 + (float)(data[i] & 0x7F) * (height / (float)2) / (float)128};
                float[] polarPoint = this.toPolar(cartPoint, drawArea);
                if (this.mPoints == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mPoints");
                }
                this.mPoints[i * 4] = polarPoint[0];
                if (this.mPoints == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mPoints");
                }
                this.mPoints[i * 4 + true] = polarPoint[1];
                float[] cartPoint2 = new float[]{(float)(i + true) / (float)(data.length - 1), height / (float)2 + (float)(data[i] & 0x7F) * (height / (float)2) / (float)128};
                float[] polarPoint2 = this.toPolar(cartPoint2, drawArea);
                if (this.mPoints == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mPoints");
                }
                this.mPoints[i * 4 + 2] = polarPoint2[0];
                if (this.mPoints == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mPoints");
                }
                this.mPoints[i * 4 + 3] = polarPoint2[1];
                if (i == n2) break;
                ++i;
            }
        }
        this.mModulation += 0.04;
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.mPoints == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mPoints");
        }
        canvas.drawLines(this.mPoints, this.mPaint);
    }

    private final void cycleColor() {
        int r = (int)Math.floor((double)128 * (Math.sin(this.mColorCounter) + 1.0));
        int g = (int)Math.floor((double)128 * (Math.sin(this.mColorCounter + (double)2) + 1.0));
        int b = (int)Math.floor((double)128 * (Math.sin(this.mColorCounter + (double)4) + 1.0));
        this.mPaint.setColor(Color.argb((int)128, (int)r, (int)g, (int)b));
        this.mColorCounter += 0.03;
    }

    private final float[] toPolar(float[] cartesian, Rect rect) {
        double cX = rect.width() / 2;
        double cY = rect.height() / 2;
        double angle = (double)cartesian[0] * 2.0 * Math.PI;
        double radius = ((double)(rect.width() / 2) * (1.0 - this.mAggresive) + this.mAggresive * (double)cartesian[1] / (double)2) * (1.2 + Math.sin(this.mModulation)) / 2.2;
        return new float[]{(float)(cX + radius * Math.sin(angle)), (float)(cY + radius * Math.cos(angle))};
    }

    public CircleRenderer(@NotNull Paint paint, boolean cycleColor) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.mAggresive = 0.33;
        this.mPaint = paint;
        this.mCycleColor = cycleColor;
    }

    public CircleRenderer(boolean cycleColor) {
        this.mAggresive = 0.33;
        this.mPaint = new Paint(1);
        this.mPaint.setStrokeWidth(10.0f);
        this.mPaint.setColor(-16711681);
        this.mCycleColor = cycleColor;
    }
}

