/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.core;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import me.bogerchan.niervisualizer.core.NierConstants;
import me.bogerchan.niervisualizer.core.NierVisualizerRenderWorker;
import me.bogerchan.niervisualizer.core.NierVisualizerRenderWorker$WhenMappings;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import me.bogerchan.niervisualizer.util.FpsHelper;
import me.bogerchan.niervisualizer.util.KeyFrameMaker;
import me.bogerchan.niervisualizer.util.NierThrottle;
import me.bogerchan.niervisualizer.util.NierUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0012\u0018\u0000 52\u00020\u0001:\u000256B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010%\u001a\u00020\u001aJ\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u000eH\u0002J\u0006\u0010)\u001a\u00020\u001aJ\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0010J\u0006\u0010.\u001a\u00020\u001aJ\u000e\u0010/\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u000e\u00100\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#J\u0014\u00101\u001a\u00020\u001a*\u0002022\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker;", "", "()V", "mDrawArea", "Landroid/graphics/Rect;", "mFftThrottle", "Lme/bogerchan/niervisualizer/util/NierThrottle;", "mFpsHelper", "Lme/bogerchan/niervisualizer/util/FpsHelper;", "getMFpsHelper", "()Lme/bogerchan/niervisualizer/util/FpsHelper;", "mFpsHelper$delegate", "Lkotlin/Lazy;", "mKeyFrameMaker", "Lme/bogerchan/niervisualizer/util/KeyFrameMaker;", "mRenderCore", "Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker$RenderCore;", "mRenderHandler", "me/bogerchan/niervisualizer/core/NierVisualizerRenderWorker$mRenderHandler$2$1", "getMRenderHandler", "()Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker$mRenderHandler$2$1;", "mRenderHandler$delegate", "mState", "Ljava/util/concurrent/atomic/AtomicInteger;", "mWaveThrottle", "pause", "", "processPauseEvent", "processRenderEvent", "processResumeEvent", "processStartEvent", "core", "processStopEvent", "processUpdateFftEvent", "data", "", "processUpdateWaveEvent", "quit", "renderInternal", "renderCore", "frameMaker", "resume", "scheduleNextRender", "awaitTime", "", "start", "stop", "updateFftData", "updateWaveData", "unlockCanvasAndPostSafely", "Landroid/view/SurfaceHolder;", "canvas", "Landroid/graphics/Canvas;", "Companion", "RenderCore", "core_release"})
public final class NierVisualizerRenderWorker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy mRenderHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<mRenderHandler.1>(this){
        final /* synthetic */ NierVisualizerRenderWorker this$0;

        @NotNull
        public final mRenderHandler.1 invoke() {
            HandlerThread ht = new HandlerThread("Nier Render Thread", -8);
            ht.start();
            return new Handler(this, ht, ht.getLooper()){
                final /* synthetic */ mRenderHandler.2 this$0;
                final /* synthetic */ HandlerThread $ht;

                public void handleMessage(@Nullable Message msg) {
                    Integer n;
                    Message message = msg;
                    Integer n2 = n = message != null ? Integer.valueOf(message.what) : null;
                    int n3 = 0;
                    if (n2 != null && n2 == 0) {
                        NierVisualizerRenderWorker.access$processRenderEvent(this.this$0.this$0);
                    } else {
                        Integer n4 = n;
                        n3 = 1;
                        if (n4 != null && n4 == n3) {
                            Object object = msg.obj;
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type me.bogerchan.niervisualizer.core.NierVisualizerRenderWorker.RenderCore");
                            }
                            NierVisualizerRenderWorker.access$processStartEvent(this.this$0.this$0, (RenderCore)object);
                        } else {
                            Integer n5 = n;
                            n3 = 2;
                            if (n5 != null && n5 == n3) {
                                NierVisualizerRenderWorker.access$processStopEvent(this.this$0.this$0);
                            } else {
                                Integer n6 = n;
                                n3 = 3;
                                if (n6 != null && n6 == n3) {
                                    NierVisualizerRenderWorker.access$processPauseEvent(this.this$0.this$0);
                                } else {
                                    Integer n7 = n;
                                    n3 = 4;
                                    if (n7 != null && n7 == n3) {
                                        NierVisualizerRenderWorker.access$processResumeEvent(this.this$0.this$0);
                                    } else {
                                        Integer n8 = n;
                                        n3 = 5;
                                        if (n8 != null && n8 == n3) {
                                            Object object = msg.obj;
                                            if (object == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                                            }
                                            NierVisualizerRenderWorker.access$processUpdateFftEvent(this.this$0.this$0, (byte[])object);
                                        } else {
                                            Integer n9 = n;
                                            n3 = 6;
                                            if (n9 != null && n9 == n3) {
                                                Object object = msg.obj;
                                                if (object == null) {
                                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                                                }
                                                NierVisualizerRenderWorker.access$processUpdateWaveEvent(this.this$0.this$0, (byte[])object);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$ht = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
        }
        {
            this.this$0 = nierVisualizerRenderWorker;
            super(0);
        }
    }));
    private AtomicInteger mState = new AtomicInteger(0);
    private final Lazy mFpsHelper$delegate = LazyKt.lazy((Function0)mFpsHelper.2.INSTANCE);
    private final Rect mDrawArea = new Rect();
    private final KeyFrameMaker mKeyFrameMaker = new KeyFrameMaker();
    private RenderCore mRenderCore;
    private final NierThrottle mFftThrottle = new NierThrottle(150);
    private final NierThrottle mWaveThrottle = new NierThrottle(150);
    @NotNull
    private static final String TAG;
    public static final int MSG_RENDER = 0;
    public static final int MSG_START = 1;
    public static final int MSG_STOP = 2;
    public static final int MSG_PAUSE = 3;
    public static final int MSG_RESUME = 4;
    public static final int MSG_UPDATE_FFT = 5;
    public static final int MSG_UPDATE_WAVE = 6;
    public static final int STATE_INIT = 0;
    public static final int STATE_START = 1;
    public static final int STATE_STOP = 2;
    public static final int STATE_PAUSE = 3;
    public static final int STATE_QUIT = 4;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NierVisualizerRenderWorker.class), "mRenderHandler", "getMRenderHandler()Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker$mRenderHandler$2$1;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NierVisualizerRenderWorker.class), "mFpsHelper", "getMFpsHelper()Lme/bogerchan/niervisualizer/util/FpsHelper;"))};
        Companion = new Companion(null);
        TAG = NierConstants.INSTANCE.tagFor("NierVisualizerRenderWorker");
    }

    private final mRenderHandler.1 getMRenderHandler() {
        Lazy lazy = this.mRenderHandler$delegate;
        NierVisualizerRenderWorker nierVisualizerRenderWorker = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Object)lazy.getValue();
    }

    private final FpsHelper getMFpsHelper() {
        Lazy lazy = this.mFpsHelper$delegate;
        NierVisualizerRenderWorker nierVisualizerRenderWorker = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (FpsHelper)lazy.getValue();
    }

    private final void processStartEvent(RenderCore core) {
        RenderCore renderCore;
        mRenderHandler.1 var2_2;
        if (this.mState.get() != 1) {
            return;
        }
        mRenderHandler.1 $receiver = var2_2 = this.getMRenderHandler();
        $receiver.removeMessages(0);
        RenderCore renderCore2 = core;
        NierVisualizerRenderWorker nierVisualizerRenderWorker = this;
        RenderCore $receiver2 = renderCore2;
        this.mKeyFrameMaker.prepare(core.getCaptureSize());
        IRenderer[] $receiver$iv = $receiver2.getRenderers();
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            IRenderer element$iv;
            IRenderer it = element$iv = $receiver$iv[i];
            it.onStart(core.getCaptureSize());
        }
        nierVisualizerRenderWorker.mRenderCore = renderCore = renderCore2;
        $receiver.sendEmptyMessage(0);
    }

    private final void processStopEvent() {
        block2: {
            RenderCore renderCore;
            if (this.mState.get() != 2) {
                return;
            }
            RenderCore renderCore2 = this.mRenderCore;
            if (renderCore2 == null) break block2;
            RenderCore $receiver = renderCore = renderCore2;
            this.getMRenderHandler().removeMessages(0);
            IRenderer[] $receiver$iv = $receiver.getRenderers();
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                IRenderer element$iv;
                IRenderer it = element$iv = $receiver$iv[i];
                it.onStop();
            }
            this.mRenderCore = null;
        }
    }

    private final void processPauseEvent() {
        RenderCore renderCore = this.mRenderCore;
        if (renderCore != null) {
            RenderCore renderCore2;
            RenderCore $receiver = renderCore2 = renderCore;
            this.getMRenderHandler().removeMessages(0);
            IRenderer[] $receiver$iv = $receiver.getRenderers();
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                IRenderer element$iv;
                IRenderer it = element$iv = $receiver$iv[i];
                it.onStop();
            }
        }
    }

    private final void processResumeEvent() {
        block1: {
            mRenderHandler.1 var3_3;
            RenderCore renderCore;
            RenderCore renderCore2 = this.mRenderCore;
            if (renderCore2 == null) break block1;
            RenderCore $receiver = renderCore = renderCore2;
            mRenderHandler.1 $receiver2 = var3_3 = this.getMRenderHandler();
            $receiver2.removeMessages(0);
            IRenderer[] $receiver$iv = $receiver.getRenderers();
            int n = $receiver$iv.length;
            for (int i = 0; i < n; ++i) {
                IRenderer element$iv;
                IRenderer it = element$iv = $receiver$iv[i];
                it.onStart($receiver.getCaptureSize());
            }
            $receiver2.sendEmptyMessage(0);
        }
    }

    private final void processUpdateFftEvent(byte[] data) {
        this.mKeyFrameMaker.updateFftData(data);
    }

    private final void processUpdateWaveEvent(byte[] data) {
        this.mKeyFrameMaker.updateWaveData(data);
    }

    private final void processRenderEvent() {
        block1: {
            RenderCore renderCore;
            if (this.mState.get() != 1) {
                return;
            }
            RenderCore renderCore2 = this.mRenderCore;
            if (renderCore2 == null) break block1;
            RenderCore $receiver = renderCore = renderCore2;
            this.getMFpsHelper().start();
            this.getMRenderHandler().removeMessages(0);
            this.renderInternal($receiver, this.mKeyFrameMaker);
            this.getMFpsHelper().end();
            this.scheduleNextRender(this.getMFpsHelper().nextDelayTime());
        }
    }

    private final void scheduleNextRender(long awaitTime) {
        boolean ret = this.getMRenderHandler().sendEmptyMessageDelayed(0, awaitTime);
        if (!ret) {
            Log.e((String)NierConstants.INSTANCE.getTAG(), (String)"schedule next render error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void renderInternal(RenderCore renderCore, KeyFrameMaker frameMaker) {
        SurfaceHolder surfaceHolder;
        if (this.mState.get() != 1) {
            return;
        }
        frameMaker.makeKeyFrame();
        SurfaceHolder $receiver = surfaceHolder = renderCore.getSurfaceView().getHolder();
        Canvas canvas = $receiver.lockCanvas();
        if (canvas != null) {
            Canvas canvas2;
            Canvas $receiver2 = canvas2 = canvas;
            try {
                IRenderer it;
                IRenderer element$iv;
                int n;
                this.mDrawArea.set(0, 0, $receiver2.getWidth(), $receiver2.getHeight());
                IRenderer[] $receiver$iv = renderCore.getRenderers();
                int n2 = $receiver$iv.length;
                block7: for (n = 0; n < n2; ++n) {
                    it = element$iv = $receiver$iv[n];
                    switch (NierVisualizerRenderWorker$WhenMappings.$EnumSwitchMapping$0[it.getInputDataType().ordinal()]) {
                        case 1: {
                            it.calculate(this.mDrawArea, frameMaker.getComputedWaveData());
                            continue block7;
                        }
                        case 2: {
                            it.calculate(this.mDrawArea, frameMaker.getComputedFftData());
                        }
                    }
                }
                NierUtilKt.clear($receiver2);
                $receiver$iv = renderCore.getRenderers();
                n2 = $receiver$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $receiver$iv[n];
                    it.render($receiver2);
                }
            }
            finally {
                this.unlockCanvasAndPostSafely($receiver, $receiver2);
            }
        }
    }

    private final void unlockCanvasAndPostSafely(@NotNull SurfaceHolder $receiver, Canvas canvas) {
        try {
            Surface surface = $receiver.getSurface();
            Intrinsics.checkExpressionValueIsNotNull((Object)surface, (String)"surface");
            if (!surface.isValid()) {
                return;
            }
            $receiver.unlockCanvasAndPost(canvas);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"unlockCanvasAndPostSafely, illegal state", (Throwable)e);
        }
    }

    public final void start(@NotNull RenderCore renderCore) {
        Intrinsics.checkParameterIsNotNull((Object)renderCore, (String)"renderCore");
        this.mState.set(1);
        this.getMRenderHandler().removeMessages(1);
        Message.obtain((Handler)this.getMRenderHandler(), (int)1, (Object)renderCore).sendToTarget();
    }

    public final void stop() {
        mRenderHandler.1 var1_1;
        this.mState.set(2);
        mRenderHandler.1 $receiver = var1_1 = this.getMRenderHandler();
        $receiver.removeMessages(2);
        $receiver.sendEmptyMessage(2);
    }

    public final void pause() {
        mRenderHandler.1 var1_1;
        this.mState.set(3);
        mRenderHandler.1 $receiver = var1_1 = this.getMRenderHandler();
        $receiver.removeMessages(3);
        $receiver.sendEmptyMessage(3);
    }

    public final void resume() {
        mRenderHandler.1 var1_1;
        this.mState.set(1);
        mRenderHandler.1 $receiver = var1_1 = this.getMRenderHandler();
        $receiver.removeMessages(4);
        $receiver.sendEmptyMessage(4);
    }

    public final void quit() {
        this.mState.set(4);
        this.getMRenderHandler().getLooper().quit();
    }

    public final void updateFftData(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.mState.get() != 1) {
            return;
        }
        if (!this.mFftThrottle.process()) {
            return;
        }
        Message.obtain((Handler)this.getMRenderHandler(), (int)5, (Object)data).sendToTarget();
    }

    public final void updateWaveData(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.mState.get() != 1) {
            return;
        }
        if (!this.mWaveThrottle.process()) {
            return;
        }
        Message.obtain((Handler)this.getMRenderHandler(), (int)6, (Object)data).sendToTarget();
    }

    public static final /* synthetic */ void access$processRenderEvent(NierVisualizerRenderWorker $this) {
        $this.processRenderEvent();
    }

    public static final /* synthetic */ void access$processStartEvent(NierVisualizerRenderWorker $this, @NotNull RenderCore core) {
        $this.processStartEvent(core);
    }

    public static final /* synthetic */ void access$processStopEvent(NierVisualizerRenderWorker $this) {
        $this.processStopEvent();
    }

    public static final /* synthetic */ void access$processPauseEvent(NierVisualizerRenderWorker $this) {
        $this.processPauseEvent();
    }

    public static final /* synthetic */ void access$processResumeEvent(NierVisualizerRenderWorker $this) {
        $this.processResumeEvent();
    }

    public static final /* synthetic */ void access$processUpdateFftEvent(NierVisualizerRenderWorker $this, @NotNull byte[] data) {
        $this.processUpdateFftEvent(data);
    }

    public static final /* synthetic */ void access$processUpdateWaveEvent(NierVisualizerRenderWorker $this, @NotNull byte[] data) {
        $this.processUpdateWaveEvent(data);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker$RenderCore;", "", "captureSize", "", "surfaceView", "Landroid/view/SurfaceView;", "renderers", "", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "(ILandroid/view/SurfaceView;[Lme/bogerchan/niervisualizer/renderer/IRenderer;)V", "getCaptureSize", "()I", "getRenderers", "()[Lme/bogerchan/niervisualizer/renderer/IRenderer;", "[Lme/bogerchan/niervisualizer/renderer/IRenderer;", "getSurfaceView", "()Landroid/view/SurfaceView;", "core_release"})
    public static final class RenderCore {
        private final int captureSize;
        @NotNull
        private final SurfaceView surfaceView;
        @NotNull
        private final IRenderer[] renderers;

        public final int getCaptureSize() {
            return this.captureSize;
        }

        @NotNull
        public final SurfaceView getSurfaceView() {
            return this.surfaceView;
        }

        @NotNull
        public final IRenderer[] getRenderers() {
            return this.renderers;
        }

        public RenderCore(int captureSize, @NotNull SurfaceView surfaceView, @NotNull IRenderer[] renderers) {
            Intrinsics.checkParameterIsNotNull((Object)surfaceView, (String)"surfaceView");
            Intrinsics.checkParameterIsNotNull((Object)renderers, (String)"renderers");
            this.captureSize = captureSize;
            this.surfaceView = surfaceView;
            this.renderers = renderers;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lme/bogerchan/niervisualizer/core/NierVisualizerRenderWorker$Companion;", "", "()V", "MSG_PAUSE", "", "MSG_RENDER", "MSG_RESUME", "MSG_START", "MSG_STOP", "MSG_UPDATE_FFT", "MSG_UPDATE_WAVE", "STATE_INIT", "STATE_PAUSE", "STATE_QUIT", "STATE_START", "STATE_STOP", "TAG", "", "getTAG", "()Ljava/lang/String;", "core_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

