/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.other;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.animation.LinearInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import me.bogerchan.niervisualizer.util.NierAnimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/bogerchan/niervisualizer/renderer/other/ArcStaticRenderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "amplificationOuter", "", "amplificationInner", "startAngle", "sweepAngle", "animator", "Lme/bogerchan/niervisualizer/util/NierAnimator;", "(Landroid/graphics/Paint;FFFFLme/bogerchan/niervisualizer/util/NierAnimator;)V", "mCenterX", "mCenterY", "mClearPaint", "mDrawArcInnerRadius", "mDrawArcOuterArea", "Landroid/graphics/RectF;", "mLastDrawArea", "Landroid/graphics/Rect;", "calculate", "", "drawArea", "data", "", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "Companion", "core_release"})
public final class ArcStaticRenderer
implements IRenderer {
    private float mCenterX;
    private float mCenterY;
    private final RectF mDrawArcOuterArea;
    private float mDrawArcInnerRadius;
    private final Rect mLastDrawArea;
    private final Paint mClearPaint;
    private final Paint paint;
    private final float amplificationOuter;
    private final float amplificationInner;
    private final float startAngle;
    private final float sweepAngle;
    private final NierAnimator animator;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onStart(int captureSize) {
        this.animator.start();
    }

    @Override
    public void onStop() {
        this.animator.stop();
    }

    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)this.mLastDrawArea, (Object)drawArea)) {
            return;
        }
        this.mLastDrawArea.set(drawArea);
        this.mCenterX = (float)(drawArea.left + drawArea.right) / 2.0f;
        this.mCenterY = (float)(drawArea.top + drawArea.bottom) / 2.0f;
        this.mDrawArcInnerRadius = (float)Math.min(drawArea.width(), drawArea.height()) * 0.27f * this.amplificationInner;
        float outerSize = (float)Math.min(drawArea.width(), drawArea.height()) * 0.77f * this.amplificationOuter;
        this.mDrawArcOuterArea.set(0.0f, 0.0f, outerSize, outerSize);
        this.mDrawArcOuterArea.offsetTo(((float)(drawArea.left + drawArea.right) - outerSize) / (float)2, ((float)(drawArea.top + drawArea.bottom) - outerSize) / (float)2);
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.rotate(this.animator.computeCurrentValue(), this.mCenterX, this.mCenterY);
        canvas.drawArc(this.mDrawArcOuterArea, this.startAngle, this.sweepAngle, true, this.paint);
        canvas.drawCircle(this.mCenterX, this.mCenterY, this.mDrawArcInnerRadius, this.mClearPaint);
        canvas.restore();
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.FFT;
    }

    public ArcStaticRenderer(@NotNull Paint paint, float amplificationOuter, float amplificationInner, float startAngle, float sweepAngle, @NotNull NierAnimator animator) {
        Paint paint2;
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
        this.paint = paint;
        this.amplificationOuter = amplificationOuter;
        this.amplificationInner = amplificationInner;
        this.startAngle = startAngle;
        this.sweepAngle = sweepAngle;
        this.animator = animator;
        this.mDrawArcOuterArea = new RectF();
        this.mLastDrawArea = new Rect();
        Paint paint3 = new Paint(1);
        ArcStaticRenderer arcStaticRenderer = this;
        Paint $receiver = paint3;
        $receiver.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        arcStaticRenderer.mClearPaint = paint2 = paint3;
    }

    public /* synthetic */ ArcStaticRenderer(Paint paint, float f, float f2, float f3, float f4, NierAnimator nierAnimator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            paint = ArcStaticRenderer.Companion.getDefaultPaint();
        }
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            f3 = -135.0f;
        }
        if ((n & 0x10) != 0) {
            f4 = 270.0f;
        }
        if ((n & 0x20) != 0) {
            nierAnimator = ArcStaticRenderer.Companion.getDefaultAnimator();
        }
        this(paint, f, f2, f3, f4, nierAnimator);
    }

    public ArcStaticRenderer() {
        this(null, 0.0f, 0.0f, 0.0f, 0.0f, null, 63, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lme/bogerchan/niervisualizer/renderer/other/ArcStaticRenderer$Companion;", "", "()V", "getDefaultAnimator", "Lme/bogerchan/niervisualizer/util/NierAnimator;", "getDefaultPaint", "Landroid/graphics/Paint;", "core_release"})
    public static final class Companion {
        private final Paint getDefaultPaint() {
            Paint paint;
            Paint $receiver = paint = new Paint(1);
            $receiver.setStrokeWidth(4.0f);
            $receiver.setColor(-16711681);
            return paint;
        }

        private final NierAnimator getDefaultAnimator() {
            return new NierAnimator((TimeInterpolator)new LinearInterpolator(), 20000, new float[]{0.0f, 360.0f}, false, 8, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

