/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.util;

import android.animation.TimeInterpolator;
import android.os.SystemClock;
import android.view.animation.LinearInterpolator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0006\u0010'\u001a\u00020%J\u0006\u0010(\u001a\u00020%R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lme/bogerchan/niervisualizer/util/NierAnimator;", "", "interpolator", "Landroid/animation/TimeInterpolator;", "duration", "", "values", "", "repeatable", "", "(Landroid/animation/TimeInterpolator;I[FZ)V", "getDuration", "()I", "setDuration", "(I)V", "hasValueUpdated", "getHasValueUpdated", "()Z", "setHasValueUpdated", "(Z)V", "getInterpolator", "()Landroid/animation/TimeInterpolator;", "setInterpolator", "(Landroid/animation/TimeInterpolator;)V", "isRunning", "mFraction", "", "mFractionDuration", "mLastRecordTime", "", "getRepeatable", "getValues", "()[F", "setValues", "([F)V", "computeCurrentValue", "pause", "", "reset", "start", "stop", "core_release"})
public final class NierAnimator {
    private float mFraction;
    private long mLastRecordTime;
    private boolean isRunning;
    private float mFractionDuration;
    private boolean hasValueUpdated;
    @NotNull
    private TimeInterpolator interpolator;
    private int duration;
    @NotNull
    private float[] values;
    private final boolean repeatable;

    public final boolean getHasValueUpdated() {
        return this.hasValueUpdated;
    }

    public final void setHasValueUpdated(boolean bl) {
        this.hasValueUpdated = bl;
    }

    public final void start() {
        this.mLastRecordTime = SystemClock.elapsedRealtime();
        this.isRunning = true;
        this.mFractionDuration = (float)this.duration / (float)(this.values.length - 1);
    }

    public final void stop() {
        this.mFraction = 0.0f;
        this.isRunning = false;
    }

    public final void pause() {
        this.isRunning = false;
    }

    public final void reset() {
        this.mLastRecordTime = SystemClock.elapsedRealtime();
        this.isRunning = true;
    }

    public final float computeCurrentValue() {
        if (!this.isRunning) {
            this.hasValueUpdated = false;
            return this.mFraction;
        }
        this.hasValueUpdated = true;
        long curTime = SystemClock.elapsedRealtime();
        long interval = curTime - this.mLastRecordTime;
        if (!this.repeatable && interval >= (long)this.duration) {
            this.mFraction = ArraysKt.last((float[])this.values);
            this.isRunning = false;
            return this.mFraction;
        }
        int curIdx = (int)((float)(interval % (long)this.duration) / this.mFractionDuration);
        this.mFraction = (float)interval % this.mFractionDuration / this.mFractionDuration;
        this.mFraction = this.interpolator.getInterpolation(this.mFraction);
        this.mFraction = this.values[curIdx] + (this.values[curIdx + 1] - this.values[curIdx]) * this.mFraction;
        return this.mFraction;
    }

    @NotNull
    public final TimeInterpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@NotNull TimeInterpolator timeInterpolator) {
        Intrinsics.checkParameterIsNotNull((Object)timeInterpolator, (String)"<set-?>");
        this.interpolator = timeInterpolator;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int n) {
        this.duration = n;
    }

    @NotNull
    public final float[] getValues() {
        return this.values;
    }

    public final void setValues(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"<set-?>");
        this.values = fArray;
    }

    public final boolean getRepeatable() {
        return this.repeatable;
    }

    public NierAnimator(@NotNull TimeInterpolator interpolator, int duration, @NotNull float[] values, boolean repeatable) {
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        this.interpolator = interpolator;
        this.duration = duration;
        this.values = values;
        this.repeatable = repeatable;
    }

    public /* synthetic */ NierAnimator(TimeInterpolator timeInterpolator, int n, float[] fArray, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            timeInterpolator = (TimeInterpolator)new LinearInterpolator();
        }
        if ((n2 & 2) != 0) {
            n = 2000;
        }
        if ((n2 & 4) != 0) {
            fArray = new float[]{1.0f};
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(timeInterpolator, n, fArray, bl);
    }

    public NierAnimator() {
        this(null, 0, null, false, 15, null);
    }
}

