/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.columnar;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006%"}, d2={"Lme/bogerchan/niervisualizer/renderer/columnar/ColumnarType1Renderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "(Landroid/graphics/Paint;)V", "()V", "mGapRatio", "", "mHalfHeight", "mLastDrawArea", "Landroid/graphics/Rect;", "mPaint", "mRadius", "mRenderColumns", "", "Landroid/graphics/RectF;", "[Landroid/graphics/RectF;", "calculate", "", "drawArea", "data", "", "calculateRenderData", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "transformWaveValue", "value", "", "rectF", "updateWave", "core_release"})
public final class ColumnarType1Renderer
implements IRenderer {
    private final Paint mPaint;
    private final Rect mLastDrawArea;
    private RectF[] mRenderColumns;
    private final float mGapRatio = 0.7f;
    private final float mRadius = 10.0f;
    private float mHalfHeight;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onStart(int captureSize) {
        void var3_4;
        RectF[] rectFArray;
        void size$iv;
        int n = Math.min(40, captureSize);
        ColumnarType1Renderer columnarType1Renderer = this;
        RectF[] result$iv = new RectF[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            RectF rectF;
            void i$iv;
            void var6_7 = i$iv;
            void var11_9 = i$iv++;
            rectFArray = result$iv;
            rectFArray[var11_9] = rectF = new RectF(0.0f, -5.0f, 0.0f, 5.0f);
        }
        rectFArray = var3_4;
        columnarType1Renderer.mRenderColumns = rectFArray;
        this.mLastDrawArea.set(0, 0, 0, 0);
    }

    @Override
    public void onStop() {
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.WAVE;
    }

    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)drawArea, (Object)this.mLastDrawArea) ^ true) {
            this.calculateRenderData(drawArea);
            this.mLastDrawArea.set(drawArea);
        }
        this.updateWave(data);
    }

    private final void transformWaveValue(byte value, RectF rectF) {
        rectF.bottom = ((float)(value & 0xFF) - 128.0f) / 128.0f * this.mHalfHeight;
        rectF.bottom = rectF.bottom == 0.0f ? 5.0f : rectF.bottom;
        rectF.top = -rectF.bottom;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateWave(byte[] data) {
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        if (((Object[])this.mRenderColumns).length >= data.length) {
            byte[] $receiver$iv = data;
            int index$iv = 0;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                void byteVal;
                byte item$iv = $receiver$iv[i];
                int n = index$iv++;
                byte by = item$iv;
                int index = n;
                if (this.mRenderColumns == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
                }
                this.transformWaveValue((byte)byteVal, this.mRenderColumns[index]);
            }
        } else {
            int n = data.length;
            if (this.mRenderColumns == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
            }
            int step = n / ((Object[])this.mRenderColumns).length;
            if (this.mRenderColumns == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
            }
            Object[] $receiver$iv = this.mRenderColumns;
            int index$iv = 0;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                void rectF;
                Object item$iv = $receiver$iv[i];
                int n2 = index$iv++;
                RectF index = (RectF)item$iv;
                int index2 = n2;
                this.transformWaveValue(data[index2 * step], (RectF)rectF);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRenderData(Rect drawArea) {
        this.mHalfHeight = (float)drawArea.height() / 3.0f;
        float f = drawArea.width();
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        float perGap = f / ((float)((Object[])this.mRenderColumns).length * (this.mGapRatio + 1.0f) + 1.0f);
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        Object[] $receiver$iv = this.mRenderColumns;
        int index$iv = 0;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            void rect;
            Object item$iv = $receiver$iv[i];
            int n = index$iv++;
            RectF rectF = (RectF)item$iv;
            int index = n;
            rect.left = ((float)(index + 1) * (1.0f + this.mGapRatio) - this.mGapRatio) * perGap;
            rect.right = rect.left + this.mGapRatio * perGap;
        }
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.translate((float)this.mLastDrawArea.left, (float)(this.mLastDrawArea.top + this.mLastDrawArea.bottom) / 2.0f);
        if (this.mRenderColumns == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mRenderColumns");
        }
        Object[] $receiver$iv = this.mRenderColumns;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            RectF it = (RectF)element$iv;
            canvas.drawRoundRect(it, this.mRadius, this.mRadius, this.mPaint);
        }
        canvas.restore();
    }

    public ColumnarType1Renderer(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.mLastDrawArea = new Rect();
        this.mGapRatio = 0.7f;
        this.mRadius = 10.0f;
        this.mPaint = paint;
    }

    public ColumnarType1Renderer() {
        this.mLastDrawArea = new Rect();
        this.mGapRatio = 0.7f;
        this.mRadius = 10.0f;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16711681);
    }
}

