/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.circle;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u0006\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleBarRenderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "divisions", "", "cycleColor", "", "(Landroid/graphics/Paint;IZ)V", "(IZ)V", "mAggresive", "", "mAngleModulation", "mColorCounter", "", "mCycleColor", "mDivisions", "mFFTPoints", "", "mModulation", "mModulationStrength", "mPaint", "calculate", "", "drawArea", "Landroid/graphics/Rect;", "data", "", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "toPolar", "cartesian", "rect", "core_release"})
public final class CircleBarRenderer
implements IRenderer {
    private final Paint mPaint;
    private double mColorCounter;
    private float mAggresive;
    private double mModulation;
    private float mModulationStrength;
    private float mAngleModulation;
    private float[] mFFTPoints;
    private int mDivisions;
    private boolean mCycleColor;

    @Override
    public void onStart(int captureSize) {
        this.mFFTPoints = new float[captureSize * 4];
    }

    @Override
    public void onStop() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (this.mCycleColor) {
            this.cycleColor();
        }
        int drawHeight = drawArea.height();
        int n = 0;
        int n2 = data.length / this.mDivisions;
        while (n < n2) {
            void i;
            byte rfk = data[this.mDivisions * i];
            byte ifk = data[this.mDivisions * i + 1];
            float magnitude = rfk * rfk + ifk * ifk;
            float dbValue = (float)75 * (float)Math.log10(magnitude);
            float[] cartPoint = new float[]{(float)(i * this.mDivisions) / (float)(data.length - 1), (float)(drawHeight / 2) - dbValue / (float)4};
            float[] polarPoint = this.toPolar(cartPoint, drawArea);
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4] = polarPoint[0];
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4 + true] = polarPoint[1];
            float[] cartPoint2 = new float[]{(float)(i * this.mDivisions) / (float)(data.length - 1), (float)(drawHeight / 2) + dbValue};
            float[] polarPoint2 = this.toPolar(cartPoint2, drawArea);
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4 + 2] = polarPoint2[0];
            if (this.mFFTPoints == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
            }
            this.mFFTPoints[i * 4 + 3] = polarPoint2[1];
            ++i;
        }
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.mFFTPoints == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFFTPoints");
        }
        canvas.drawLines(this.mFFTPoints, this.mPaint);
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.FFT;
    }

    private final void cycleColor() {
        int r = (int)Math.floor((double)128 * (Math.sin(this.mColorCounter) + 1.0));
        int g = (int)Math.floor((double)128 * (Math.sin(this.mColorCounter + (double)2) + 1.0));
        int b = (int)Math.floor((double)128 * (Math.sin(this.mColorCounter + (double)4) + 1.0));
        this.mPaint.setColor(Color.argb((int)128, (int)r, (int)g, (int)b));
        this.mColorCounter += 0.03;
    }

    private final float[] toPolar(float[] cartesian, Rect rect) {
        double cX = rect.width() / 2;
        double cY = rect.height() / 2;
        double angle = (double)cartesian[0] * 2.0 * Math.PI;
        double radius = (double)((float)(rect.width() / 2) * (1.0f - this.mAggresive) + this.mAggresive * cartesian[1] / (float)2) * ((double)(1.0f - this.mModulationStrength) + (double)this.mModulationStrength * (1.0 + Math.sin(this.mModulation)) / (double)2);
        return new float[]{(float)(cX + radius * Math.sin(angle + (double)this.mAngleModulation)), (float)(cY + radius * Math.cos(angle + (double)this.mAngleModulation))};
    }

    public CircleBarRenderer(@NotNull Paint paint, int divisions, boolean cycleColor) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.mAggresive = 0.4f;
        this.mModulationStrength = 0.4f;
        this.mPaint = paint;
        this.mDivisions = divisions;
        this.mCycleColor = cycleColor;
    }

    public CircleBarRenderer(int divisions, boolean cycleColor) {
        this.mAggresive = 0.4f;
        this.mModulationStrength = 0.4f;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-16711681);
        this.mPaint.setStrokeWidth(10.0f);
        this.mDivisions = divisions;
        this.mCycleColor = cycleColor;
    }
}

