/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

final class OutputInterpolator
implements UnaryOperator<String> {
    private static final Pattern PATTERN = Pattern.compile("%output%|%output\\|jsstring%");
    private static final String TYPE_OUTPUT = "%output%";
    private static final String TYPE_OUTPUT_JSSTRING = "%output|jsstring%";
    private static final Token TOKEN_OUTPUT = new TokenOutput();
    private static final Token TOKEN_OUTPUT_JSSTRING = new TokenOutputJsstring();
    private final String pattern;
    private final List<Token> tokens;

    private OutputInterpolator(String pattern) {
        this.pattern = pattern;
        this.tokens = OutputInterpolator.parse(pattern);
    }

    @Override
    public String apply(String source) {
        return this.tokens.stream().map(token -> (String)token.apply(source)).collect(Collectors.joining());
    }

    public static OutputInterpolator forIdentity() {
        return new OutputInterpolator(TYPE_OUTPUT);
    }

    public static OutputInterpolator forPattern(String pattern) {
        return new OutputInterpolator(pattern);
    }

    public String toString() {
        return String.format("OutputInterpolator[%s]", this.pattern);
    }

    private static List<Token> parse(String pattern) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int pos = 0;
        int outputCount = 0;
        Matcher m = PATTERN.matcher(pattern);
        while (m.find()) {
            String type;
            if (pos < m.start()) {
                tokens.add(new TokenLiteral(pattern.substring(pos, m.start())));
            }
            if ((type = pattern.substring(m.start(), m.end())).equals(TYPE_OUTPUT)) {
                ++outputCount;
                tokens.add(TOKEN_OUTPUT);
            } else if (type.equals(TYPE_OUTPUT_JSSTRING)) {
                ++outputCount;
                tokens.add(TOKEN_OUTPUT_JSSTRING);
            } else {
                throw new RuntimeException("Unknown token type: " + type);
            }
            pos = m.end();
        }
        if (pos < pattern.length()) {
            tokens.add(new TokenLiteral(pattern.substring(pos)));
        }
        if (outputCount > 1) {
            throw new IllegalArgumentException("Invalid pattern, must contain at most one [%output%] or [%output|jsstring%].");
        }
        return tokens;
    }

    public String getWrapperPrefix() {
        if (this.tokens.isEmpty()) {
            return "";
        }
        int index = -1;
        int j = this.tokens.size();
        for (int i = 0; i < j; ++i) {
            if (!TOKEN_OUTPUT.equals(this.tokens.get(i)) && !TOKEN_OUTPUT_JSSTRING.equals(this.tokens.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            index = this.tokens.size() - 1;
        }
        if (index == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.tokens.stream().limit(index).map(Token::toSource).forEach(sb::append);
        return sb.toString();
    }

    private static class TokenLiteral
    implements Token {
        private final String text;

        public TokenLiteral(String text) {
            this.text = text;
        }

        @Override
        public String apply(String source) {
            return this.text;
        }

        public int hashCode() {
            return Objects.hashCode(this.text);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TokenLiteral)) {
                return false;
            }
            TokenLiteral other = (TokenLiteral)obj;
            return Objects.equals(this.text, other.text);
        }

        @Override
        public String toSource() {
            return this.text;
        }
    }

    private static interface Token
    extends UnaryOperator<String> {
        public String toSource();
    }

    private static final class TokenOutput
    implements Token {
        @Override
        public String apply(String source) {
            return source;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof TokenOutput;
        }

        @Override
        public String toSource() {
            return OutputInterpolator.TYPE_OUTPUT;
        }
    }

    private static final class TokenOutputJsstring
    implements Token {
        @Override
        public String apply(String source) {
            return StringEscapeUtils.escapeEcmaScript((String)source);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof TokenOutputJsstring;
        }

        @Override
        public String toSource() {
            return OutputInterpolator.TYPE_OUTPUT_JSSTRING;
        }
    }
}

