/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.plugin;

import com.github.blutorange.maven.plugin.closurecompiler.common.Aggregation;
import com.github.blutorange.maven.plugin.closurecompiler.common.AggregationConfiguration;
import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.DependencyModeFlag;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileProcessConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileSpecifier;
import com.github.blutorange.maven.plugin.closurecompiler.common.LogLevel;
import com.github.blutorange.maven.plugin.closurecompiler.common.LogWrapper;
import com.github.blutorange.maven.plugin.closurecompiler.common.MojoMetaImpl;
import com.github.blutorange.maven.plugin.closurecompiler.common.SourceMapOutputType;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.ClosureSourceMapLocationMapping;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.FileSet;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.ProcessFilesTask;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.ProcessJSFilesTask;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.SkipMode;
import com.google.gson.Gson;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.deps.ModuleLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="minify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=false)
public class MinifyMojo
extends AbstractMojo {
    @Parameter(property="allowReplacingInputFiles", defaultValue="false")
    private boolean allowReplacingInputFiles;
    @Parameter(property="baseSourceDir", defaultValue="${basedir}/src/main/webapp")
    private File baseSourceDir;
    @Parameter(property="baseTargetDir", defaultValue="${project.build.directory}/${project.build.finalName}")
    private File baseTargetDir;
    @Parameter(property="bufferSize", defaultValue="4096")
    private int bufferSize;
    @Component
    private BuildContext buildContext;
    @Parameter(property="bundleConfiguration", defaultValue="")
    private String bundleConfiguration;
    @Parameter(property="closureAngularPass", defaultValue="false")
    private boolean closureAngularPass;
    @Parameter(property="closureAssumeFunctionWrapper", defaultValue="false")
    private boolean closureAssumeFunctionWrapper;
    @Parameter(property="closureColorizeErrorOutput", defaultValue="true")
    private boolean closureColorizeErrorOutput;
    @Parameter(property="closureCompilationLevel", defaultValue="SIMPLE_OPTIMIZATIONS")
    private CompilationLevel closureCompilationLevel;
    @Parameter(property="closureCreateSourceMap", defaultValue="false")
    private boolean closureCreateSourceMap;
    @Parameter(property="closureDartPass", defaultValue="false")
    private boolean closureDartPass;
    @Parameter(property="closureDebug", defaultValue="false")
    private boolean closureDebug;
    @Parameter(property="closureDefineReplacements")
    private HashMap<String, String> closureDefineReplacements;
    @Parameter(property="closureDependencyEntryPoints")
    private ArrayList<String> closureDependencyEntryPoints;
    @Parameter(property="closureDependencyMode", defaultValue="NONE")
    private DependencyModeFlag closureDependencyMode;
    @Parameter(property="closureEmitUseStrict", defaultValue="true")
    private boolean closureEmitUseStrict;
    @Parameter(property="closureEnvironment", defaultValue="BROWSER")
    private CompilerOptions.Environment closureEnvironment;
    @Parameter(property="closureExternDeclarations")
    private ArrayList<FileSet> closureExternDeclarations;
    @Deprecated
    @Parameter(property="closureExterns")
    private ArrayList<String> closureExterns;
    @Parameter(property="closureExtraAnnotations")
    private ArrayList<String> closureExtraAnnotations;
    @Parameter(property="closureForceInjectLibs")
    private ArrayList<String> closureForceInjectLibs;
    @Parameter(property="closureIncludeSourcesContent", defaultValue="false")
    private boolean closureIncludeSourcesContent;
    @Parameter(property="closureSourceMapLocationMappings")
    private ArrayList<ClosureSourceMapLocationMapping> closureSourceMapLocationMappings;
    @Parameter(property="closureInjectLibraries", defaultValue="true")
    private boolean closureInjectLibraries;
    @Parameter(property="closureLanguageIn", defaultValue="ECMASCRIPT_2020")
    private CompilerOptions.LanguageMode closureLanguageIn;
    @Parameter(property="closureLanguageOut", defaultValue="ECMASCRIPT_2015")
    private CompilerOptions.LanguageMode closureLanguageOut;
    @Parameter(property="closureModuleResolution", defaultValue="BROWSER")
    private ModuleLoader.ResolutionMode closureModuleResolution;
    @Parameter(property="closureJsModuleRoots", defaultValue="")
    private ArrayList<String> closureJsModuleRoots;
    @Parameter(property="closureOutputWrapper", defaultValue="")
    private String closureOutputWrapper;
    @Parameter(property="closurePreferSingleQuotes", defaultValue="false")
    private boolean closurePreferSingleQuotes;
    @Parameter(property="closurePrettyPrint", defaultValue="false")
    private boolean closurePrettyPrint;
    @Parameter(property="closureProcessClosurePrimitives", defaultValue="true")
    private boolean closureProcessClosurePrimitives;
    @Parameter(property="closureProcessCommonJsModules", defaultValue="false")
    private boolean closureProcessCommonJsModules;
    @Parameter(property="closureRenamePrefixNamespace", defaultValue="")
    private String closureRenamePrefixNamespace;
    @Parameter(property="closureRenameVariablePrefix", defaultValue="")
    private String closureRenameVariablePrefix;
    @Parameter(property="closureRewritePolyfills", defaultValue="true")
    private boolean closureRewritePolyfills;
    @Parameter(property="closureSourceMapName", defaultValue="#{filename}.map")
    private String closureSourceMapName;
    @Parameter(property="closureSourceMapOutputType", defaultValue="reference")
    private SourceMapOutputType closureSourceMapOutputType;
    @Parameter(property="closureStrictModeInput", defaultValue="true")
    private boolean closureStrictModeInput;
    @Parameter(property="closureTrustedStrings", defaultValue="true")
    private boolean closureTrustedStrings;
    @Parameter(property="closureUseTypesForOptimization", defaultValue="false")
    private boolean closureUseTypesForOptimization;
    @Parameter(property="closureWarningLevel", defaultValue="DEFAULT")
    private WarningLevel closureWarningLevel;
    @Parameter(property="closureWarningLevels")
    private HashMap<String, String> closureWarningLevels;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}", alias="charset")
    private String encoding;
    @Parameter(property="excludes")
    private ArrayList<String> excludes;
    @Parameter(property="force", defaultValue="false")
    private boolean force;
    @Parameter(property="includes")
    private ArrayList<String> includes;
    @Parameter(property="lineSeparator", defaultValue="")
    private String lineSeparator;
    @Parameter(property="logLevel", defaultValue="")
    private LogLevel logLevel;
    private Log logWrapper;
    @Parameter(property="outputFilename", defaultValue="#{path}/#{basename}.min.#{extension}")
    private String outputFilename;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="skipMode", defaultValue="NEWER")
    private SkipMode skipMode;
    @Parameter(property="skipMerge", defaultValue="false")
    private boolean skipMerge;
    @Parameter(property="skipMinify", defaultValue="false")
    private boolean skipMinify;
    @Parameter(property="skipRunOnIncremental", defaultValue="false")
    private boolean skipRunOnIncremental;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="sourceDir", defaultValue="js")
    private String sourceDir;
    @Parameter(property="targetDir", defaultValue="js")
    private String targetDir;

    private ProcessFilesTask createJSTask(ClosureConfig closureConfig, List<String> includes, List<String> excludes, String outputFilename) throws IOException {
        FileProcessConfig processConfig = new FileProcessConfig(this.lineSeparator, this.bufferSize, this.force, this.skipMerge, this.skipMinify, this.skipMode, this.allowReplacingInputFiles);
        FileSpecifier fileSpecifier = new FileSpecifier(this.baseSourceDir, this.baseTargetDir, this.sourceDir, this.targetDir, includes, excludes, outputFilename);
        MojoMetaImpl mojoMeta = new MojoMetaImpl(this.project, this.getLog(), this.encoding, this.buildContext);
        return new ProcessJSFilesTask(mojoMeta, processConfig, fileSpecifier, closureConfig);
    }

    private Collection<ProcessFilesTask> createTasks(ClosureConfig closureConfig) throws MojoFailureException, IOException {
        ArrayList<ProcessFilesTask> tasks = new ArrayList<ProcessFilesTask>();
        if (StringUtils.isNotBlank((CharSequence)this.bundleConfiguration)) {
            for (Aggregation aggregation : this.getAggregations()) {
                tasks.add(this.createJSTask(closureConfig, aggregation.getIncludes(), aggregation.getExcludes(), aggregation.getName()));
            }
        } else {
            tasks.add(this.createJSTask(closureConfig, this.includes, this.excludes, this.outputFilename));
        }
        return tasks;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection<ProcessFilesTask> processFilesTasks;
        if (this.skip) {
            this.getLog().info((CharSequence)"skip was to true, so skipping plugin execution.");
            return;
        }
        if (this.getBuildContext().isIncremental() && this.skipRunOnIncremental) {
            this.getLog().info((CharSequence)"skipRunOnIncremental was to true, so skipping incremental build.");
            return;
        }
        if (this.skipMerge && this.skipMinify) {
            this.getLog().warn((CharSequence)"Both merge and minify steps are configured to be skipped. Files will only be copied to their destination without any processing");
        }
        this.fillOptionalValues();
        ClosureConfig closureConfig = new ClosureConfig(this);
        try {
            processFilesTasks = this.createTasks(closureConfig);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        try {
            for (ProcessFilesTask task : processFilesTasks) {
                task.call();
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof MojoFailureException) {
                throw (MojoFailureException)e.getCause();
            }
            if (e.getCause() instanceof MojoExecutionException) {
                throw (MojoExecutionException)e.getCause();
            }
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void fillOptionalValues() {
        if (StringUtils.isBlank((CharSequence)this.targetDir)) {
            this.targetDir = this.sourceDir;
        }
        if (StringUtils.isBlank((CharSequence)this.encoding)) {
            this.encoding = Charset.defaultCharset().name();
        }
        this.lineSeparator = StringUtils.isBlank((CharSequence)this.lineSeparator) ? System.lineSeparator() : StringEscapeUtils.unescapeJava((String)this.lineSeparator);
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        if (this.includes == null) {
            this.includes = new ArrayList();
        }
        if (this.closureJsModuleRoots == null) {
            this.closureJsModuleRoots = new ArrayList();
        }
        if (this.closureExtraAnnotations == null) {
            this.closureExtraAnnotations = new ArrayList();
        }
        if (this.closureExterns == null) {
            this.closureExterns = new ArrayList();
        }
        if (this.closureExternDeclarations == null) {
            this.closureExternDeclarations = new ArrayList();
        }
        if (this.closureDependencyEntryPoints == null) {
            this.closureDependencyEntryPoints = new ArrayList();
        }
        if (this.closureForceInjectLibs == null) {
            this.closureForceInjectLibs = new ArrayList();
        }
        if (this.closureWarningLevels == null) {
            this.closureWarningLevels = new HashMap();
        }
        if (this.closureDefineReplacements == null) {
            this.closureDefineReplacements = new HashMap();
        }
        if (this.closureSourceMapLocationMappings == null) {
            this.closureSourceMapLocationMappings = new ArrayList();
        }
    }

    private Collection<Aggregation> getAggregations() throws MojoFailureException {
        AggregationConfiguration aggregationConfiguration;
        if (StringUtils.isBlank((CharSequence)this.bundleConfiguration)) {
            return Collections.emptySet();
        }
        try (FileReader bundleConfigurationReader = new FileReader(FileHelper.getAbsoluteFile(this.project.getBasedir(), this.bundleConfiguration));){
            aggregationConfiguration = (AggregationConfiguration)new Gson().fromJson((Reader)bundleConfigurationReader, AggregationConfiguration.class);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to open the bundle configuration file [" + this.bundleConfiguration + "].", (Throwable)e);
        }
        return CollectionUtils.emptyIfNull(aggregationConfiguration.getBundles());
    }

    public File getBaseSourceDir() {
        return this.baseSourceDir;
    }

    public File getBaseTargetDir() {
        return this.baseTargetDir;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public String getBundleConfiguration() {
        return this.bundleConfiguration;
    }

    public CompilationLevel getClosureCompilationLevel() {
        return this.closureCompilationLevel;
    }

    public HashMap<String, String> getClosureDefineReplacements() {
        return this.closureDefineReplacements;
    }

    public ArrayList<String> getClosureDependencyEntryPoints() {
        return this.closureDependencyEntryPoints;
    }

    public DependencyModeFlag getClosureDependencyMode() {
        return this.closureDependencyMode;
    }

    public CompilerOptions.Environment getClosureEnvironment() {
        return this.closureEnvironment;
    }

    public ArrayList<FileSet> getClosureExternDeclarations() {
        return this.closureExternDeclarations;
    }

    public ArrayList<String> getClosureExterns() {
        return this.closureExterns;
    }

    public ArrayList<String> getClosureExtraAnnotations() {
        return this.closureExtraAnnotations;
    }

    public ArrayList<String> getClosureForceInjectLibs() {
        return this.closureForceInjectLibs;
    }

    public ArrayList<String> getClosureJsModuleRoots() {
        return this.closureJsModuleRoots;
    }

    public CompilerOptions.LanguageMode getClosureLanguageIn() {
        return this.closureLanguageIn;
    }

    public CompilerOptions.LanguageMode getClosureLanguageOut() {
        return this.closureLanguageOut;
    }

    public ModuleLoader.ResolutionMode getClosureModuleResolution() {
        return this.closureModuleResolution;
    }

    public String getClosureOutputWrapper() {
        return this.closureOutputWrapper;
    }

    public String getClosureRenamePrefixNamespace() {
        return this.closureRenamePrefixNamespace;
    }

    public String getClosureRenameVariablePrefix() {
        return this.closureRenameVariablePrefix;
    }

    public ArrayList<ClosureSourceMapLocationMapping> getClosureSourceMapLocationMappings() {
        return this.closureSourceMapLocationMappings;
    }

    public String getClosureSourceMapName() {
        return this.closureSourceMapName;
    }

    public SourceMapOutputType getClosureSourceMapOutputType() {
        return this.closureSourceMapOutputType;
    }

    public WarningLevel getClosureWarningLevel() {
        return this.closureWarningLevel;
    }

    public HashMap<String, String> getClosureWarningLevels() {
        return this.closureWarningLevels;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ArrayList<String> getExcludes() {
        return this.excludes;
    }

    public ArrayList<String> getIncludes() {
        return this.includes;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Log getLog() {
        if (this.logWrapper == null) {
            this.logWrapper = new LogWrapper(super.getLog(), this.logLevel);
        }
        return this.logWrapper;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public Log getLogWrapper() {
        return this.logWrapper;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public SkipMode getSkipMode() {
        return this.skipMode;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public boolean isAllowReplacingInputFiles() {
        return this.allowReplacingInputFiles;
    }

    public boolean isClosureAngularPass() {
        return this.closureAngularPass;
    }

    public boolean isClosureAssumeFunctionWrapper() {
        return this.closureAssumeFunctionWrapper;
    }

    public boolean isClosureColorizeErrorOutput() {
        return this.closureColorizeErrorOutput;
    }

    public boolean isClosureCreateSourceMap() {
        return this.closureCreateSourceMap;
    }

    public boolean isClosureDartPass() {
        return this.closureDartPass;
    }

    public boolean isClosureDebug() {
        return this.closureDebug;
    }

    public boolean isClosureEmitUseStrict() {
        return this.closureEmitUseStrict;
    }

    public boolean isClosureIncludeSourcesContent() {
        return this.closureIncludeSourcesContent;
    }

    public boolean isClosureInjectLibraries() {
        return this.closureInjectLibraries;
    }

    public boolean isClosurePreferSingleQuotes() {
        return this.closurePreferSingleQuotes;
    }

    public boolean isClosurePrettyPrint() {
        return this.closurePrettyPrint;
    }

    public boolean isClosureProcessClosurePrimitives() {
        return this.closureProcessClosurePrimitives;
    }

    public boolean isClosureProcessCommonJsModules() {
        return this.closureProcessCommonJsModules;
    }

    public boolean isClosureRewritePolyfills() {
        return this.closureRewritePolyfills;
    }

    public boolean isClosureStrictModeInput() {
        return this.closureStrictModeInput;
    }

    public boolean isClosureTrustedStrings() {
        return this.closureTrustedStrings;
    }

    public boolean isClosureUseTypesForOptimization() {
        return this.closureUseTypesForOptimization;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isSkipMerge() {
        return this.skipMerge;
    }

    public boolean isSkipMinify() {
        return this.skipMinify;
    }

    public boolean isSkipRunOnIncremental() {
        return this.skipRunOnIncremental;
    }

    public void setAllowReplacingInputFiles(boolean allowReplacingInputFiles) {
        this.allowReplacingInputFiles = allowReplacingInputFiles;
    }

    public void setBaseSourceDir(File baseSourceDir) {
        this.baseSourceDir = baseSourceDir;
    }

    public void setBaseTargetDir(File baseTargetDir) {
        this.baseTargetDir = baseTargetDir;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void setBundleConfiguration(String bundleConfiguration) {
        this.bundleConfiguration = bundleConfiguration;
    }

    public void setClosureAngularPass(boolean closureAngularPass) {
        this.closureAngularPass = closureAngularPass;
    }

    public void setClosureAssumeFunctionWrapper(boolean closureAssumeFunctionWrapper) {
        this.closureAssumeFunctionWrapper = closureAssumeFunctionWrapper;
    }

    public void setClosureColorizeErrorOutput(boolean closureColorizeErrorOutput) {
        this.closureColorizeErrorOutput = closureColorizeErrorOutput;
    }

    public void setClosureCompilationLevel(CompilationLevel closureCompilationLevel) {
        this.closureCompilationLevel = closureCompilationLevel;
    }

    public void setClosureCreateSourceMap(boolean closureCreateSourceMap) {
        this.closureCreateSourceMap = closureCreateSourceMap;
    }

    public void setClosureDartPass(boolean closureDartPass) {
        this.closureDartPass = closureDartPass;
    }

    public void setClosureDebug(boolean closureDebug) {
        this.closureDebug = closureDebug;
    }

    public void setClosureDefineReplacements(HashMap<String, String> closureDefineReplacements) {
        this.closureDefineReplacements = closureDefineReplacements;
    }

    public void setClosureDependencyEntryPoints(ArrayList<String> closureDependencyEntryPoints) {
        this.closureDependencyEntryPoints = closureDependencyEntryPoints;
    }

    public void setClosureDependencyMode(DependencyModeFlag closureDependencyMode) {
        this.closureDependencyMode = closureDependencyMode;
    }

    public void setClosureEmitUseStrict(boolean closureEmitUseStrict) {
        this.closureEmitUseStrict = closureEmitUseStrict;
    }

    public void setClosureEnvironment(CompilerOptions.Environment closureEnvironment) {
        this.closureEnvironment = closureEnvironment;
    }

    public void setClosureExternDeclarations(ArrayList<FileSet> closureExternDeclarations) {
        this.closureExternDeclarations = closureExternDeclarations;
    }

    public void setClosureExterns(ArrayList<String> closureExterns) {
        this.closureExterns = closureExterns;
    }

    public void setClosureExtraAnnotations(ArrayList<String> closureExtraAnnotations) {
        this.closureExtraAnnotations = closureExtraAnnotations;
    }

    public void setClosureForceInjectLibs(ArrayList<String> closureForceInjectLibs) {
        this.closureForceInjectLibs = closureForceInjectLibs;
    }

    public void setClosureIncludeSourcesContent(boolean closureIncludeSourcesContent) {
        this.closureIncludeSourcesContent = closureIncludeSourcesContent;
    }

    public void setClosureInjectLibraries(boolean closureInjectLibraries) {
        this.closureInjectLibraries = closureInjectLibraries;
    }

    public void setClosureJsModuleRoots(ArrayList<String> closureJsModuleRoots) {
        this.closureJsModuleRoots = closureJsModuleRoots;
    }

    public void setClosureLanguageIn(CompilerOptions.LanguageMode closureLanguageIn) {
        this.closureLanguageIn = closureLanguageIn;
    }

    public void setClosureLanguageOut(CompilerOptions.LanguageMode closureLanguageOut) {
        this.closureLanguageOut = closureLanguageOut;
    }

    public void setClosureModuleResolution(ModuleLoader.ResolutionMode closureModuleResolution) {
        this.closureModuleResolution = closureModuleResolution;
    }

    public void setClosureOutputWrapper(String closureOutputWrapper) {
        this.closureOutputWrapper = closureOutputWrapper;
    }

    public void setClosurePreferSingleQuotes(boolean closurePreferSingleQuotes) {
        this.closurePreferSingleQuotes = closurePreferSingleQuotes;
    }

    public void setClosurePrettyPrint(boolean closurePrettyPrint) {
        this.closurePrettyPrint = closurePrettyPrint;
    }

    public void setClosureProcessClosurePrimitives(boolean closureProcessClosurePrimitives) {
        this.closureProcessClosurePrimitives = closureProcessClosurePrimitives;
    }

    public void setClosureProcessCommonJsModules(boolean closureProcessCommonJsModules) {
        this.closureProcessCommonJsModules = closureProcessCommonJsModules;
    }

    public void setClosureRenamePrefixNamespace(String closureRenamePrefixNamespace) {
        this.closureRenamePrefixNamespace = closureRenamePrefixNamespace;
    }

    public void setClosureRenameVariablePrefix(String closureRenameVariablePrefix) {
        this.closureRenameVariablePrefix = closureRenameVariablePrefix;
    }

    public void setClosureRewritePolyfills(boolean closureRewritePolyfills) {
        this.closureRewritePolyfills = closureRewritePolyfills;
    }

    public void setClosureSourceMapLocationMappings(ArrayList<ClosureSourceMapLocationMapping> closureSourceMapLocationMappings) {
        this.closureSourceMapLocationMappings = closureSourceMapLocationMappings;
    }

    public void setClosureSourceMapName(String closureSourceMapName) {
        this.closureSourceMapName = closureSourceMapName;
    }

    public void setClosureSourceMapOutputType(SourceMapOutputType closureSourceMapOutputType) {
        this.closureSourceMapOutputType = closureSourceMapOutputType;
    }

    public void setClosureStrictModeInput(boolean closureStrictModeInput) {
        this.closureStrictModeInput = closureStrictModeInput;
    }

    public void setClosureTrustedStrings(boolean closureTrustedStrings) {
        this.closureTrustedStrings = closureTrustedStrings;
    }

    public void setClosureUseTypesForOptimization(boolean closureUseTypesForOptimization) {
        this.closureUseTypesForOptimization = closureUseTypesForOptimization;
    }

    public void setClosureWarningLevel(WarningLevel closureWarningLevel) {
        this.closureWarningLevel = closureWarningLevel;
    }

    public void setClosureWarningLevels(HashMap<String, String> closureWarningLevels) {
        this.closureWarningLevels = closureWarningLevels;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludes(ArrayList<String> excludes) {
        this.excludes = excludes;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setIncludes(ArrayList<String> includes) {
        this.includes = includes;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogWrapper(Log logWrapper) {
        this.logWrapper = logWrapper;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSkipMode(SkipMode skipMode) {
        this.skipMode = skipMode;
    }

    public void setSkipMerge(boolean skipMerge) {
        this.skipMerge = skipMerge;
    }

    public void setSkipMinify(boolean skipMinify) {
        this.skipMinify = skipMinify;
    }

    public void setSkipRunOnIncremental(boolean skipRunOnIncremental) {
        this.skipRunOnIncremental = skipRunOnIncremental;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }
}

