/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.qa.util.services;

import de.sstoehr.harreader.model.HarContent;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarHeader;
import de.sstoehr.harreader.model.HarPostData;
import de.sstoehr.harreader.model.HarPostDataParam;
import de.sstoehr.harreader.model.HarRequest;
import de.sstoehr.harreader.model.HarResponse;
import de.sstoehr.harreader.model.HarTiming;
import de.sstoehr.harreader.model.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class HarEntryConverter {
    private HttpRequest httpRequest;
    private HttpResponse httpResponse;
    private final HarEntry harEntry = new HarEntry();
    private final long time;

    public HarEntryConverter(HttpRequest httpRequest, HttpResponse httpResponse, long time) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.time = time;
    }

    public void setup() {
        this.harEntry.setRequest(this.convertHarRequest());
        this.harEntry.setStartedDateTime(new Date(this.time));
        this.harEntry.setTime(Integer.valueOf((int)this.time));
        this.harEntry.setRequest(this.convertHarRequest());
        this.harEntry.setResponse(this.convertHarResponse());
        this.harEntry.setTimings(this.convertHarTiming());
        this.harEntry.setPageref("Page");
    }

    public HarTiming convertHarTiming() {
        HarTiming harTiming = new HarTiming();
        harTiming.setBlocked(Integer.valueOf(0));
        harTiming.setDns(Integer.valueOf(0));
        harTiming.setConnect(Integer.valueOf(0));
        harTiming.setSend(Integer.valueOf(0));
        harTiming.setWait(Integer.valueOf(0));
        harTiming.setReceive(Integer.valueOf(0));
        return harTiming;
    }

    private HarResponse convertHarResponse() {
        HarResponse harResponse = new HarResponse();
        harResponse.setStatus(this.httpResponse.getStatus());
        harResponse.setStatusText(this.httpResponse.isSuccessful() ? "OK" : "FAILED");
        harResponse.setHttpVersion("HTTP/1.1");
        harResponse.setRedirectURL("");
        harResponse.setHeaders(this.convertHarHeadersResponse());
        harResponse.setContent(this.setHarContentResponse());
        return harResponse;
    }

    private String convertInputStreamtoString(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int read;
            while ((read = inputStream.read()) != -1) {
                stringBuilder.append((char)read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private HarContent setHarContentResponse() {
        HarContent harContent = new HarContent();
        try {
            harContent.setSize(Long.valueOf(((InputStream)this.httpResponse.getContent().get()).available()));
        }
        catch (IOException e) {
            e.printStackTrace();
            harContent.setSize(Long.valueOf(0L));
        }
        harContent.setText(this.convertInputStreamtoString((InputStream)this.httpResponse.getContent().get()));
        harContent.setMimeType(Optional.ofNullable(this.httpResponse.getHeader("Content-Type")).orElse("").equals("") ? "application/x-www-form-urlencoded" : this.httpResponse.getHeader("Content-Type"));
        return harContent;
    }

    private List<HarHeader> convertHarHeadersResponse() {
        ArrayList<HarHeader> harHeaders = new ArrayList<HarHeader>();
        this.httpResponse.getHeaderNames().forEach(s -> {
            HarHeader harHeader = new HarHeader();
            harHeader.setName(s);
            harHeader.setValue(this.httpResponse.getHeader(s));
            harHeaders.add(harHeader);
        });
        return harHeaders;
    }

    public HarRequest convertHarRequest() {
        HarRequest harRequest = new HarRequest();
        harRequest.setMethod(HttpMethod.valueOf((String)this.httpRequest.getMethod().toString()));
        harRequest.setUrl(this.httpRequest.getUri());
        harRequest.setComment("");
        harRequest.setHttpVersion("HTTP/1.1");
        try {
            harRequest.setBodySize(Long.valueOf(((InputStream)this.httpRequest.getContent().get()).available()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HarPostData harPostData = new HarPostData();
        harPostData.setText(this.convertInputStreamtoString((InputStream)this.httpRequest.getContent().get()));
        ArrayList harPostDataParams = new ArrayList();
        this.httpRequest.getQueryParameterNames().forEach(s -> {
            HarPostDataParam harPostDataParam = new HarPostDataParam();
            harPostDataParam.setName(s);
            harPostDataParam.setValue(this.httpRequest.getQueryParameter(s));
            harPostDataParams.add(harPostDataParam);
        });
        harPostData.setParams(harPostDataParams);
        harPostData.setMimeType(Optional.ofNullable(this.httpRequest.getHeader("Content-Type")).orElse("").equalsIgnoreCase("") ? "application/x-www-form-urlencoded" : this.httpRequest.getHeader("Content-Type"));
        harRequest.setPostData(harPostData);
        return harRequest;
    }

    public HarEntry getHarEntry() {
        return this.harEntry;
    }
}

