/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.util;

import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import net.infordata.em.util.XICommand;

public class XICommandMgr {
    private static final Logger LOGGER = Logger.getLogger(XICommandMgr.class.getName());
    private Map<String, XICommand> ivActCmd2Cmd = new HashMap<String, XICommand>();
    private List<String> ivDisabledActCmd = new ArrayList<String>();
    private Map<Object, String> ivObj2ActCmd = new HashMap<Object, String>();
    private Map<String, Boolean> ivActCmd2Value = new HashMap<String, Boolean>();
    private Object ivActCmdLock = new Object();
    private ActionListener ivActionListener = this::actionPerformed;
    private ItemListener ivItemListener = e -> this.actionPerformed(new ActionEvent(e.getSource(), 1001, null));

    public ActionListener getActionListener() {
        return this.ivActionListener;
    }

    private void actionPerformed(ActionEvent e) {
        String actCmd;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("" + e);
        }
        if ((actCmd = this.ivObj2ActCmd.get(e.getSource())) == null) {
            actCmd = e.getActionCommand();
        }
        if (actCmd != null) {
            this.dispatchCommand(e.getSource(), actCmd);
        }
    }

    public void dispatchCommand(String cmd) {
        this.dispatchCommand(null, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchCommand(Object cmp, String cmd) {
        boolean flag;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("dispatchCommand " + cmp + " " + cmd);
        }
        Object object = this.ivActCmdLock;
        synchronized (object) {
            boolean enabled;
            boolean flagCmp;
            boolean flagCmd = this.getCommandState(cmd);
            boolean bl = flagCmp = !flagCmd;
            if (cmp instanceof CheckboxMenuItem) {
                flagCmp = ((CheckboxMenuItem)cmp).getState();
            }
            flag = (enabled = this.isCommandEnabled(cmd)) ? flagCmp : flagCmd;
        }
        this.setCommandState(cmd, flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandState(String cmd, boolean value) {
        boolean oldCmdState;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setCommandState " + cmd + " " + value);
        }
        Object object = this.ivActCmdLock;
        synchronized (object) {
            oldCmdState = this.getCommandState(cmd);
            this.ivActCmd2Value.put(cmd, new Boolean(value));
            for (Object obj : this.ivObj2ActCmd.keySet()) {
                if (!cmd.equals(this.ivObj2ActCmd.get(obj))) continue;
                if (obj instanceof AbstractButton && ((AbstractButton)obj).isSelected() != value) {
                    ((AbstractButton)obj).setSelected(value);
                    continue;
                }
                if (!(obj instanceof CheckboxMenuItem) || ((CheckboxMenuItem)obj).getState() == value) continue;
                ((CheckboxMenuItem)obj).setState(value);
            }
        }
        if (value != oldCmdState) {
            this.processCommand(cmd);
        }
    }

    public boolean getCommandState(String cmd) {
        Boolean app = this.ivActCmd2Value.get(cmd);
        return app != null ? app : false;
    }

    protected void processCommand(String anActCmd) {
        XICommand command;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("processActionCommand " + anActCmd);
        }
        if ((command = this.getCommand(anActCmd)) != null) {
            command.execute();
        }
    }

    private void handleActionCommand(Object obj, String anActionCommand) {
        if (obj == null) {
            throw new IllegalArgumentException("anObj can't be null");
        }
        if (anActionCommand != null) {
            this.ivObj2ActCmd.put(obj, anActionCommand);
            this.setCommandState(anActionCommand, this.getCommandState(anActionCommand));
        } else {
            this.ivObj2ActCmd.remove(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(MenuItem aMenuItem, String anActionCommand) {
        Object object = this.ivActCmdLock;
        synchronized (object) {
            this.handleActionCommand(aMenuItem, anActionCommand);
            aMenuItem.setActionCommand(anActionCommand);
            if (anActionCommand != null) {
                aMenuItem.addActionListener(this.ivActionListener);
                aMenuItem.setEnabled(this.isCommandEnabled(anActionCommand));
            } else {
                aMenuItem.removeActionListener(this.ivActionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(CheckboxMenuItem aMenuItem, String anActionCommand) {
        Object object = this.ivActCmdLock;
        synchronized (object) {
            this.handleActionCommand(aMenuItem, anActionCommand);
            aMenuItem.setActionCommand(anActionCommand);
            if (anActionCommand != null) {
                aMenuItem.addItemListener(this.ivItemListener);
                aMenuItem.setEnabled(this.isCommandEnabled(anActionCommand));
            } else {
                aMenuItem.removeItemListener(this.ivItemListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(Button aButton, String anActionCommand) {
        Object object = this.ivActCmdLock;
        synchronized (object) {
            this.handleActionCommand(aButton, anActionCommand);
            aButton.setActionCommand(anActionCommand);
            if (anActionCommand != null) {
                aButton.addActionListener(this.ivActionListener);
                aButton.setEnabled(this.isCommandEnabled(anActionCommand));
            } else {
                aButton.removeActionListener(this.ivActionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(AbstractButton aButton, String anActionCommand) {
        Object object = this.ivActCmdLock;
        synchronized (object) {
            this.handleActionCommand(aButton, anActionCommand);
            aButton.setActionCommand(anActionCommand);
            if (anActionCommand != null) {
                aButton.addActionListener(this.ivActionListener);
                aButton.setEnabled(this.isCommandEnabled(anActionCommand));
            } else {
                aButton.removeActionListener(this.ivActionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCommand(String anActionCommand, boolean toBeEnabled) {
        if (anActionCommand == null) {
            throw new IllegalArgumentException("The ActionCommand can't be null.");
        }
        Object object = this.ivActCmdLock;
        synchronized (object) {
            if (toBeEnabled == this.isCommandEnabled(anActionCommand)) {
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(anActionCommand + " " + (toBeEnabled ? "enabled" : "disabled"));
            }
            if (toBeEnabled) {
                this.ivDisabledActCmd.remove(anActionCommand);
            } else {
                this.ivDisabledActCmd.add(anActionCommand);
            }
            for (Object obj : this.ivObj2ActCmd.keySet()) {
                if (!anActionCommand.equals(this.ivObj2ActCmd.get(obj))) continue;
                if (obj instanceof MenuItem) {
                    ((MenuItem)obj).setEnabled(toBeEnabled);
                    continue;
                }
                if (obj instanceof Button) {
                    ((Button)obj).setEnabled(toBeEnabled);
                    continue;
                }
                if (obj instanceof AbstractButton) {
                    ((AbstractButton)obj).setEnabled(toBeEnabled);
                    continue;
                }
                throw new IllegalStateException("An invalid class type was found.");
            }
        }
    }

    public final boolean isCommandEnabled(String anActionCommand) {
        return !this.ivDisabledActCmd.contains(anActionCommand);
    }

    public void setCommand(String anActionCommand, XICommand aCommand) {
        if (anActionCommand == null) {
            throw new IllegalArgumentException("The ActionCommand can't be null.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(aCommand + " -> " + anActionCommand);
        }
        this.ivActCmd2Cmd.put(anActionCommand, aCommand);
    }

    public XICommand getCommand(String anActionCommand) {
        return this.ivActCmd2Cmd.get(anActionCommand);
    }
}

