/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250ext;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.infordata.em.tn5250.XI5250EmulatorAdapter;
import net.infordata.em.tn5250.XI5250EmulatorEvent;
import net.infordata.em.tn5250ext.XI5250EmulatorExt;
import net.infordata.em.tn5250ext.XI5250PanelHandler;

public abstract class XI5250PanelsDispatcher {
    protected static final Logger LOGGER = Logger.getLogger(XI5250PanelsDispatcher.class.getName());
    private transient XI5250EmulatorExt ivEm;
    private transient EmulatorAdapter ivEmulatorAdapter;
    private transient XI5250PanelHandler ivPanelHndl;
    private transient HashMap<Object, Object> ivSharedData;

    public XI5250PanelsDispatcher() {
    }

    public XI5250PanelsDispatcher(XI5250EmulatorExt aEmulator) {
        this.setEmulator(aEmulator);
    }

    public synchronized void setEmulator(XI5250EmulatorExt aEmulator) {
        if (this.ivEm == aEmulator) {
            return;
        }
        if (this.ivEm != null) {
            this.setPanelHndl(null);
            this.ivEm.removeEmulatorListener(this.ivEmulatorAdapter);
            this.ivEm.removeDispatcher(this);
        }
        this.ivEmulatorAdapter = null;
        this.ivEm = aEmulator;
        if (this.ivEm != null) {
            this.ivEm.addDispatcher(this);
            this.ivEmulatorAdapter = new EmulatorAdapter();
            this.ivEm.addEmulatorListener(this.ivEmulatorAdapter);
        }
    }

    public final XI5250EmulatorExt getEmulator() {
        return this.ivEm;
    }

    public final Object getTreeLock() {
        return this.ivEm.getTreeLock();
    }

    public abstract void addPanelHandler(XI5250PanelHandler var1);

    public abstract void removePanelHandler(XI5250PanelHandler var1);

    protected abstract XI5250PanelHandler getCurrentPanelHandler();

    public final Map<Object, Object> getSharedData() {
        if (this.ivSharedData == null) {
            this.ivSharedData = new HashMap();
        }
        return this.ivSharedData;
    }

    protected synchronized void newPanelReceived() {
        XI5250PanelHandler panelHndl;
        if ((this.ivEm.getState() == 2 || this.ivEm.getState() == 5) && (panelHndl = this.getCurrentPanelHandler()) != null) {
            this.setPanelHndl(panelHndl);
        }
    }

    private void fieldsRemoved() {
        this.setPanelHndl(null);
    }

    private void dataSended(byte anAidCode) {
        if (this.ivPanelHndl != null) {
            this.ivPanelHndl.dataSended(anAidCode);
        }
    }

    protected void setPanelHndl(XI5250PanelHandler aPanelHndl) {
        if (aPanelHndl == this.ivPanelHndl) {
            return;
        }
        if (this.ivPanelHndl != null) {
            this.ivPanelHndl.stopInternal();
        }
        this.ivPanelHndl = aPanelHndl;
        if (this.ivPanelHndl != null) {
            this.ivPanelHndl.startInternal();
        }
    }

    protected XI5250PanelHandler getCurrentPanelHndl() {
        return this.ivPanelHndl;
    }

    class EmulatorAdapter
    extends XI5250EmulatorAdapter {
        EmulatorAdapter() {
        }

        @Override
        public void stateChanged(XI5250EmulatorEvent e) {
        }

        @Override
        public void disconnected(XI5250EmulatorEvent e) {
            XI5250PanelsDispatcher.this.fieldsRemoved();
        }

        @Override
        public void newPanelReceived(XI5250EmulatorEvent e) {
            XI5250PanelsDispatcher.this.newPanelReceived();
        }

        @Override
        public void fieldsRemoved(XI5250EmulatorEvent e) {
            XI5250PanelsDispatcher.this.fieldsRemoved();
        }

        @Override
        public void dataSended(XI5250EmulatorEvent e) {
            XI5250PanelsDispatcher.this.dataSended(e.getAidCode());
        }
    }
}

