/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import net.infordata.em.crt5250.XI5250CrtAdapter;
import net.infordata.em.crt5250.XI5250CrtEvent;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.tn5250ext.XI5250EmulatorExt;
import net.infordata.em.tn5250ext.XI5250FieldConnection;
import net.infordata.em.tn5250ext.XI5250PanelConnection;
import net.infordata.em.tn5250ext.XI5250PanelsDispatcher;
import net.infordata.em.tn5250ext.XIHint;
import net.infordata.em.tn5250ext.XIHintWindow;

public abstract class XI5250PanelHandler {
    private String ivTitle;
    private transient XI5250PanelsDispatcher ivDispatcher;
    private transient HashMap<XI5250Field, XI5250FieldConnection> ivConnections;
    private transient HashMap<Component, XI5250PanelConnection> ivPanelConnections;
    private transient int ivInvalidateCount;
    private transient CrtAdapter ivCrtAdapter;
    private transient HashMap<XI5250Field, XIHint> ivHints;
    private transient XIHintWindow ivHintWindow;
    private transient Timer ivHintTimer;
    private transient int ivHintDelay = 1000;
    private transient XIHint ivLastHint;
    private transient HintThread ivHintThread;
    private transient HashMap<XI5250Field, JPopupMenu> ivPopupMenus;
    private transient ArrayList<JPopupMenu> ivPopupList;
    private transient MouseListener ivMouseListener;
    private transient ComponentListener ivHintListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent aEvent) {
            ((XIHintWindow)aEvent.getSource()).removeComponentListener(XI5250PanelHandler.this.ivHintListener);
            XI5250PanelHandler.this.hideHint();
        }
    };

    public XI5250PanelHandler(XI5250PanelsDispatcher aPanelDisp) {
        this(aPanelDisp, null);
    }

    public XI5250PanelHandler(XI5250PanelsDispatcher aPanelDisp, String aPanelTitle) {
        this.ivDispatcher = aPanelDisp;
        this.ivTitle = aPanelTitle;
        this.ivDispatcher.addPanelHandler(this);
    }

    public final XI5250EmulatorExt getEmulator() {
        return this.ivDispatcher.getEmulator();
    }

    public Map<Object, Object> getSharedData() {
        return this.ivDispatcher.getSharedData();
    }

    public String getTitle() {
        return this.ivTitle;
    }

    public static Window getWindow(Component aComp) {
        Component comp;
        for (comp = aComp; comp != null && !(comp instanceof Window); comp = comp.getParent()) {
        }
        return (Window)comp;
    }

    public final boolean panelMatched() {
        return this.detailedTest();
    }

    protected abstract boolean detailedTest();

    protected abstract void start();

    protected abstract void stop();

    protected void dataSended(byte anAidCode) {
    }

    final void startInternal() {
        XI5250EmulatorExt em = this.getEmulator();
        this.ivCrtAdapter = new CrtAdapter();
        em.addCrtListener(this.ivCrtAdapter);
        this.ivMouseListener = new EmulatorMouseListener();
        em.addMouseListener(this.ivMouseListener);
        this.start();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stopInternal() {
        block15: {
            try {
                this.stop();
                if (this.ivHintThread == null) break block15;
            }
            catch (Throwable throwable) {
                if (this.ivHintThread != null) {
                    this.ivHintThread.interrupt();
                    this.ivHintThread = null;
                }
                this.hideHint();
                this.ivHints = null;
                XI5250EmulatorExt em = this.getEmulator();
                em.removeMouseListener(this.ivMouseListener);
                em.removeCrtListener(this.ivCrtAdapter);
                if (this.ivPanelConnections != null) {
                    for (Object c : this.ivPanelConnections.values()) {
                        em.remove(((XI5250PanelConnection)c).getComponent());
                    }
                    this.ivPanelConnections = null;
                }
                if (this.ivConnections != null) {
                    for (Object c : this.ivConnections.values()) {
                        em.remove(((XI5250FieldConnection)c).getComponent());
                    }
                    this.ivConnections = null;
                }
                if (this.ivPopupList != null) {
                    for (Object c : this.ivPopupList) {
                        em.remove((Component)c);
                    }
                    this.ivPopupMenus = null;
                    this.ivPopupList = null;
                }
                throw throwable;
            }
            this.ivHintThread.interrupt();
            this.ivHintThread = null;
        }
        this.hideHint();
        this.ivHints = null;
        XI5250EmulatorExt em = this.getEmulator();
        em.removeMouseListener(this.ivMouseListener);
        em.removeCrtListener(this.ivCrtAdapter);
        if (this.ivPanelConnections != null) {
            for (XI5250PanelConnection xI5250PanelConnection : this.ivPanelConnections.values()) {
                em.remove(xI5250PanelConnection.getComponent());
            }
            this.ivPanelConnections = null;
        }
        if (this.ivConnections != null) {
            for (XI5250FieldConnection xI5250FieldConnection : this.ivConnections.values()) {
                em.remove(xI5250FieldConnection.getComponent());
            }
            this.ivConnections = null;
        }
        if (this.ivPopupList != null) {
            for (JPopupMenu jPopupMenu : this.ivPopupList) {
                em.remove(jPopupMenu);
            }
            this.ivPopupMenus = null;
            this.ivPopupList = null;
        }
    }

    void connect(XI5250Field aField, XI5250FieldConnection aConnection) {
        XI5250FieldConnection c;
        XI5250EmulatorExt em = this.getEmulator();
        if (this.ivConnections == null) {
            this.ivConnections = new HashMap();
        }
        if ((c = this.ivConnections.put(aField, aConnection)) != null) {
            em.remove(c.getComponent());
        }
        em.add(aConnection.getComponent());
        this.invalidate();
    }

    void connect(XI5250PanelConnection aConnection) {
        XI5250PanelConnection c;
        XI5250EmulatorExt em = this.getEmulator();
        if (this.ivPanelConnections == null) {
            this.ivPanelConnections = new HashMap();
        }
        if ((c = this.ivPanelConnections.put(aConnection.getComponent(), aConnection)) == null) {
            em.add(aConnection.getComponent());
        }
        this.invalidate();
    }

    public void invalidate() {
        ++this.ivInvalidateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (this.ivInvalidateCount <= 0) {
            return;
        }
        this.ivInvalidateCount = 0;
        XI5250EmulatorExt em = this.getEmulator();
        Object object = em.getTreeLock();
        synchronized (object) {
            if (this.ivPanelConnections != null) {
                for (XI5250PanelConnection conn : this.ivPanelConnections.values()) {
                    conn.recalcBounds(em);
                }
            }
            if (this.ivConnections != null) {
                for (XI5250Field fld : this.ivConnections.keySet()) {
                    XI5250FieldConnection conn = this.ivConnections.get(fld);
                    conn.recalcBounds(em, fld);
                }
            }
        }
    }

    protected void fieldActivated(XI5250Field aField) {
    }

    protected void fieldDeactivated(XI5250Field aField) {
    }

    protected void sizeChanged() {
        this.invalidate();
        this.validate();
        this.hideHint();
    }

    protected void keyEvent(KeyEvent e) {
    }

    protected void refreshHint() {
        XIHint hint;
        if (!this.getEmulator().hasFocus()) {
            this.hideHint();
        }
        XI5250Field field = !this.getEmulator().getShowHints() ? null : (this.getEmulator().isHintOnActiveField() ? this.getEmulator().getCurrentField() : this.getEmulator().getFieldUnderMouse());
        XIHint xIHint = hint = field == null || this.ivHints == null ? null : this.ivHints.get(field);
        if (hint == this.ivLastHint) {
            return;
        }
        if (hint != null) {
            this.showHint(hint, field);
        } else {
            this.hideHint();
        }
        this.ivLastHint = hint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showHint(XIHint aHint, XI5250Field aField) {
        Object object = this.ivDispatcher.getTreeLock();
        synchronized (object) {
            this.hideHint();
            if (!this.getEmulator().getShowHints()) {
                return;
            }
            this.ivHintWindow = new XIHintWindow(aHint, this.getEmulator());
        }
        int delay = this.ivHintDelay;
        if (this.getEmulator().isHintOnActiveField()) {
            delay /= 2;
        }
        this.ivHintTimer = new Timer(delay, new HintTimer(aField));
        this.ivHintTimer.setRepeats(false);
        this.ivHintTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideHint() {
        Object object = this.ivDispatcher.getTreeLock();
        synchronized (object) {
            this.ivLastHint = null;
            if (this.ivHintTimer != null) {
                this.ivHintTimer.stop();
                this.ivHintTimer = null;
            }
            if (this.ivHintWindow != null) {
                this.ivHintWindow.setVisible(false);
                this.ivHintWindow = null;
            }
        }
    }

    protected void mouseEntersField(XI5250Field aField) {
    }

    protected void mouseExitsField(XI5250Field aField) {
    }

    public void setFieldHint(XI5250Field aField, XIHint aHint) {
        if (aField == null) {
            return;
        }
        if (this.ivHints == null) {
            this.ivHints = new HashMap();
        }
        if (aHint == null) {
            this.ivHints.remove(aField);
        } else {
            this.ivHints.put(aField, aHint);
        }
        if (!this.ivHints.isEmpty()) {
            if (this.ivHintThread == null) {
                this.ivHintThread = new HintThread();
                this.ivHintThread.setPriority(4);
                this.ivHintThread.start();
            }
        } else if (this.ivHintThread != null) {
            this.ivHintThread.interrupt();
            this.ivHintThread = null;
        }
    }

    public void setFieldPopupMenu(XI5250Field aField, JPopupMenu aPopupMenu) {
        if (aField == null) {
            return;
        }
        if (this.ivPopupMenus == null) {
            this.ivPopupMenus = new HashMap();
        }
        if (this.ivPopupList == null) {
            this.ivPopupList = new ArrayList(10);
        }
        if (aPopupMenu == null) {
            this.ivPopupMenus.remove(aField);
        } else {
            this.ivPopupMenus.put(aField, aPopupMenu);
        }
        if (!this.ivPopupList.contains(aPopupMenu)) {
            this.ivPopupList.add(aPopupMenu);
            this.getEmulator().add(aPopupMenu);
        }
    }

    protected void mousePressed(MouseEvent e) {
    }

    protected void mouseReleased(MouseEvent e) {
        JPopupMenu pop;
        XI5250Field fld = this.getEmulator().getFieldUnderMouse();
        if (fld != null && this.ivPopupMenus != null && e.isPopupTrigger() && (pop = this.ivPopupMenus.get(fld)) != null) {
            pop.show(this.getEmulator(), e.getX(), e.getY());
        }
    }

    public String getString(int col, int row, int nChars) {
        return this.getEmulator().getString(col, row, nChars);
    }

    public final List<XI5250Field> getFields() {
        return this.getEmulator().getFields();
    }

    public final XI5250Field getFieldFromPos(int aCol, int aRow) {
        return this.getEmulator().getFieldFromPos(aCol, aRow);
    }

    public final XI5250Field getFieldNextTo(String aLabel) {
        return this.getEmulator().getFieldNextTo(aLabel);
    }

    public final boolean isLabelPresent(String aLabel) {
        return this.getEmulator().getLabelLinearPos(aLabel) >= 0;
    }

    public boolean checkField(XI5250Field aField, int aLen) {
        return aField != null && !aField.isOrgBypassField() && aField.getLength() == aLen;
    }

    class HintThread
    extends Thread {
        HintThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                XI5250PanelHandler.this.refreshHint();
            }
        }
    }

    class HintTimer
    implements ActionListener {
        private XI5250Field ivField;

        public HintTimer(XI5250Field aField) {
            this.ivField = aField;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent anEvent) {
            Object object = XI5250PanelHandler.this.ivDispatcher.getTreeLock();
            synchronized (object) {
                if (XI5250PanelHandler.this.ivHintWindow != null && XI5250PanelHandler.this.getEmulator().hasFocus()) {
                    Point pt = XI5250PanelHandler.this.getEmulator().getLocationOnScreen();
                    Rectangle[] rcts = this.ivField.getRowsRects();
                    Rectangle rct = rcts[rcts.length - 1];
                    pt.translate(rct.x, rct.y + rct.height);
                    pt.translate(-4, 4);
                    Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                    pt.x = Math.max(0, Math.min(ss.width - ((XI5250PanelHandler)XI5250PanelHandler.this).ivHintWindow.getSize().width, pt.x));
                    pt.y = Math.max(0, Math.min(ss.height - ((XI5250PanelHandler)XI5250PanelHandler.this).ivHintWindow.getSize().height, pt.y));
                    XI5250PanelHandler.this.ivHintWindow.setLocation(pt.x, pt.y);
                    XI5250PanelHandler.this.ivHintWindow.setVisible(true);
                    if (!XI5250PanelHandler.this.ivHintWindow.isVisible()) {
                        XI5250PanelHandler.this.hideHint();
                    } else {
                        XI5250PanelHandler.this.ivHintWindow.addComponentListener(XI5250PanelHandler.this.ivHintListener);
                    }
                }
            }
        }
    }

    class CrtAdapter
    extends XI5250CrtAdapter {
        CrtAdapter() {
        }

        @Override
        public void fieldActivated(XI5250CrtEvent e) {
            XI5250PanelHandler.this.fieldActivated(e.getField());
        }

        @Override
        public void fieldDeactivated(XI5250CrtEvent e) {
            XI5250PanelHandler.this.fieldDeactivated(e.getField());
        }

        @Override
        public void sizeChanged(XI5250CrtEvent e) {
            XI5250PanelHandler.this.sizeChanged();
        }

        @Override
        public void keyEvent(XI5250CrtEvent e) {
            XI5250PanelHandler.this.keyEvent(e.getKeyEvent());
        }

        @Override
        public void mouseEntersField(XI5250CrtEvent e) {
            XI5250PanelHandler.this.mouseEntersField(e.getField());
        }

        @Override
        public void mouseExitsField(XI5250CrtEvent e) {
            XI5250PanelHandler.this.mouseExitsField(e.getField());
        }
    }

    class EmulatorMouseListener
    extends MouseAdapter {
        EmulatorMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            XI5250PanelHandler.this.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            XI5250PanelHandler.this.mouseReleased(e);
        }
    }
}

