/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XI5250Ord;
import net.infordata.em.tnprot.XITelnet;

public class XITDOrd
extends XI5250Ord {
    protected String ivData;
    protected int ivLen;

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        byte[] buf = new byte[2];
        if (inStream.read(buf) < buf.length) {
            throw new XI5250Exception("EOF reached", 10050122);
        }
        this.ivLen = XITelnet.toInt(buf[0]) << 8 | XITelnet.toInt(buf[1]);
        if (this.ivLen < 0 || this.ivLen > 3564) {
            throw new XI5250Exception("Invalid len", 10050122);
        }
        buf = new byte[this.ivLen];
        int count = inStream.read(buf);
        if (count < buf.length) {
            throw new XI5250Exception("EOF reached, requested: " + this.ivLen + " readden:" + count, 10050122);
        }
        XIEbcdicTranslator translator = this.ivEmulator.getTranslator();
        StringBuilder sb = new StringBuilder(this.ivLen);
        for (int i = 0; i < count; ++i) {
            sb.append(translator.toChar(buf[i]));
        }
        this.ivData = sb.toString();
    }

    @Override
    protected void execute() {
        this.ivEmulator.drawString(this.ivData, this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow());
        this.ivEmulator.setSBA(this.ivEmulator.getSBA() + this.ivData.length());
    }

    public String toString() {
        return super.toString() + " [" + this.ivLen + ",\"" + this.ivData + "\"]";
    }
}

