/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XI5250Ord;

public class XIRAOrd
extends XI5250Ord {
    protected int ivEndRow;
    protected int ivEndCol;
    protected char ivChar;

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        this.ivEndRow = Math.max(0, inStream.read());
        this.ivEndCol = Math.max(0, inStream.read());
        this.ivChar = this.ivEmulator.getTranslator().toChar((byte)Math.max(0, inStream.read()));
        if (this.ivEndRow <= 0 || this.ivEndRow > 27 || this.ivEndCol <= 0 || this.ivEndCol > 132) {
            throw new XI5250Exception("Invalid screen coord: " + this.ivEndRow + "," + this.ivEndCol, 10050122);
        }
    }

    @Override
    protected void execute() {
        int start = this.ivEmulator.toLinearPos(this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow());
        int end = this.ivEmulator.toLinearPos(this.ivEndCol - 1, this.ivEndRow - 1);
        StringBuilder str = new StringBuilder(end - start + 1);
        for (int i = 0; i < end - start + 1; ++i) {
            str.append(this.ivChar);
        }
        this.ivEmulator.drawString(str.toString(), this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow());
        this.ivEmulator.setSBA(this.ivEmulator.getSBA() + (end - start + 1));
    }

    public String toString() {
        return super.toString() + " [" + this.ivEndRow + "," + this.ivEndCol + ",'" + this.ivChar + "']";
    }
}

