/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tn5250.XI5250Ord;
import net.infordata.em.tnprot.XITelnet;

public class XIDataOrd
extends XI5250Ord {
    protected String ivData;
    protected byte ivColor;

    public static boolean isDataCharacter(int bb) {
        switch (bb) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 29: {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException {
        XIEbcdicTranslator translator = this.ivEmulator.getTranslator();
        this.ivColor = 0;
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (true) {
            block6: {
                inStream.mark(1);
                int bb = inStream.read();
                if (bb == -1) break;
                if (XIDataOrd.isDataCharacter(bb)) {
                    if (bb > 31 && bb <= 63) {
                        if (i == 0) {
                            this.ivColor = (byte)bb;
                            break block6;
                        } else {
                            inStream.reset();
                            break;
                        }
                    }
                    sb.append(translator.toChar((byte)bb));
                } else {
                    inStream.reset();
                    break;
                }
            }
            ++i;
        }
        this.ivData = sb.toString();
    }

    @Override
    protected void execute() {
        if (this.ivColor != 0) {
            this.ivEmulator.setDefAttr(XITelnet.toInt(this.ivColor));
            this.ivEmulator.drawString(String.valueOf('\u0001'), this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow());
            this.ivEmulator.setSBA(this.ivEmulator.getSBA() + 1);
        }
        this.ivEmulator.drawString(this.ivData, this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow());
        this.ivEmulator.setSBA(this.ivEmulator.getSBA() + this.ivData.length());
    }

    public String toString() {
        return super.toString() + " [" + XITelnet.toHex(this.ivColor) + ",,\"" + this.ivData + "\"]";
    }
}

