/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.tn5250.XI5250Cmd;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tnprot.XITelnet;

public abstract class XICCCmd
extends XI5250Cmd {
    protected byte[] ivCC;

    @Override
    protected abstract void readFrom5250Stream(InputStream var1) throws IOException, XI5250Exception;

    @Override
    protected abstract void execute();

    protected void readCC(InputStream inStream) throws IOException, XI5250Exception {
        int bb;
        int i;
        this.ivCC = new byte[2];
        for (i = 0; i < 2 && (bb = inStream.read()) != -1; ++i) {
            this.ivCC[i] = (byte)bb;
        }
        if (i < 2) {
            throw new XI5250Exception("CC required", 10030101);
        }
    }

    protected void executeCC1() {
        int cc1 = this.ivCC[0] & 0xE0;
        if (cc1 != 0) {
            this.ivEmulator.ivPendingCmd = null;
            this.ivEmulator.setState(1);
        }
        if (cc1 == 64 || cc1 == 160 || cc1 == 192) {
            for (XI5250Field field : this.ivEmulator.getFields()) {
                if (field.isOrgBypassField()) continue;
                field.resetMDT();
            }
        }
        if (cc1 == 96 || cc1 == 224) {
            for (XI5250Field field : this.ivEmulator.getFields()) {
                field.resetMDT();
            }
        }
        if (cc1 == 128 || cc1 == 192) {
            for (XI5250Field field : this.ivEmulator.getFields()) {
                if (field.isOrgBypassField() || !field.isMDTOn()) continue;
                field.clear();
            }
        }
        if (cc1 == 160 || cc1 == 224) {
            for (XI5250Field field : this.ivEmulator.getFields()) {
                if (field.isBypassField()) continue;
                field.clear();
            }
        }
    }

    protected void executeCC2() {
        if ((this.ivCC[1] & 0x10) != 0) {
            this.ivEmulator.setBlinkingCursor(true);
        } else if ((this.ivCC[1] & 0x20) != 0) {
            this.ivEmulator.setBlinkingCursor(false);
        }
        if ((this.ivCC[1] & 8) != 0) {
            this.ivEmulator.setState(2);
        }
        if ((this.ivCC[1] & 4) != 0) {
            this.ivEmulator.soundAlarm();
        }
    }

    public String toString() {
        return super.toString() + " [CC=[" + XITelnet.toHex(this.ivCC[0]) + "," + XITelnet.toHex(this.ivCC[1]) + "]]";
    }
}

